/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn.configuration;

import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;

public class YarnConfigOptions {
    public static final ConfigOption<String> APP_MASTER_RPC_ADDRESS = ConfigOptions.key((String)"yarn.appmaster.rpc.address").noDefaultValue().withDescription("The hostname or address where the application master RPC system is listening.");
    public static final ConfigOption<Integer> APP_MASTER_RPC_PORT = ConfigOptions.key((String)"yarn.appmaster.rpc.port").defaultValue((Object)-1).withDescription("The port where the application master RPC system is listening.");
    public static final ConfigOption<String> CLASSPATH_INCLUDE_USER_JAR = ConfigOptions.key((String)"yarn.per-job-cluster.include-user-jar").defaultValue((Object)"ORDER").withDescription("Defines whether user-jars are included in the system class path for per-job-clusters as well as their positioning in the path. They can be positioned at the beginning (\"FIRST\"), at the end (\"LAST\"), or be positioned based on their name (\"ORDER\"). Setting this parameter to \"DISABLED\" causes the jar to be included in the user class path instead.");
    public static final ConfigOption<Integer> VCORES = ConfigOptions.key((String)"yarn.containers.vcores").defaultValue((Object)-1).withDescription("The number of virtual cores (vcores) per YARN container. By default, the number of vcores is set to the number of slots per TaskManager, if set, or to 1, otherwise.");
    public static final ConfigOption<String> MAX_FAILED_CONTAINERS = ConfigOptions.key((String)"yarn.maximum-failed-containers").noDefaultValue().withDescription("Maximum number of containers the system is going to reallocate in case of a failure.");
    public static final ConfigOption<String> APPLICATION_ATTEMPTS = ConfigOptions.key((String)"yarn.application-attempts").noDefaultValue().withDescription("Number of ApplicationMaster restarts. Note that that the entire Flink cluster will restart and the YARN Client will loose the connection. Also, the JobManager address will change and you\u2019ll need to set the JM host:port manually. It is recommended to leave this option at 1.");
    public static final ConfigOption<Integer> HEARTBEAT_DELAY_SECONDS = ConfigOptions.key((String)"yarn.heartbeat-delay").defaultValue((Object)5).withDescription("Time between heartbeats with the ResourceManager in seconds.");
    public static final ConfigOption<String> PROPERTIES_FILE_LOCATION = ConfigOptions.key((String)"yarn.properties-file.location").noDefaultValue().withDescription("When a Flink job is submitted to YARN, the JobManager\u2019s host and the number of available processing slots is written into a properties file, so that the Flink client is able to pick those details up. This configuration parameter allows changing the default location of that file (for example for environments sharing a Flink installation between users).");
    public static final ConfigOption<String> APPLICATION_MASTER_PORT = ConfigOptions.key((String)"yarn.application-master.port").defaultValue((Object)"0").withDescription("With this configuration option, users can specify a port, a range of ports or a list of ports for the Application Master (and JobManager) RPC port. By default we recommend using the default value (0) to let the operating system choose an appropriate port. In particular when multiple AMs are running on the same physical host, fixed port assignments prevent the AM from starting. For example when running Flink on YARN on an environment with a restrictive firewall, this option allows specifying a range of allowed ports.");
    public static final ConfigOption<String> APPLICATION_TAGS = ConfigOptions.key((String)"yarn.tags").defaultValue((Object)"").withDescription("A comma-separated list of tags to apply to the Flink YARN application.");

    private YarnConfigOptions() {
    }

    public static enum UserJarInclusion {
        DISABLED,
        FIRST,
        LAST,
        ORDER;

    }
}

