/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn.entrypoint;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.configuration.WebOptions;
import org.apache.flink.runtime.clusterframework.BootstrapTools;
import org.apache.flink.runtime.security.SecurityConfiguration;
import org.apache.flink.runtime.security.SecurityContext;
import org.apache.flink.runtime.security.SecurityUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.yarn.cli.FlinkYarnSessionCli;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.slf4j.Logger;

public class YarnEntrypointUtils {
    public static SecurityContext installSecurityContext(Configuration configuration, String workingDirectory) throws Exception {
        SecurityConfiguration sc = new SecurityConfiguration(configuration);
        SecurityUtils.install((SecurityConfiguration)sc);
        return SecurityUtils.getInstalledContext();
    }

    public static Configuration loadConfiguration(String workingDirectory, Map<String, String> env, Logger log) {
        String keytabPath;
        Configuration configuration = GlobalConfiguration.loadConfiguration((String)workingDirectory);
        String remoteKeytabPrincipal = env.get("_KEYTAB_PRINCIPAL");
        String zooKeeperNamespace = env.get("_ZOOKEEPER_NAMESPACE");
        Map<String, String> dynamicProperties = FlinkYarnSessionCli.getDynamicProperties(env.get("_DYNAMIC_PROPERTIES"));
        String hostname = env.get(ApplicationConstants.Environment.NM_HOST.key());
        Preconditions.checkState((hostname != null ? 1 : 0) != 0, (String)"ApplicationMaster hostname variable %s not set", (Object[])new Object[]{ApplicationConstants.Environment.NM_HOST.key()});
        configuration.setString(JobManagerOptions.ADDRESS, hostname);
        configuration.setString(RestOptions.ADDRESS, hostname);
        for (Map.Entry<String, String> property : dynamicProperties.entrySet()) {
            configuration.setString(property.getKey(), property.getValue());
        }
        if (zooKeeperNamespace != null) {
            configuration.setString(HighAvailabilityOptions.HA_CLUSTER_ID, zooKeeperNamespace);
        }
        if (configuration.getInteger(WebOptions.PORT, 0) >= 0) {
            configuration.setInteger(WebOptions.PORT, 0);
        }
        if (configuration.getInteger(RestOptions.PORT) >= 0) {
            configuration.setInteger(RestOptions.PORT, 0);
        }
        BootstrapTools.substituteDeprecatedConfigPrefix((Configuration)configuration, (String)"yarn.application-master.env.", (String)"containerized.master.env.");
        BootstrapTools.substituteDeprecatedConfigPrefix((Configuration)configuration, (String)"yarn.taskmanager.env.", (String)"containerized.taskmanager.env.");
        if (env.get("_KEYTAB_PATH") == null) {
            keytabPath = null;
        } else {
            File f = new File(workingDirectory, "krb5.keytab");
            keytabPath = f.getAbsolutePath();
        }
        if (keytabPath != null && remoteKeytabPrincipal != null) {
            configuration.setString(SecurityOptions.KERBEROS_LOGIN_KEYTAB, keytabPath);
            configuration.setString(SecurityOptions.KERBEROS_LOGIN_PRINCIPAL, remoteKeytabPrincipal);
        }
        String localDirs = env.get(ApplicationConstants.Environment.LOCAL_DIRS.key());
        BootstrapTools.updateTmpDirectoriesInConfiguration((Configuration)configuration, (String)localDirs);
        return configuration;
    }

    public static void logYarnEnvironmentInformation(Map<String, String> env, Logger log) throws IOException {
        String yarnClientUsername = env.get("HADOOP_USER_NAME");
        Preconditions.checkArgument((yarnClientUsername != null ? 1 : 0) != 0, (String)"YARN client user name environment variable %s not set", (Object[])new Object[]{"HADOOP_USER_NAME"});
        UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
        log.info("YARN daemon is running as: {} Yarn client user obtainer: {}", (Object)currentUser.getShortUserName(), (Object)yarnClientUsername);
    }
}

