/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn.entrypoint;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.entrypoint.ClusterInformation;
import org.apache.flink.runtime.entrypoint.JobClusterEntrypoint;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.resourcemanager.ResourceManager;
import org.apache.flink.runtime.resourcemanager.ResourceManagerConfiguration;
import org.apache.flink.runtime.resourcemanager.ResourceManagerRuntimeServices;
import org.apache.flink.runtime.resourcemanager.ResourceManagerRuntimeServicesConfiguration;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.security.SecurityContext;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.JvmShutdownSafeguard;
import org.apache.flink.runtime.util.SignalHandler;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.yarn.YarnResourceManager;
import org.apache.flink.yarn.configuration.YarnConfigOptions;
import org.apache.flink.yarn.entrypoint.YarnEntrypointUtils;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.slf4j.Logger;

public class YarnJobClusterEntrypoint
extends JobClusterEntrypoint {
    public static final String JOB_GRAPH_FILE_PATH = "flink.jobgraph.path";
    private final String workingDirectory;

    public YarnJobClusterEntrypoint(Configuration configuration, String workingDirectory) {
        super(configuration);
        this.workingDirectory = (String)Preconditions.checkNotNull((Object)workingDirectory);
    }

    protected SecurityContext installSecurityContext(Configuration configuration) throws Exception {
        return YarnEntrypointUtils.installSecurityContext(configuration, this.workingDirectory);
    }

    protected String getRPCPortRange(Configuration configuration) {
        return configuration.getString(YarnConfigOptions.APPLICATION_MASTER_PORT);
    }

    protected ResourceManager<?> createResourceManager(Configuration configuration, ResourceID resourceId, RpcService rpcService, HighAvailabilityServices highAvailabilityServices, HeartbeatServices heartbeatServices, MetricRegistry metricRegistry, FatalErrorHandler fatalErrorHandler, ClusterInformation clusterInformation, @Nullable String webInterfaceUrl) throws Exception {
        ResourceManagerConfiguration rmConfiguration = ResourceManagerConfiguration.fromConfiguration((Configuration)configuration);
        ResourceManagerRuntimeServicesConfiguration rmServicesConfiguration = ResourceManagerRuntimeServicesConfiguration.fromConfiguration((Configuration)configuration);
        ResourceManagerRuntimeServices rmRuntimeServices = ResourceManagerRuntimeServices.fromConfiguration((ResourceManagerRuntimeServicesConfiguration)rmServicesConfiguration, (HighAvailabilityServices)highAvailabilityServices, (ScheduledExecutor)rpcService.getScheduledExecutor());
        return new YarnResourceManager(rpcService, "resourcemanager", resourceId, configuration, System.getenv(), rmConfiguration, highAvailabilityServices, heartbeatServices, rmRuntimeServices.getSlotManager(), metricRegistry, rmRuntimeServices.getJobLeaderIdService(), clusterInformation, fatalErrorHandler, webInterfaceUrl);
    }

    /*
     * Exception decompiling
     */
    protected JobGraph retrieveJobGraph(Configuration configuration) throws FlinkException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void registerShutdownActions(CompletableFuture<ApplicationStatus> terminationFuture) {
        terminationFuture.thenAccept(status -> this.shutDownAndTerminate(status.processExitCode(), (ApplicationStatus)status, null, true));
    }

    public static void main(String[] args) {
        EnvironmentInformation.logEnvironmentInfo((Logger)LOG, (String)YarnJobClusterEntrypoint.class.getSimpleName(), (String[])args);
        SignalHandler.register((Logger)LOG);
        JvmShutdownSafeguard.installAsShutdownHook((Logger)LOG);
        Map<String, String> env = System.getenv();
        String workingDirectory = env.get(ApplicationConstants.Environment.PWD.key());
        Preconditions.checkArgument((workingDirectory != null ? 1 : 0) != 0, (String)"Working directory variable (%s) not set", (Object[])new Object[]{ApplicationConstants.Environment.PWD.key()});
        try {
            YarnEntrypointUtils.logYarnEnvironmentInformation(env, LOG);
        }
        catch (IOException e) {
            LOG.warn("Could not log YARN environment information.", (Throwable)e);
        }
        Configuration configuration = YarnEntrypointUtils.loadConfiguration(workingDirectory, env, LOG);
        YarnJobClusterEntrypoint yarnJobClusterEntrypoint = new YarnJobClusterEntrypoint(configuration, workingDirectory);
        yarnJobClusterEntrypoint.startCluster();
    }
}

