/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn.entrypoint;

import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.entrypoint.ClusterInformation;
import org.apache.flink.runtime.entrypoint.SessionClusterEntrypoint;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.resourcemanager.ResourceManager;
import org.apache.flink.runtime.resourcemanager.ResourceManagerConfiguration;
import org.apache.flink.runtime.resourcemanager.ResourceManagerRuntimeServices;
import org.apache.flink.runtime.resourcemanager.ResourceManagerRuntimeServicesConfiguration;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.security.SecurityContext;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.JvmShutdownSafeguard;
import org.apache.flink.runtime.util.SignalHandler;
import org.apache.flink.util.Preconditions;
import org.apache.flink.yarn.YarnResourceManager;
import org.apache.flink.yarn.configuration.YarnConfigOptions;
import org.apache.flink.yarn.entrypoint.YarnEntrypointUtils;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.slf4j.Logger;

public class YarnSessionClusterEntrypoint
extends SessionClusterEntrypoint {
    private final String workingDirectory;

    public YarnSessionClusterEntrypoint(Configuration configuration, String workingDirectory) {
        super(configuration);
        this.workingDirectory = (String)Preconditions.checkNotNull((Object)workingDirectory);
    }

    protected SecurityContext installSecurityContext(Configuration configuration) throws Exception {
        return YarnEntrypointUtils.installSecurityContext(configuration, this.workingDirectory);
    }

    protected String getRPCPortRange(Configuration configuration) {
        return configuration.getString(YarnConfigOptions.APPLICATION_MASTER_PORT);
    }

    protected ResourceManager<?> createResourceManager(Configuration configuration, ResourceID resourceId, RpcService rpcService, HighAvailabilityServices highAvailabilityServices, HeartbeatServices heartbeatServices, MetricRegistry metricRegistry, FatalErrorHandler fatalErrorHandler, ClusterInformation clusterInformation, @Nullable String webInterfaceUrl) throws Exception {
        ResourceManagerConfiguration rmConfiguration = ResourceManagerConfiguration.fromConfiguration((Configuration)configuration);
        ResourceManagerRuntimeServicesConfiguration rmServicesConfiguration = ResourceManagerRuntimeServicesConfiguration.fromConfiguration((Configuration)configuration);
        ResourceManagerRuntimeServices rmRuntimeServices = ResourceManagerRuntimeServices.fromConfiguration((ResourceManagerRuntimeServicesConfiguration)rmServicesConfiguration, (HighAvailabilityServices)highAvailabilityServices, (ScheduledExecutor)rpcService.getScheduledExecutor());
        return new YarnResourceManager(rpcService, "resourcemanager", resourceId, configuration, System.getenv(), rmConfiguration, highAvailabilityServices, heartbeatServices, rmRuntimeServices.getSlotManager(), metricRegistry, rmRuntimeServices.getJobLeaderIdService(), clusterInformation, fatalErrorHandler, webInterfaceUrl);
    }

    public static void main(String[] args) {
        EnvironmentInformation.logEnvironmentInfo((Logger)LOG, (String)YarnSessionClusterEntrypoint.class.getSimpleName(), (String[])args);
        SignalHandler.register((Logger)LOG);
        JvmShutdownSafeguard.installAsShutdownHook((Logger)LOG);
        Map<String, String> env = System.getenv();
        String workingDirectory = env.get(ApplicationConstants.Environment.PWD.key());
        Preconditions.checkArgument((workingDirectory != null ? 1 : 0) != 0, (String)"Working directory variable (%s) not set", (Object[])new Object[]{ApplicationConstants.Environment.PWD.key()});
        try {
            YarnEntrypointUtils.logYarnEnvironmentInformation(env, LOG);
        }
        catch (IOException e) {
            LOG.warn("Could not log YARN environment information.", (Throwable)e);
        }
        Configuration configuration = YarnEntrypointUtils.loadConfiguration(workingDirectory, env, LOG);
        YarnSessionClusterEntrypoint yarnSessionClusterEntrypoint = new YarnSessionClusterEntrypoint(configuration, workingDirectory);
        yarnSessionClusterEntrypoint.startCluster();
    }
}

