/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class Spline3 {
    private static final Logger log = LoggingManager.getLoggerForClass();
    protected float[][] _coefficients;
    protected float[][] _A;
    protected float[] _B;
    protected float[] _r;
    protected float[] _rS;
    protected int _m;
    protected int _n;
    protected static final float DEFAULT_PRECISION = 0.1f;
    protected static final int DEFAULT_MAX_ITERATIONS = 100;
    protected float _minPrecision = 0.1f;
    protected int _maxIterations = 100;

    public Spline3(float[] r) {
        int n;
        this._m = n = r.length;
        this._r = new float[n];
        for (int i = 0; i < n; ++i) {
            this._r[i] = r[i];
        }
        this._n = n - 2;
        try {
            long startTime = System.currentTimeMillis();
            this.interpolation();
            if (log.isDebugEnabled()) {
                long endTime = System.currentTimeMillis();
                long elapsedTime = endTime - startTime;
                if (log.isDebugEnabled()) {
                    log.debug("New Spline curve interpolated in ");
                    log.debug(elapsedTime + " ms");
                }
            }
        }
        catch (Exception e) {
            log.error("Error when interpolating : ", (Throwable)e);
        }
    }

    protected void interpolation() {
        this._rS = new float[this._m];
        this._B = new float[this._n];
        this._A = new float[this._n][this._n];
        this._coefficients = new float[this._n + 1][4];
        int i = 0;
        int j = 0;
        for (i = 0; i < this._n; ++i) {
            this._B[i] = 0.0f;
            for (j = 0; j < this._n; ++j) {
                this._A[i][j] = 0.0f;
            }
            for (j = 0; j < 4; ++j) {
                this._coefficients[i][j] = 0.0f;
            }
        }
        for (i = 0; i < this._n; ++i) {
            this._rS[i] = 0.0f;
        }
        for (i = 0; i < this._n; ++i) {
            this._A[i][i] = 4.0f;
        }
        for (i = 1; i < this._n; ++i) {
            this._A[i][i - 1] = 1.0f;
            this._A[i - 1][i] = 1.0f;
        }
        for (i = 0; i < this._n; ++i) {
            this._B[i] = 6.0f * (this._r[i + 2] - 2.0f * this._r[i + 1] + this._r[i]);
        }
        this.jacobi();
        for (i = 0; i < this._n + 1; ++i) {
            this._coefficients[i][0] = this._r[i];
            this._coefficients[i][1] = this._r[i + 1] - this._r[i] - (this._rS[i + 1] + 2.0f * this._rS[i]) / 6.0f;
            this._coefficients[i][2] = this._rS[i] / 2.0f;
            this._coefficients[i][3] = (this._rS[i + 1] - this._rS[i]) / 6.0f;
        }
    }

    protected void jacobi() {
        int i = 0;
        int j = 0;
        int iterations = 0;
        float[] newX = new float[this._n];
        float[] oldX = new float[this._n];
        if (!this.converge() && log.isDebugEnabled()) {
            log.debug("Warning : equation system resolving is unstable");
        }
        for (i = 0; i < this._n; ++i) {
            newX[i] = 0.0f;
            oldX[i] = 0.0f;
        }
        while (this.precision(oldX, newX) > this._minPrecision && iterations < this._maxIterations) {
            System.arraycopy(oldX, 0, newX, 0, this._n);
            for (i = 0; i < this._n; ++i) {
                newX[i] = this._B[i];
                for (j = 0; j < i; ++j) {
                    newX[i] = newX[i] - this._A[i][j] * oldX[j];
                }
                for (j = i + 1; j < this._n; ++j) {
                    newX[i] = newX[i] - this._A[i][j] * oldX[j];
                }
                newX[i] = newX[i] / this._A[i][i];
            }
            ++iterations;
        }
        if (this.precision(oldX, newX) < this._minPrecision) {
            if (log.isDebugEnabled()) {
                log.debug("Minimal precision (");
                log.debug(this._minPrecision + ") reached after ");
                log.debug(iterations + " iterations");
            }
        } else if (iterations > this._maxIterations && log.isDebugEnabled()) {
            log.debug("Maximal number of iterations (");
            log.debug(this._maxIterations + ") reached");
            log.debug("Warning : precision is only ");
            log.debug("" + this.precision(oldX, newX));
            log.debug(", divergence is possible");
        }
        System.arraycopy(newX, 0, this._rS, 1, this._n);
    }

    protected boolean converge() {
        boolean converge = true;
        int i = 0;
        int j = 0;
        float lineSum = 0.0f;
        for (i = 0; i < this._n; ++i) {
            if (!converge) continue;
            lineSum = 0.0f;
            for (j = 0; j < this._n; ++j) {
                lineSum += Math.abs(this._A[i][j]);
            }
            if (!((lineSum -= Math.abs(this._A[i][i])) > Math.abs(this._A[i][i]))) continue;
            converge = false;
        }
        return converge;
    }

    protected float precision(float[] oldX, float[] newX) {
        float N = 0.0f;
        float D = 0.0f;
        float erreur = 0.0f;
        int i = 0;
        for (i = 0; i < this._n; ++i) {
            N += Math.abs(newX[i] - oldX[i]);
            D += Math.abs(newX[i]);
        }
        erreur = D != 0.0f ? N / D : Float.MAX_VALUE;
        return erreur;
    }

    public float value(float t) {
        int i = 0;
        int splineNumber = 0;
        float abscissa = 0.0f;
        float result = 0.0f;
        if (t < 0.0f || t > (float)(this._m - 1)) {
            if (log.isDebugEnabled()) {
                log.debug("Warning : abscissa " + t + " out of bounds [0, " + (this._m - 1) + "]");
            }
            t = t < 0.0f ? 0.0f : (float)(this._m - 1);
        }
        splineNumber = (int)Math.floor(t);
        if (t == (float)(this._m - 1)) {
            --splineNumber;
        }
        abscissa = t - (float)splineNumber;
        for (i = 0; i < 4; ++i) {
            result *= abscissa;
            result += this._coefficients[splineNumber][3 - i];
        }
        return result;
    }

    public void debugCheck() {
        int i = 0;
        for (i = 0; i < this._m; ++i) {
            log.info("Point " + i + " : ");
            log.info(this._r[i] + " =? " + this.value(i));
        }
    }

    public int[] getPlots(int width, int height) {
        int i;
        int[] plot = new int[width];
        float[] y = new float[width];
        float max = -2.1474836E9f;
        float min = 2.1474836E9f;
        for (i = 0; i < width; ++i) {
            y[i] = this.value((float)i * (float)(this._m - 1) / (float)width);
            if (y[i] < min) {
                min = y[i];
            }
            if (!(y[i] > max)) continue;
            max = y[i];
        }
        if (min < 0.0f) {
            min = 0.0f;
        }
        for (i = 0; i < width; ++i) {
            plot[i] = Math.round((y[i] - min) * (float)(height - 1) / (max - min));
        }
        return plot;
    }

    public void setPrecision(float precision) {
        this._minPrecision = precision;
    }

    public float getPrecision() {
        return this._minPrecision;
    }

    public void setToDefaultPrecision() {
        this._minPrecision = 0.1f;
    }

    public float getDefaultPrecision() {
        return 0.1f;
    }

    public void setMaxIterations(int iterations) {
        this._maxIterations = iterations;
    }

    public int getMaxIterations() {
        return this._maxIterations;
    }

    public void setToDefaultMaxIterations() {
        this._maxIterations = 100;
    }

    public int getDefaultMaxIterations() {
        return 100;
    }
}

