/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.maths.random;

import org.uncommons.maths.random.DevRandomSeedGenerator;
import org.uncommons.maths.random.RandomDotOrgSeedGenerator;
import org.uncommons.maths.random.SecureRandomSeedGenerator;
import org.uncommons.maths.random.SeedException;
import org.uncommons.maths.random.SeedGenerator;

public final class DefaultSeedGenerator
implements SeedGenerator {
    private static final DefaultSeedGenerator INSTANCE = new DefaultSeedGenerator();
    private static final SeedGenerator[] GENERATORS = new SeedGenerator[]{new DevRandomSeedGenerator(), new RandomDotOrgSeedGenerator(), new SecureRandomSeedGenerator()};

    private DefaultSeedGenerator() {
    }

    public static DefaultSeedGenerator getInstance() {
        return INSTANCE;
    }

    public byte[] generateSeed(int length) {
        for (SeedGenerator generator : GENERATORS) {
            try {
                return generator.generateSeed(length);
            }
            catch (SeedException ex) {
            }
            catch (SecurityException ex) {
                // empty catch block
            }
        }
        throw new IllegalStateException("All available seed generation strategies failed.");
    }
}

