/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.maths.random;

import java.util.Random;
import org.uncommons.maths.binary.BinaryUtils;
import org.uncommons.maths.random.DefaultSeedGenerator;
import org.uncommons.maths.random.RepeatableRNG;
import org.uncommons.maths.random.SeedException;
import org.uncommons.maths.random.SeedGenerator;

public class JavaRNG
extends Random
implements RepeatableRNG {
    private static final int SEED_SIZE_BYTES = 8;
    private final byte[] seed;

    public JavaRNG() {
        this(DefaultSeedGenerator.getInstance().generateSeed(8));
    }

    public JavaRNG(SeedGenerator seedGenerator) throws SeedException {
        this(seedGenerator.generateSeed(8));
    }

    public JavaRNG(byte[] seed) {
        super(JavaRNG.convertBytesToLong(seed));
        if (seed == null || seed.length != 8) {
            throw new IllegalArgumentException("Java RNG requires a 64-bit (8-byte) seed.");
        }
        this.seed = (byte[])seed.clone();
        System.out.println("Standard Java RNG created with seed " + BinaryUtils.convertBytesToHexString(seed));
    }

    public byte[] getSeed() {
        return (byte[])this.seed.clone();
    }

    private static long convertBytesToLong(byte[] bytes) {
        if (bytes.length > 8) {
            throw new IllegalArgumentException("Number of bytes must be less than or equal to 8.");
        }
        long value = 0L;
        for (byte b : bytes) {
            value <<= 8;
            value += (long)b;
        }
        return value;
    }
}

