/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.maths.random;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.URL;
import java.net.URLConnection;
import org.uncommons.maths.random.SeedException;
import org.uncommons.maths.random.SeedGenerator;

public class RandomDotOrgSeedGenerator
implements SeedGenerator {
    private static final int CACHE_SIZE = 1024;
    private static final byte[] CACHE = new byte[1024];
    private static final String RANDOM_URL = "http://www.random.org/cgi-bin/randbyte?nbytes=1024&format=d";
    private static final String USER_AGENT = RandomDotOrgSeedGenerator.class.getName();
    private static int cacheOffset = 1024;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] generateSeed(int length) throws SeedException {
        byte[] byArray = CACHE;
        synchronized (CACHE) {
            if (cacheOffset + length >= 1024) {
                try {
                    this.refreshCache();
                }
                catch (IOException ex) {
                    throw new SeedException("Failed downloading bytes from random.org", ex);
                }
            }
            byte[] seedData = new byte[length];
            System.arraycopy(CACHE, cacheOffset, seedData, 0, length);
            cacheOffset += length;
            System.out.println(length + " bytes of seed data acquired from http://www.random.org");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return seedData;
        }
    }

    private void refreshCache() throws IOException {
        URL url = new URL(RANDOM_URL);
        URLConnection connection = url.openConnection();
        connection.setRequestProperty("User-Agent", USER_AGENT);
        StreamTokenizer tokenizer = new StreamTokenizer(new InputStreamReader(connection.getInputStream()));
        int index = -1;
        while (tokenizer.nextToken() != -1) {
            if (tokenizer.ttype != -2) {
                throw new IOException("Received invalid data.");
            }
            RandomDotOrgSeedGenerator.CACHE[++index] = (byte)tokenizer.nval;
        }
        if (index < CACHE.length - 1) {
            throw new IOException("Insufficient data received.");
        }
        cacheOffset = 0;
    }
}

