/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.checkstyle.exec;

import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CheckstyleResults {
    private Map<String, List<AuditEvent>> files = new HashMap<String, List<AuditEvent>>();
    private Configuration configuration;

    public List<AuditEvent> getFileViolations(String file) {
        LinkedList<AuditEvent> violations;
        if (this.files.containsKey(file)) {
            violations = this.files.get(file);
        } else {
            violations = new LinkedList();
            if (file != null) {
                this.files.put(file, violations);
            }
        }
        return violations;
    }

    public void setFileViolations(String file, List<AuditEvent> violations) {
        if (file != null) {
            this.files.put(file, violations);
        }
    }

    public Map<String, List<AuditEvent>> getFiles() {
        return this.files;
    }

    public void setFiles(Map<String, List<AuditEvent>> files) {
        this.files = files;
    }

    public int getFileCount() {
        return this.files.size();
    }

    public long getSeverityCount(SeverityLevel level) {
        long count = 0L;
        for (List<AuditEvent> errors : this.files.values()) {
            count += this.getSeverityCount(errors, level);
        }
        return count;
    }

    public long getSeverityCount(String file, SeverityLevel level) {
        long count = 0L;
        if (!this.files.containsKey(file)) {
            return count;
        }
        List<AuditEvent> violations = this.files.get(file);
        count = this.getSeverityCount(violations, level);
        return count;
    }

    public long getSeverityCount(List<AuditEvent> violations, SeverityLevel level) {
        long count = 0L;
        for (AuditEvent event : violations) {
            if (!event.getSeverityLevel().equals((Object)level)) continue;
            ++count;
        }
        return count;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }
}

