/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitplatform;

import org.apache.maven.surefire.testset.TestListResolver;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.PostDiscoveryFilter;

class TestMethodFilter
implements PostDiscoveryFilter {
    private final TestListResolver testListResolver;

    TestMethodFilter(TestListResolver testListResolver) {
        this.testListResolver = testListResolver;
    }

    public FilterResult apply(TestDescriptor descriptor) {
        boolean shouldRun = descriptor.getSource().filter(MethodSource.class::isInstance).map(MethodSource.class::cast).map(this::shouldRun).orElse(true);
        return FilterResult.includedIf((boolean)shouldRun);
    }

    private boolean shouldRun(MethodSource source) {
        String testClass = TestListResolver.toClassFileName((String)source.getClassName());
        String testMethod = source.getMethodName();
        return this.testListResolver.shouldRun(testClass, testMethod);
    }
}

