/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.codec;

import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.InvalidMarkException;
import java.nio.ReadOnlyBufferException;

public final class IoBuffer {
    private static final int BYTE_MASK = 255;
    private static final long BYTE_MASK_L = 255L;
    private ByteOrder bo = ByteOrder.BIG_ENDIAN;
    private int capacity = 0;
    private boolean direct = true;
    private BufferNode head;
    private BufferNode tail;
    private Pointer limit = new Pointer();
    private Pointer mark = new Pointer();
    private Pointer position = new Pointer();
    private boolean readonly = false;

    public static IoBuffer allocate(int capacity) {
        return IoBuffer.wrap(ByteBuffer.allocate(capacity));
    }

    public static IoBuffer allocateDirect(int capacity) {
        return IoBuffer.wrap(ByteBuffer.allocateDirect(capacity));
    }

    public static IoBuffer newInstance() {
        return new IoBuffer();
    }

    public static IoBuffer wrap(byte[] ... arrays) {
        IoBuffer ioBuffer = new IoBuffer();
        for (byte[] array : arrays) {
            ioBuffer.add(ByteBuffer.wrap(array));
        }
        return ioBuffer;
    }

    public static IoBuffer wrap(byte[] array, int offset, int length) {
        return IoBuffer.wrap(ByteBuffer.wrap(array, offset, length));
    }

    public static IoBuffer wrap(ByteBuffer ... buffers) {
        IoBuffer ioBuffer = new IoBuffer();
        for (ByteBuffer b : buffers) {
            ioBuffer.add(b);
        }
        return ioBuffer;
    }

    private IoBuffer() {
        this.limit(0);
        this.position(0);
        this.mark = null;
    }

    public IoBuffer add(ByteBuffer ... buffers) {
        for (ByteBuffer buffer : buffers) {
            this.enqueue(buffer.slice());
        }
        return this;
    }

    public byte[] array() {
        if (this.capacity == 0) {
            return new byte[0];
        }
        if (this.head.hasNext()) {
            throw new UnsupportedOperationException();
        }
        return this.head.getBuffer().array();
    }

    public int arrayOffset() {
        if (this.capacity == 0) {
            return 0;
        }
        if (this.head.hasNext()) {
            throw new UnsupportedOperationException();
        }
        return this.head.getBuffer().arrayOffset();
    }

    public InputStream asInputStream() {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                return IoBuffer.this.hasRemaining() ? IoBuffer.this.get() & 0xFF : -1;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                if (!IoBuffer.this.hasRemaining()) {
                    return -1;
                }
                int toRead = Math.min(IoBuffer.this.remaining(), len);
                IoBuffer.this.get(b, off, toRead);
                return toRead;
            }
        };
    }

    public IoBuffer asReadOnlyBuffer() {
        IoBuffer buffer = this.duplicate();
        buffer.readonly = true;
        return buffer;
    }

    public int capacity() {
        return this.capacity;
    }

    public IoBuffer clear() {
        this.position = this.getPointerByPosition(0);
        this.limit = this.getPointerByPosition(this.capacity);
        this.mark = null;
        return this;
    }

    public IoBuffer compact() {
        for (int i = 0; i < this.remaining(); ++i) {
            this.put(i, this.get(i + this.position.getPosition()));
        }
        this.position(this.limit() - this.position());
        this.limit(this.capacity);
        this.mark = null;
        return this;
    }

    public IoBuffer duplicate() {
        IoBuffer buffer = new IoBuffer();
        for (BufferNode node = this.head; node != null; node = node.getNext()) {
            ByteBuffer byteBuffer = node.getBuffer().duplicate();
            byteBuffer.rewind();
            buffer.enqueue(byteBuffer);
        }
        buffer.position(this.position());
        buffer.limit(this.limit());
        buffer.mark = this.mark != null ? this.getPointerByPosition(this.mark.getPosition()) : null;
        buffer.readonly = this.readonly;
        return buffer;
    }

    private void enqueue(ByteBuffer buffer) {
        if (buffer.isReadOnly()) {
            this.readonly = true;
        }
        if (!buffer.isDirect()) {
            this.direct = false;
        }
        if (buffer.remaining() > 0) {
            BufferNode newnode = new BufferNode(buffer, this.capacity);
            this.capacity += buffer.capacity();
            if (this.head == null) {
                this.head = newnode;
                this.position = this.getPointerByPosition(0);
            } else {
                this.tail.setNext(newnode);
            }
            this.tail = newnode;
            this.limit = this.getPointerByPosition(this.capacity);
        }
    }

    public boolean equals(Object ob) {
        if (this == ob) {
            return true;
        }
        if (!(ob instanceof IoBuffer)) {
            return false;
        }
        IoBuffer that = (IoBuffer)ob;
        if (this.remaining() != that.remaining()) {
            return false;
        }
        int p = this.position();
        int q = that.position();
        while (this.hasRemaining() && that.hasRemaining()) {
            if (this.get() == that.get()) continue;
            this.position(p);
            that.position(q);
            return false;
        }
        this.position(p);
        that.position(q);
        return true;
    }

    public IoBuffer extend(int size) {
        ByteBuffer extension = this.isDirect() ? ByteBuffer.allocateDirect(size) : ByteBuffer.allocate(size);
        this.add(extension);
        return this;
    }

    public IoBuffer flip() {
        this.limit = this.position;
        this.position = this.getPointerByPosition(0);
        return this;
    }

    public byte get() {
        if (!this.hasRemaining()) {
            throw new BufferUnderflowException();
        }
        return this.get(this.position);
    }

    public IoBuffer get(byte[] dst) {
        this.get(dst, 0, dst.length);
        return this;
    }

    public IoBuffer get(byte[] dst, int offset, int length) {
        int blocksize;
        if (this.remaining() < length) {
            throw new BufferUnderflowException();
        }
        int currentOffset = offset;
        for (int remainsToCopy = length; remainsToCopy > 0; remainsToCopy -= blocksize) {
            this.position.updatePos();
            this.position.getNode().getBuffer().position(this.position.getPositionInNode());
            ByteBuffer currentBuffer = this.position.getNode().getBuffer();
            blocksize = Math.min(remainsToCopy, currentBuffer.remaining());
            this.position.getNode().getBuffer().get(dst, currentOffset, blocksize);
            currentOffset += blocksize;
            this.position.incrementPosition(blocksize);
            this.position.getNode().getBuffer().position(0);
        }
        return this;
    }

    public byte get(int index) {
        if (index >= this.limit.getPosition()) {
            throw new IndexOutOfBoundsException();
        }
        return this.get(this.getPointerByPosition(index));
    }

    private byte get(Pointer pos) {
        pos.updatePos();
        byte b = pos.getNode().getBuffer().get(pos.getPositionInNode());
        pos.incrPosition();
        return b;
    }

    public char getChar() {
        return this.getChar(this.position);
    }

    public char getChar(int index) {
        return this.getChar(this.getPointerByPosition(index));
    }

    private char getChar(Pointer position) {
        return (char)this.getShort(position);
    }

    public double getDouble() {
        return Double.longBitsToDouble(this.getLong());
    }

    public double getDouble(int index) {
        return this.getDouble(this.getPointerByPosition(index));
    }

    private double getDouble(Pointer pos) {
        return Double.longBitsToDouble(this.getLong(pos));
    }

    public float getFloat() {
        return this.getFloat(this.position);
    }

    public float getFloat(int index) {
        return this.getFloat(this.getPointerByPosition(index));
    }

    private float getFloat(Pointer pos) {
        return Float.intBitsToFloat(this.getInt(pos));
    }

    public int getInt() {
        return this.getInt(this.position);
    }

    public int getInt(int index) {
        return this.getInt(this.getPointerByPosition(index));
    }

    private int getInt(Pointer pos) {
        if (pos.getPosition() > this.capacity - 4) {
            throw new BufferUnderflowException();
        }
        int out = 0;
        for (int i = 0; i < 32; i += 8) {
            out |= (this.get(pos) & 0xFF) << (this.bo == ByteOrder.BIG_ENDIAN ? 24 - i : i);
        }
        return out;
    }

    public long getLong() {
        return this.getLong(this.position);
    }

    public long getLong(int index) {
        return this.getLong(this.getPointerByPosition(index));
    }

    private long getLong(Pointer pos) {
        if (pos.getPosition() > this.capacity - 8) {
            throw new BufferUnderflowException();
        }
        long out = 0L;
        for (int i = 0; i < 64; i += 8) {
            out |= ((long)this.get(pos) & 0xFFL) << (this.bo == ByteOrder.BIG_ENDIAN ? 56 - i : i);
        }
        return out;
    }

    private Pointer getPointerByPosition(int pos) {
        return new Pointer(pos);
    }

    public short getShort() {
        return this.getShort(this.position);
    }

    public long getShort(int index) {
        return this.getShort(this.getPointerByPosition(index));
    }

    private short getShort(Pointer pos) {
        if (pos.getPosition() > this.capacity - 2) {
            throw new BufferUnderflowException();
        }
        if (this.bo == ByteOrder.BIG_ENDIAN) {
            return (short)((this.get(pos) & 0xFF) << 8 | this.get(pos) & 0xFF);
        }
        return (short)(this.get(pos) & 0xFF | (this.get(pos) & 0xFF) << 8);
    }

    public int hashCode() {
        int hash = 0;
        Pointer oldPos = this.position.duplicate();
        while (this.hasRemaining()) {
            hash *= 31;
            hash += this.get();
        }
        this.position = oldPos;
        return hash;
    }

    public boolean hasRemaining() {
        return this.remaining() > 0;
    }

    public boolean isDirect() {
        return this.direct;
    }

    public boolean isReadOnly() {
        return this.readonly;
    }

    public int limit() {
        return this.limit.getPosition();
    }

    public void limit(int newLimit) {
        this.limit = this.getPointerByPosition(newLimit);
    }

    public void mark() {
        this.mark = this.position.duplicate();
    }

    public ByteOrder order() {
        return this.bo;
    }

    public IoBuffer order(ByteOrder bo) {
        this.bo = bo != null ? bo : ByteOrder.LITTLE_ENDIAN;
        return this;
    }

    public int position() {
        return this.position.getPosition();
    }

    public void position(int newPosition) {
        if (newPosition > this.limit() || newPosition < 0) {
            throw new IllegalArgumentException();
        }
        if (this.mark != null && this.mark.getPosition() > newPosition) {
            this.mark = null;
        }
        this.position.setPosition(newPosition);
    }

    public IoBuffer put(byte b) {
        if (this.readonly) {
            throw new ReadOnlyBufferException();
        }
        if (this.position.getPosition() >= this.limit.getPosition()) {
            throw new BufferUnderflowException();
        }
        this.put(this.position, b);
        return this;
    }

    public IoBuffer put(byte[] src) {
        this.put(src, 0, src.length);
        return this;
    }

    public IoBuffer put(ByteBuffer src) {
        if (this.remaining() < src.remaining()) {
            throw new BufferOverflowException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        while (src.hasRemaining()) {
            this.put(src.get());
        }
        return this;
    }

    public IoBuffer put(IoBuffer src) {
        if (src == this) {
            throw new IllegalArgumentException();
        }
        if (this.remaining() < src.remaining()) {
            throw new BufferOverflowException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        while (src.hasRemaining()) {
            this.put(src.get());
        }
        return this;
    }

    public IoBuffer put(byte[] src, int offset, int length) {
        int blocksize;
        if (this.readonly) {
            throw new ReadOnlyBufferException();
        }
        if (this.remaining() < length) {
            throw new BufferUnderflowException();
        }
        int currentOffset = offset;
        this.position.getNode().getBuffer().position(this.position.getPositionInNode());
        for (int remainsToCopy = length; remainsToCopy > 0; remainsToCopy -= blocksize) {
            this.position.updatePos();
            ByteBuffer currentBuffer = this.position.getNode().getBuffer();
            blocksize = Math.min(remainsToCopy, currentBuffer.remaining());
            this.position.getNode().getBuffer().put(src, currentOffset, blocksize);
            currentOffset += blocksize;
            this.position.incrementPosition(blocksize);
        }
        this.position.getNode().getBuffer().position(0);
        return this;
    }

    public IoBuffer put(int index, byte value) {
        if (index >= this.limit.getPosition()) {
            throw new IndexOutOfBoundsException();
        }
        Pointer p = this.getPointerByPosition(index);
        this.put(p, value);
        return this;
    }

    private IoBuffer put(Pointer pos, byte b) {
        pos.updatePos();
        pos.getNode().getBuffer().put(pos.getPositionInNode(), b);
        pos.incrPosition();
        return this;
    }

    public IoBuffer putChar(char value) {
        return this.putChar(this.position, value);
    }

    public IoBuffer putChar(int index, char value) {
        return this.putChar(this.getPointerByPosition(index), value);
    }

    private IoBuffer putChar(Pointer index, char value) {
        return this.putShort(index, (short)value);
    }

    public IoBuffer putDouble(double value) {
        return this.putDouble(this.position, value);
    }

    public IoBuffer putDouble(int index, double value) {
        return this.putDouble(this.getPointerByPosition(index), value);
    }

    private IoBuffer putDouble(Pointer pos, double value) {
        return this.putLong(pos, Double.doubleToLongBits(value));
    }

    public IoBuffer putFloat(float value) {
        return this.putFloat(this.position, value);
    }

    public IoBuffer putFloat(int index, float value) {
        return this.putFloat(this.getPointerByPosition(index), value);
    }

    private IoBuffer putFloat(Pointer pointer, float value) {
        return this.putInt(pointer, Float.floatToIntBits(value));
    }

    public IoBuffer putInt(int value) {
        return this.putInt(this.position, value);
    }

    public IoBuffer putInt(int index, int value) {
        return this.putInt(this.getPointerByPosition(index), value);
    }

    private IoBuffer putInt(Pointer pointer, int value) {
        if (this.position.getPosition() > pointer.getPosition() || pointer.getPosition() > this.limit.getPosition() - 4) {
            throw new BufferUnderflowException();
        }
        for (int i = 0; i < 32; i += 8) {
            this.put(pointer, (byte)(value >> (this.bo == ByteOrder.BIG_ENDIAN ? 24 - i : i)));
        }
        return this;
    }

    public IoBuffer putLong(int index, long value) {
        return this.putLong(this.getPointerByPosition(index), value);
    }

    public IoBuffer putLong(long value) {
        return this.putLong(this.position, value);
    }

    private IoBuffer putLong(Pointer pointer, long value) {
        if (this.position.getPosition() > pointer.getPosition() || pointer.getPosition() > this.limit.getPosition() - 8) {
            throw new BufferUnderflowException();
        }
        for (int i = 0; i < 64; i += 8) {
            this.put(pointer, (byte)(value >> (this.bo == ByteOrder.BIG_ENDIAN ? 56 - i : i)));
        }
        return this;
    }

    public IoBuffer putShort(int index, short value) {
        return this.putShort(this.getPointerByPosition(index), value);
    }

    private IoBuffer putShort(Pointer pointer, short value) {
        if (this.position.getPosition() > pointer.getPosition() || pointer.getPosition() > this.limit.getPosition() - 2) {
            throw new BufferUnderflowException();
        }
        for (int i = 0; i < 16; i += 8) {
            this.put(pointer, (byte)(value >> (this.bo == ByteOrder.BIG_ENDIAN ? 8 - i : i)));
        }
        return this;
    }

    public IoBuffer putShort(short value) {
        return this.putShort(this.position, value);
    }

    public int remaining() {
        return this.limit() - this.position();
    }

    public IoBuffer reset() {
        if (this.mark == null) {
            throw new InvalidMarkException();
        }
        this.position = this.mark.duplicate();
        return this;
    }

    public IoBuffer rewind() {
        this.position(0);
        this.mark = this.getPointerByPosition(-1);
        return this;
    }

    public IoBuffer slice() {
        this.position.updatePos();
        IoBuffer out = new IoBuffer();
        out.order(this.order());
        this.position.getNode().getBuffer().position(this.position.getPositionInNode());
        if (this.hasRemaining()) {
            this.tail.getBuffer().limit(this.limit.getPositionInNode());
            for (BufferNode node = this.position.getNode(); node != this.limit.getNode(); node = node.getNext()) {
                if (node != this.head) {
                    node.getBuffer().position(0);
                }
                out.add(node.getBuffer());
            }
            if (this.tail != this.head) {
                this.tail.getBuffer().position(0);
            }
            out.add(this.tail.getBuffer().slice());
            this.tail.getBuffer().limit(this.tail.getBuffer().capacity());
        }
        this.position.getNode().getBuffer().position(0);
        return out;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[pos=");
        sb.append(this.position());
        sb.append(" lim=");
        sb.append(this.limit());
        sb.append(" cap=");
        sb.append(this.capacity());
        sb.append("]");
        return sb.toString();
    }

    private final class Pointer {
        private BufferNode node;
        private int positionInBuffer;

        public Pointer(int position) {
            this();
            this.setPosition(position);
        }

        public Pointer() {
        }

        public Pointer duplicate() {
            return new Pointer(this.getPosition());
        }

        public BufferNode getNode() {
            return this.node;
        }

        public int getPosition() {
            return this.positionInBuffer + (this.node == null ? 0 : this.node.offset);
        }

        public int getPositionInNode() {
            this.updatePos();
            return this.positionInBuffer;
        }

        public void incrPosition() {
            this.incrementPosition(1);
        }

        public void setPosition(int newPosition) {
            if (this.node == null || newPosition < this.node.offset) {
                this.node = IoBuffer.this.head;
            }
            this.positionInBuffer = this.node == null ? 0 : newPosition - this.node.offset;
        }

        public void incrementPosition(int positionIncrement) {
            this.positionInBuffer += positionIncrement;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getName());
            sb.append("[pos=");
            sb.append(this.getPosition());
            sb.append(", node=");
            sb.append(this.getNode());
            sb.append("]");
            return sb.toString();
        }

        public void updatePos() {
            while (this.node != null && this.positionInBuffer >= this.node.getBuffer().capacity() && this.node.hasNext()) {
                this.positionInBuffer -= this.node.getBuffer().capacity();
                this.node = this.node.getNext();
            }
        }
    }

    private static final class BufferNode {
        private final ByteBuffer buffer;
        private BufferNode next;
        private final int offset;

        public BufferNode(ByteBuffer buffer, int offset) {
            this.buffer = buffer;
            this.offset = offset;
        }

        public ByteBuffer getBuffer() {
            return this.buffer;
        }

        public BufferNode getNext() {
            return this.next;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public void setNext(BufferNode next) {
            this.next = next;
        }

        public String toString() {
            return "BufferNode [offset=" + this.offset + ", buffer=" + this.buffer + "]";
        }
    }
}

