/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.codec.textline;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.apache.mina.codec.ProtocolDecoder;
import org.apache.mina.codec.ProtocolDecoderException;
import org.apache.mina.codec.textline.LineDelimiter;

public class TextLineDecoder
implements ProtocolDecoder<ByteBuffer, String, Context> {
    private final Charset charset;
    private final LineDelimiter delimiter;
    private ByteBuffer delimBuf;
    private int maxLineLength = 1024;
    private int bufferLength = 128;

    public TextLineDecoder() {
        this(LineDelimiter.AUTO);
    }

    public TextLineDecoder(String delimiter) {
        this(new LineDelimiter(delimiter));
    }

    public TextLineDecoder(LineDelimiter delimiter) {
        this(Charset.defaultCharset(), delimiter);
    }

    public TextLineDecoder(Charset charset) {
        this(charset, LineDelimiter.AUTO);
    }

    public TextLineDecoder(Charset charset, String delimiter) {
        this(charset, new LineDelimiter(delimiter));
    }

    public TextLineDecoder(Charset charset, LineDelimiter delimiter) {
        if (charset == null) {
            throw new IllegalArgumentException("charset parameter shuld not be null");
        }
        if (delimiter == null) {
            throw new IllegalArgumentException("delimiter parameter should not be null");
        }
        this.charset = charset;
        this.delimiter = delimiter;
        if (this.delimBuf == null) {
            ByteBuffer tmp = charset.encode(CharBuffer.wrap(delimiter.getValue()));
            tmp.rewind();
            this.delimBuf = tmp;
        }
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public void setMaxLineLength(int maxLineLength) {
        if (maxLineLength <= 0) {
            throw new IllegalArgumentException("maxLineLength (" + maxLineLength + ") should be a positive value");
        }
        this.maxLineLength = maxLineLength;
    }

    public void setBufferLength(int bufferLength) {
        if (bufferLength <= 0) {
            throw new IllegalArgumentException("bufferLength (" + this.maxLineLength + ") should be a positive value");
        }
        this.bufferLength = bufferLength;
    }

    public int getBufferLength() {
        return this.bufferLength;
    }

    @Override
    public Context createDecoderState() {
        return new Context(this.bufferLength);
    }

    @Override
    public String decode(ByteBuffer in, Context ctx) {
        if (LineDelimiter.AUTO.equals(this.delimiter)) {
            return this.decodeAuto(ctx, in);
        }
        return this.decodeNormal(ctx, in);
    }

    @Override
    public void finishDecode(Context ctx) {
    }

    private String decodeAuto(Context ctx, ByteBuffer in) {
        String decoded = null;
        int matchCount = ctx.getMatchCount();
        int oldPos = in.position();
        int oldLimit = in.limit();
        while (in.hasRemaining() && decoded == null) {
            int pos;
            block11: {
                byte b = in.get();
                boolean matched = false;
                switch (b) {
                    case 13: {
                        ++matchCount;
                        break;
                    }
                    case 10: {
                        ++matchCount;
                        matched = true;
                        break;
                    }
                    default: {
                        matchCount = 0;
                    }
                }
                if (!matched) continue;
                pos = in.position();
                in.limit(pos);
                in.position(oldPos);
                ctx.append(in);
                in.limit(oldLimit);
                in.position(pos);
                try {
                    if (ctx.getOverflowLength() == 0) {
                        ByteBuffer buf = ctx.getBuffer();
                        buf.flip();
                        buf.limit(buf.limit() - matchCount);
                        CharsetDecoder decoder = ctx.getDecoder();
                        CharBuffer buffer = decoder.decode(buf);
                        decoded = new String(buffer.array());
                        break block11;
                    }
                    int overflowPosition = ctx.getOverflowLength();
                    throw new IllegalStateException("Line is too long: " + overflowPosition);
                }
                catch (CharacterCodingException cce) {
                    throw new ProtocolDecoderException(cce);
                }
                finally {
                    ctx.reset();
                }
            }
            oldPos = pos;
            matchCount = 0;
        }
        in.position(oldPos);
        ctx.append(in);
        ctx.setMatchCount(matchCount);
        return decoded;
    }

    private String decodeNormal(Context ctx, ByteBuffer in) {
        String decoded = null;
        int matchCount = ctx.getMatchCount();
        int oldPos = in.position();
        int oldLimit = in.limit();
        while (in.hasRemaining() && decoded == null) {
            byte b = in.get();
            if (this.delimBuf.get(matchCount) == b) {
                int pos;
                block8: {
                    if (++matchCount != this.delimBuf.limit()) continue;
                    pos = in.position();
                    in.limit(pos);
                    in.position(oldPos);
                    ctx.append(in);
                    in.limit(oldLimit);
                    in.position(pos);
                    try {
                        if (ctx.getOverflowLength() == 0) {
                            ByteBuffer buf = ctx.getBuffer();
                            buf.flip();
                            buf.limit(buf.limit() - matchCount);
                            CharsetDecoder decoder = ctx.getDecoder();
                            CharBuffer buffer = decoder.decode(buf);
                            decoded = new String(buffer.array());
                            break block8;
                        }
                        int overflowLength = ctx.getOverflowLength();
                        throw new IllegalStateException("Line is too long: " + overflowLength);
                    }
                    catch (CharacterCodingException cce) {
                        throw new ProtocolDecoderException(cce);
                    }
                    finally {
                        ctx.reset();
                    }
                }
                oldPos = pos;
                matchCount = 0;
                continue;
            }
            in.position(Math.max(0, in.position() - matchCount));
            matchCount = 0;
        }
        in.position(oldPos);
        ctx.append(in);
        ctx.setMatchCount(matchCount);
        return decoded;
    }

    public class Context {
        private final CharsetDecoder decoder;
        private ByteBuffer buf;
        private int matchCount = 0;
        private int overflowLength = 0;

        private Context(int bufferLength) {
            this.decoder = TextLineDecoder.this.charset.newDecoder();
            this.buf = ByteBuffer.allocate(bufferLength);
        }

        public CharsetDecoder getDecoder() {
            return this.decoder;
        }

        public ByteBuffer getBuffer() {
            return this.buf;
        }

        public int getMatchCount() {
            return this.matchCount;
        }

        public void setMatchCount(int matchCount) {
            this.matchCount = matchCount;
        }

        public int getOverflowLength() {
            return this.overflowLength;
        }

        public void reset() {
            this.overflowLength = 0;
            this.matchCount = 0;
            this.decoder.reset();
            this.buf.clear();
        }

        private void ensureSpace(int size) {
            if (this.buf.position() + size > this.buf.capacity()) {
                ByteBuffer b = ByteBuffer.allocate(this.buf.position() + size + TextLineDecoder.this.bufferLength);
                this.buf.flip();
                b.put(this.buf);
                this.buf = b;
            }
        }

        public void append(ByteBuffer in) {
            if (this.buf.position() > TextLineDecoder.this.maxLineLength - in.remaining()) {
                this.overflowLength = this.buf.position() + in.remaining();
                this.buf.clear();
                this.discard(in);
            } else {
                this.ensureSpace(in.remaining());
                this.getBuffer().put(in);
            }
        }

        private void discard(ByteBuffer in) {
            in.position(in.limit());
        }
    }
}

