/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.nifi.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NiFiProperties
extends Properties {
    private static final long serialVersionUID = 2119177359005492702L;
    private static final Logger LOG = LoggerFactory.getLogger(NiFiProperties.class);
    private static NiFiProperties instance = null;
    public static final String PROPERTIES_FILE_PATH = "nifi.properties.file.path";
    public static final String FLOW_CONFIGURATION_FILE = "nifi.flow.configuration.file";
    public static final String FLOW_CONFIGURATION_ARCHIVE_FILE = "nifi.flow.configuration.archive.file";
    public static final String AUTHORITY_PROVIDER_CONFIGURATION_FILE = "nifi.authority.provider.configuration.file";
    public static final String LOGIN_IDENTITY_PROVIDER_CONFIGURATION_FILE = "nifi.login.identity.provider.configuration.file";
    public static final String REPOSITORY_DATABASE_DIRECTORY = "nifi.database.directory";
    public static final String RESTORE_DIRECTORY = "nifi.restore.directory";
    public static final String VERSION = "nifi.version";
    public static final String WRITE_DELAY_INTERVAL = "nifi.flowservice.writedelay.interval";
    public static final String AUTO_RESUME_STATE = "nifi.flowcontroller.autoResumeState";
    public static final String FLOW_CONTROLLER_GRACEFUL_SHUTDOWN_PERIOD = "nifi.flowcontroller.graceful.shutdown.period";
    public static final String NAR_LIBRARY_DIRECTORY = "nifi.nar.library.directory";
    public static final String NAR_LIBRARY_DIRECTORY_PREFIX = "nifi.nar.library.directory.";
    public static final String NAR_WORKING_DIRECTORY = "nifi.nar.working.directory";
    public static final String COMPONENT_DOCS_DIRECTORY = "nifi.documentation.working.directory";
    public static final String SENSITIVE_PROPS_KEY = "nifi.sensitive.props.key";
    public static final String SENSITIVE_PROPS_ALGORITHM = "nifi.sensitive.props.algorithm";
    public static final String SENSITIVE_PROPS_PROVIDER = "nifi.sensitive.props.provider";
    public static final String H2_URL_APPEND = "nifi.h2.url.append";
    public static final String REMOTE_INPUT_HOST = "nifi.remote.input.socket.host";
    public static final String REMOTE_INPUT_PORT = "nifi.remote.input.socket.port";
    public static final String SITE_TO_SITE_SECURE = "nifi.remote.input.secure";
    public static final String TEMPLATE_DIRECTORY = "nifi.templates.directory";
    public static final String ADMINISTRATIVE_YIELD_DURATION = "nifi.administrative.yield.duration";
    public static final String PERSISTENT_STATE_DIRECTORY = "nifi.persistent.state.directory";
    public static final String BORED_YIELD_DURATION = "nifi.bored.yield.duration";
    public static final String PROCESSOR_SCHEDULING_TIMEOUT = "nifi.processor.scheduling.timeout";
    public static final String REPOSITORY_CONTENT_PREFIX = "nifi.content.repository.directory.";
    public static final String CONTENT_REPOSITORY_IMPLEMENTATION = "nifi.content.repository.implementation";
    public static final String MAX_APPENDABLE_CLAIM_SIZE = "nifi.content.claim.max.appendable.size";
    public static final String MAX_FLOWFILES_PER_CLAIM = "nifi.content.claim.max.flow.files";
    public static final String CONTENT_ARCHIVE_MAX_RETENTION_PERIOD = "nifi.content.repository.archive.max.retention.period";
    public static final String CONTENT_ARCHIVE_MAX_USAGE_PERCENTAGE = "nifi.content.repository.archive.max.usage.percentage";
    public static final String CONTENT_ARCHIVE_BACK_PRESSURE_PERCENTAGE = "nifi.content.repository.archive.backpressure.percentage";
    public static final String CONTENT_ARCHIVE_ENABLED = "nifi.content.repository.archive.enabled";
    public static final String CONTENT_ARCHIVE_CLEANUP_FREQUENCY = "nifi.content.repository.archive.cleanup.frequency";
    public static final String CONTENT_VIEWER_URL = "nifi.content.viewer.url";
    public static final String FLOWFILE_REPOSITORY_IMPLEMENTATION = "nifi.flowfile.repository.implementation";
    public static final String FLOWFILE_REPOSITORY_ALWAYS_SYNC = "nifi.flowfile.repository.always.sync";
    public static final String FLOWFILE_REPOSITORY_DIRECTORY = "nifi.flowfile.repository.directory";
    public static final String FLOWFILE_REPOSITORY_PARTITIONS = "nifi.flowfile.repository.partitions";
    public static final String FLOWFILE_REPOSITORY_CHECKPOINT_INTERVAL = "nifi.flowfile.repository.checkpoint.interval";
    public static final String FLOWFILE_SWAP_MANAGER_IMPLEMENTATION = "nifi.swap.manager.implementation";
    public static final String QUEUE_SWAP_THRESHOLD = "nifi.queue.swap.threshold";
    public static final String SWAP_IN_THREADS = "nifi.swap.in.threads";
    public static final String SWAP_IN_PERIOD = "nifi.swap.in.period";
    public static final String SWAP_OUT_THREADS = "nifi.swap.out.threads";
    public static final String SWAP_OUT_PERIOD = "nifi.swap.out.period";
    public static final String PROVENANCE_REPO_IMPLEMENTATION_CLASS = "nifi.provenance.repository.implementation";
    public static final String PROVENANCE_REPO_DIRECTORY_PREFIX = "nifi.provenance.repository.directory.";
    public static final String PROVENANCE_MAX_STORAGE_TIME = "nifi.provenance.repository.max.storage.time";
    public static final String PROVENANCE_MAX_STORAGE_SIZE = "nifi.provenance.repository.max.storage.size";
    public static final String PROVENANCE_ROLLOVER_TIME = "nifi.provenance.repository.rollover.time";
    public static final String PROVENANCE_ROLLOVER_SIZE = "nifi.provenance.repository.rollover.size";
    public static final String PROVENANCE_QUERY_THREAD_POOL_SIZE = "nifi.provenance.repository.query.threads";
    public static final String PROVENANCE_INDEX_THREAD_POOL_SIZE = "nifi.provenance.repository.index.threads";
    public static final String PROVENANCE_COMPRESS_ON_ROLLOVER = "nifi.provenance.repository.compress.on.rollover";
    public static final String PROVENANCE_INDEXED_FIELDS = "nifi.provenance.repository.indexed.fields";
    public static final String PROVENANCE_INDEXED_ATTRIBUTES = "nifi.provenance.repository.indexed.attributes";
    public static final String PROVENANCE_INDEX_SHARD_SIZE = "nifi.provenance.repository.index.shard.size";
    public static final String PROVENANCE_JOURNAL_COUNT = "nifi.provenance.repository.journal.count";
    public static final String COMPONENT_STATUS_REPOSITORY_IMPLEMENTATION = "nifi.components.status.repository.implementation";
    public static final String COMPONENT_STATUS_SNAPSHOT_FREQUENCY = "nifi.components.status.snapshot.frequency";
    public static final String NF_SENSITIVE_PROPS_KEY = "nifi.sensitive.props.key";
    public static final String NF_SENSITIVE_PROPS_ALGORITHM = "nifi.sensitive.props.algorithm";
    public static final String NF_SENSITIVE_PROPS_PROVIDER = "nifi.sensitive.props.provider";
    public static final String SECURITY_KEYSTORE = "nifi.security.keystore";
    public static final String SECURITY_KEYSTORE_TYPE = "nifi.security.keystoreType";
    public static final String SECURITY_KEYSTORE_PASSWD = "nifi.security.keystorePasswd";
    public static final String SECURITY_KEY_PASSWD = "nifi.security.keyPasswd";
    public static final String SECURITY_TRUSTSTORE = "nifi.security.truststore";
    public static final String SECURITY_TRUSTSTORE_TYPE = "nifi.security.truststoreType";
    public static final String SECURITY_TRUSTSTORE_PASSWD = "nifi.security.truststorePasswd";
    public static final String SECURITY_NEED_CLIENT_AUTH = "nifi.security.needClientAuth";
    public static final String SECURITY_USER_AUTHORITY_PROVIDER = "nifi.security.user.authority.provider";
    public static final String SECURITY_USER_LOGIN_IDENTITY_PROVIDER = "nifi.security.user.login.identity.provider";
    public static final String SECURITY_CLUSTER_AUTHORITY_PROVIDER_PORT = "nifi.security.cluster.authority.provider.port";
    public static final String SECURITY_CLUSTER_AUTHORITY_PROVIDER_THREADS = "nifi.security.cluster.authority.provider.threads";
    public static final String SECURITY_USER_CREDENTIAL_CACHE_DURATION = "nifi.security.user.credential.cache.duration";
    public static final String SECURITY_SUPPORT_NEW_ACCOUNT_REQUESTS = "nifi.security.support.new.account.requests";
    public static final String SECURITY_ANONYMOUS_AUTHORITIES = "nifi.security.anonymous.authorities";
    public static final String SECURITY_OCSP_RESPONDER_URL = "nifi.security.ocsp.responder.url";
    public static final String SECURITY_OCSP_RESPONDER_CERTIFICATE = "nifi.security.ocsp.responder.certificate";
    public static final String WEB_WAR_DIR = "nifi.web.war.directory";
    public static final String WEB_HTTP_PORT = "nifi.web.http.port";
    public static final String WEB_HTTP_HOST = "nifi.web.http.host";
    public static final String WEB_HTTPS_PORT = "nifi.web.https.port";
    public static final String WEB_HTTPS_HOST = "nifi.web.https.host";
    public static final String WEB_WORKING_DIR = "nifi.web.jetty.working.directory";
    public static final String WEB_THREADS = "nifi.web.jetty.threads";
    public static final String UI_BANNER_TEXT = "nifi.ui.banner.text";
    public static final String UI_AUTO_REFRESH_INTERVAL = "nifi.ui.autorefresh.interval";
    public static final String CLUSTER_PROTOCOL_HEARTBEAT_INTERVAL = "nifi.cluster.protocol.heartbeat.interval";
    public static final String CLUSTER_PROTOCOL_IS_SECURE = "nifi.cluster.protocol.is.secure";
    public static final String CLUSTER_PROTOCOL_SOCKET_TIMEOUT = "nifi.cluster.protocol.socket.timeout";
    public static final String CLUSTER_PROTOCOL_CONNECTION_HANDSHAKE_TIMEOUT = "nifi.cluster.protocol.connection.handshake.timeout";
    public static final String CLUSTER_PROTOCOL_USE_MULTICAST = "nifi.cluster.protocol.use.multicast";
    public static final String CLUSTER_PROTOCOL_MULTICAST_ADDRESS = "nifi.cluster.protocol.multicast.address";
    public static final String CLUSTER_PROTOCOL_MULTICAST_PORT = "nifi.cluster.protocol.multicast.port";
    public static final String CLUSTER_PROTOCOL_MULTICAST_SERVICE_BROADCAST_DELAY = "nifi.cluster.protocol.multicast.service.broadcast.delay";
    public static final String CLUSTER_PROTOCOL_MULTICAST_SERVICE_LOCATOR_ATTEMPTS = "nifi.cluster.protocol.multicast.service.locator.attempts";
    public static final String CLUSTER_PROTOCOL_MULTICAST_SERVICE_LOCATOR_ATTEMPTS_DELAY = "nifi.cluster.protocol.multicast.service.locator.attempts.delay";
    public static final String CLUSTER_IS_NODE = "nifi.cluster.is.node";
    public static final String CLUSTER_NODE_ADDRESS = "nifi.cluster.node.address";
    public static final String CLUSTER_NODE_PROTOCOL_PORT = "nifi.cluster.node.protocol.port";
    public static final String CLUSTER_NODE_PROTOCOL_THREADS = "nifi.cluster.node.protocol.threads";
    public static final String CLUSTER_NODE_UNICAST_MANAGER_ADDRESS = "nifi.cluster.node.unicast.manager.address";
    public static final String CLUSTER_NODE_UNICAST_MANAGER_PROTOCOL_PORT = "nifi.cluster.node.unicast.manager.protocol.port";
    public static final String CLUSTER_IS_MANAGER = "nifi.cluster.is.manager";
    public static final String CLUSTER_MANAGER_ADDRESS = "nifi.cluster.manager.address";
    public static final String CLUSTER_MANAGER_PROTOCOL_PORT = "nifi.cluster.manager.protocol.port";
    public static final String CLUSTER_MANAGER_NODE_FIREWALL_FILE = "nifi.cluster.manager.node.firewall.file";
    public static final String CLUSTER_MANAGER_NODE_EVENT_HISTORY_SIZE = "nifi.cluster.manager.node.event.history.size";
    public static final String CLUSTER_MANAGER_NODE_API_CONNECTION_TIMEOUT = "nifi.cluster.manager.node.api.connection.timeout";
    public static final String CLUSTER_MANAGER_NODE_API_READ_TIMEOUT = "nifi.cluster.manager.node.api.read.timeout";
    public static final String CLUSTER_MANAGER_NODE_API_REQUEST_THREADS = "nifi.cluster.manager.node.api.request.threads";
    public static final String CLUSTER_MANAGER_FLOW_RETRIEVAL_DELAY = "nifi.cluster.manager.flow.retrieval.delay";
    public static final String CLUSTER_MANAGER_PROTOCOL_THREADS = "nifi.cluster.manager.protocol.threads";
    public static final String CLUSTER_MANAGER_SAFEMODE_DURATION = "nifi.cluster.manager.safemode.duration";
    public static final String KERBEROS_KRB5_FILE = "nifi.kerberos.krb5.file";
    public static final String KERBEROS_SERVICE_PRINCIPAL = "nifi.kerberos.service.principal";
    public static final String KERBEROS_KEYTAB_LOCATION = "nifi.kerberos.keytab.location";
    public static final String KERBEROS_AUTHENTICATION_EXPIRATION = "nifi.kerberos.authentication.expiration";
    public static final String STATE_MANAGEMENT_CONFIG_FILE = "nifi.state.management.configuration.file";
    public static final String STATE_MANAGEMENT_LOCAL_PROVIDER_ID = "nifi.state.management.provider.local";
    public static final String STATE_MANAGEMENT_CLUSTER_PROVIDER_ID = "nifi.state.management.provider.cluster";
    public static final String STATE_MANAGEMENT_START_EMBEDDED_ZOOKEEPER = "nifi.state.management.embedded.zookeeper.start";
    public static final String STATE_MANAGEMENT_ZOOKEEPER_PROPERTIES = "nifi.state.management.embedded.zookeeper.properties";
    public static final String VARIABLE_REGISTRY_PROPERTIES = "nifi.variable.registry.properties";
    public static final String DEFAULT_TITLE = "NiFi";
    public static final Boolean DEFAULT_AUTO_RESUME_STATE = true;
    public static final String DEFAULT_AUTHORITY_PROVIDER_CONFIGURATION_FILE = "conf/authority-providers.xml";
    public static final String DEFAULT_LOGIN_IDENTITY_PROVIDER_CONFIGURATION_FILE = "conf/login-identity-providers.xml";
    public static final String DEFAULT_USER_CREDENTIAL_CACHE_DURATION = "24 hours";
    public static final Integer DEFAULT_REMOTE_INPUT_PORT = null;
    public static final Path DEFAULT_TEMPLATE_DIRECTORY = Paths.get("conf", "templates");
    public static final int DEFAULT_WEB_THREADS = 200;
    public static final String DEFAULT_WEB_WORKING_DIR = "./work/jetty";
    public static final String DEFAULT_NAR_WORKING_DIR = "./work/nar";
    public static final String DEFAULT_COMPONENT_DOCS_DIRECTORY = "./work/docs/components";
    public static final String DEFAULT_NAR_LIBRARY_DIR = "./lib";
    public static final String DEFAULT_FLOWFILE_REPO_PARTITIONS = "256";
    public static final String DEFAULT_FLOWFILE_CHECKPOINT_INTERVAL = "2 min";
    public static final int DEFAULT_MAX_FLOWFILES_PER_CLAIM = 100;
    public static final int DEFAULT_QUEUE_SWAP_THRESHOLD = 20000;
    public static final String DEFAULT_SWAP_STORAGE_LOCATION = "./flowfile_repository/swap";
    public static final String DEFAULT_SWAP_IN_PERIOD = "1 sec";
    public static final String DEFAULT_SWAP_OUT_PERIOD = "5 sec";
    public static final int DEFAULT_SWAP_IN_THREADS = 4;
    public static final int DEFAULT_SWAP_OUT_THREADS = 4;
    public static final String DEFAULT_ADMINISTRATIVE_YIELD_DURATION = "30 sec";
    public static final String DEFAULT_PERSISTENT_STATE_DIRECTORY = "./conf/state";
    public static final String DEFAULT_COMPONENT_STATUS_SNAPSHOT_FREQUENCY = "5 mins";
    public static final String DEFAULT_BORED_YIELD_DURATION = "10 millis";
    public static final String DEFAULT_CLUSTER_PROTOCOL_HEARTBEAT_INTERVAL = "5 sec";
    public static final String DEFAULT_CLUSTER_PROTOCOL_MULTICAST_SERVICE_BROADCAST_DELAY = "500 ms";
    public static final int DEFAULT_CLUSTER_PROTOCOL_MULTICAST_SERVICE_LOCATOR_ATTEMPTS = 3;
    public static final String DEFAULT_CLUSTER_PROTOCOL_MULTICAST_SERVICE_LOCATOR_ATTEMPTS_DELAY = "1 sec";
    public static final String DEFAULT_CLUSTER_PROTOCOL_SOCKET_TIMEOUT = "30 sec";
    public static final String DEFAULT_CLUSTER_PROTOCOL_CONNECTION_HANDSHAKE_TIMEOUT = "45 sec";
    public static final int DEFAULT_CLUSTER_NODE_PROTOCOL_THREADS = 2;
    public static final int DEFAULT_CLUSTER_MANAGER_NODE_EVENT_HISTORY_SIZE = 10;
    public static final String DEFAULT_CLUSTER_MANAGER_NODE_API_CONNECTION_TIMEOUT = "30 sec";
    public static final String DEFAULT_CLUSTER_MANAGER_NODE_API_READ_TIMEOUT = "30 sec";
    public static final int DEFAULT_CLUSTER_MANAGER_NODE_API_NUM_REQUEST_THREADS = 10;
    public static final String DEFAULT_CLUSTER_MANAGER_FLOW_RETRIEVAL_DELAY = "5 sec";
    public static final int DEFAULT_CLUSTER_MANAGER_PROTOCOL_THREADS = 10;
    public static final String DEFAULT_CLUSTER_MANAGER_SAFEMODE_DURATION = "0 sec";
    public static final String DEFAULT_STATE_MANAGEMENT_CONFIG_FILE = "conf/state-management.xml";
    public static final String DEFAULT_KERBEROS_AUTHENTICATION_EXPIRATION = "12 hours";

    private NiFiProperties() {
    }

    public static synchronized NiFiProperties getInstance() {
        if (null == instance) {
            NiFiProperties suspectInstance = new NiFiProperties();
            String nfPropertiesFilePath = System.getProperty(PROPERTIES_FILE_PATH);
            if (null == nfPropertiesFilePath || nfPropertiesFilePath.trim().length() == 0) {
                throw new RuntimeException("Requires a system property called 'nifi.properties.file.path' and this is not set or has no value");
            }
            File propertiesFile = new File(nfPropertiesFilePath);
            if (!propertiesFile.exists()) {
                throw new RuntimeException("Properties file doesn't exist '" + propertiesFile.getAbsolutePath() + "'");
            }
            if (!propertiesFile.canRead()) {
                throw new RuntimeException("Properties file exists but cannot be read '" + propertiesFile.getAbsolutePath() + "'");
            }
            BufferedInputStream inStream = null;
            try {
                inStream = new BufferedInputStream(new FileInputStream(propertiesFile));
                suspectInstance.load(inStream);
            }
            catch (Exception ex) {
                LOG.error("Cannot load properties file due to " + ex.getLocalizedMessage());
                throw new RuntimeException("Cannot load properties file due to " + ex.getLocalizedMessage(), ex);
            }
            finally {
                if (null != inStream) {
                    try {
                        ((InputStream)inStream).close();
                    }
                    catch (Exception exception) {}
                }
            }
            instance = suspectInstance;
        }
        return instance;
    }

    public File getFlowConfigurationFile() {
        try {
            return new File(this.getProperty(FLOW_CONFIGURATION_FILE));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public File getFlowConfigurationFileDir() {
        try {
            return this.getFlowConfigurationFile().getParentFile();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private Integer getPropertyAsPort(String propertyName, Integer defaultValue) {
        String port = this.getProperty(propertyName);
        if (StringUtils.isEmpty(port)) {
            return defaultValue;
        }
        try {
            int val = Integer.parseInt(port);
            if (val <= 0 || val > 65535) {
                throw new RuntimeException("Valid port range is 0 - 65535 but got " + val);
            }
            return val;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public int getQueueSwapThreshold() {
        String thresholdValue = this.getProperty(QUEUE_SWAP_THRESHOLD);
        if (thresholdValue == null) {
            return 20000;
        }
        try {
            return Integer.parseInt(thresholdValue);
        }
        catch (NumberFormatException e) {
            return 20000;
        }
    }

    public Integer getIntegerProperty(String propertyName, Integer defaultValue) {
        String value = this.getProperty(propertyName);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(this.getProperty(propertyName));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int getSwapInThreads() {
        return this.getIntegerProperty(SWAP_IN_THREADS, 4);
    }

    public int getSwapOutThreads() {
        String value = this.getProperty(SWAP_OUT_THREADS);
        if (value == null) {
            return 4;
        }
        try {
            return Integer.parseInt(this.getProperty(SWAP_OUT_THREADS));
        }
        catch (Exception e) {
            return 4;
        }
    }

    public String getSwapInPeriod() {
        return this.getProperty(SWAP_IN_PERIOD, "1 sec");
    }

    public String getSwapOutPeriod() {
        return this.getProperty(SWAP_OUT_PERIOD, "5 sec");
    }

    public String getAdministrativeYieldDuration() {
        return this.getProperty(ADMINISTRATIVE_YIELD_DURATION, "30 sec");
    }

    public String getRemoteInputHost() {
        String value = this.getProperty(REMOTE_INPUT_HOST);
        return StringUtils.isBlank(value) ? null : value;
    }

    public Integer getRemoteInputPort() {
        return this.getPropertyAsPort(REMOTE_INPUT_PORT, DEFAULT_REMOTE_INPUT_PORT);
    }

    public Boolean isSiteToSiteSecure() {
        String secureVal = this.getProperty(SITE_TO_SITE_SECURE, "true");
        if ("false".equalsIgnoreCase(secureVal)) {
            return false;
        }
        return true;
    }

    public Path getTemplateDirectory() {
        String strVal = this.getProperty(TEMPLATE_DIRECTORY);
        return strVal == null ? DEFAULT_TEMPLATE_DIRECTORY : Paths.get(strVal, new String[0]);
    }

    public String getFlowServiceWriteDelay() {
        return this.getProperty(WRITE_DELAY_INTERVAL);
    }

    public boolean getAutoResumeState() {
        String rawAutoResumeState = this.getProperty(AUTO_RESUME_STATE, DEFAULT_AUTO_RESUME_STATE.toString());
        return Boolean.parseBoolean(rawAutoResumeState);
    }

    public int getFlowFileRepositoryPartitions() {
        String rawProperty = this.getProperty(FLOWFILE_REPOSITORY_PARTITIONS, DEFAULT_FLOWFILE_REPO_PARTITIONS);
        return Integer.parseInt(rawProperty);
    }

    public String getFlowFileRepositoryCheckpointInterval() {
        return this.getProperty(FLOWFILE_REPOSITORY_CHECKPOINT_INTERVAL, DEFAULT_FLOWFILE_CHECKPOINT_INTERVAL);
    }

    public File getRestoreDirectory() {
        String value = this.getProperty(RESTORE_DIRECTORY);
        if (StringUtils.isBlank(value)) {
            return null;
        }
        return new File(value);
    }

    public File getAuthorityProviderConfiguraitonFile() {
        String value = this.getProperty(AUTHORITY_PROVIDER_CONFIGURATION_FILE);
        if (StringUtils.isBlank(value)) {
            return new File(DEFAULT_AUTHORITY_PROVIDER_CONFIGURATION_FILE);
        }
        return new File(value);
    }

    public File getLoginIdentityProviderConfiguraitonFile() {
        String value = this.getProperty(LOGIN_IDENTITY_PROVIDER_CONFIGURATION_FILE);
        if (StringUtils.isBlank(value)) {
            return new File(DEFAULT_LOGIN_IDENTITY_PROVIDER_CONFIGURATION_FILE);
        }
        return new File(value);
    }

    public boolean getNeedClientAuth() {
        boolean needClientAuth = true;
        String rawNeedClientAuth = this.getProperty(SECURITY_NEED_CLIENT_AUTH);
        if ("false".equalsIgnoreCase(rawNeedClientAuth)) {
            needClientAuth = false;
        }
        return needClientAuth;
    }

    public String getUserCredentialCacheDuration() {
        return this.getProperty(SECURITY_USER_CREDENTIAL_CACHE_DURATION, DEFAULT_USER_CREDENTIAL_CACHE_DURATION);
    }

    public boolean getSupportNewAccountRequests() {
        boolean shouldSupport = true;
        String rawShouldSupport = this.getProperty(SECURITY_SUPPORT_NEW_ACCOUNT_REQUESTS);
        if ("false".equalsIgnoreCase(rawShouldSupport)) {
            shouldSupport = false;
        }
        return shouldSupport;
    }

    public Set<String> getAnonymousAuthorities() {
        HashSet<String> authorities;
        String rawAnonymousAuthorities = this.getProperty(SECURITY_ANONYMOUS_AUTHORITIES);
        if (!StringUtils.isEmpty(rawAnonymousAuthorities)) {
            authorities = new HashSet<String>();
            List<String> authoritiesList = Arrays.asList(rawAnonymousAuthorities.split(","));
            for (String authority : authoritiesList) {
                authorities.add(authority.trim());
            }
        } else {
            authorities = Collections.EMPTY_SET;
        }
        return authorities;
    }

    public Integer getPort() {
        Integer port = null;
        try {
            port = Integer.parseInt(this.getProperty(WEB_HTTP_PORT));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return port;
    }

    public Integer getSslPort() {
        Integer sslPort = null;
        try {
            sslPort = Integer.parseInt(this.getProperty(WEB_HTTPS_PORT));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return sslPort;
    }

    public int getWebThreads() {
        return this.getIntegerProperty(WEB_THREADS, 200);
    }

    public File getWebWorkingDirectory() {
        return new File(this.getProperty(WEB_WORKING_DIR, DEFAULT_WEB_WORKING_DIR));
    }

    public File getComponentDocumentationWorkingDirectory() {
        return new File(this.getProperty(COMPONENT_DOCS_DIRECTORY, DEFAULT_COMPONENT_DOCS_DIRECTORY));
    }

    public File getNarWorkingDirectory() {
        return new File(this.getProperty(NAR_WORKING_DIRECTORY, DEFAULT_NAR_WORKING_DIR));
    }

    public File getFrameworkWorkingDirectory() {
        return new File(this.getNarWorkingDirectory(), "framework");
    }

    public File getExtensionsWorkingDirectory() {
        return new File(this.getNarWorkingDirectory(), "extensions");
    }

    public List<Path> getNarLibraryDirectories() {
        ArrayList<Path> narLibraryPaths = new ArrayList<Path>();
        for (String propertyName : this.stringPropertyNames()) {
            String narLib;
            if (!StringUtils.startsWith(propertyName, NAR_LIBRARY_DIRECTORY_PREFIX) && !NAR_LIBRARY_DIRECTORY.equals(propertyName) || StringUtils.isBlank(narLib = this.getProperty(propertyName))) continue;
            narLibraryPaths.add(Paths.get(narLib, new String[0]));
        }
        if (narLibraryPaths.isEmpty()) {
            narLibraryPaths.add(Paths.get(DEFAULT_NAR_LIBRARY_DIR, new String[0]));
        }
        return narLibraryPaths;
    }

    public String getUiTitle() {
        return this.getProperty(VERSION, DEFAULT_TITLE);
    }

    public String getBannerText() {
        return this.getProperty(UI_BANNER_TEXT, "");
    }

    public String getAutoRefreshInterval() {
        return this.getProperty(UI_AUTO_REFRESH_INTERVAL);
    }

    public String getClusterProtocolHeartbeatInterval() {
        return this.getProperty(CLUSTER_PROTOCOL_HEARTBEAT_INTERVAL, "5 sec");
    }

    public String getNodeHeartbeatInterval() {
        return this.getClusterProtocolHeartbeatInterval();
    }

    public String getClusterProtocolSocketTimeout() {
        return this.getProperty(CLUSTER_PROTOCOL_SOCKET_TIMEOUT, "30 sec");
    }

    public String getClusterProtocolConnectionHandshakeTimeout() {
        return this.getProperty(CLUSTER_PROTOCOL_CONNECTION_HANDSHAKE_TIMEOUT, DEFAULT_CLUSTER_PROTOCOL_CONNECTION_HANDSHAKE_TIMEOUT);
    }

    public boolean getClusterProtocolUseMulticast() {
        return Boolean.parseBoolean(this.getProperty(CLUSTER_PROTOCOL_USE_MULTICAST));
    }

    public InetSocketAddress getClusterProtocolMulticastAddress() {
        try {
            String multicastAddress = this.getProperty(CLUSTER_PROTOCOL_MULTICAST_ADDRESS);
            int multicastPort = Integer.parseInt(this.getProperty(CLUSTER_PROTOCOL_MULTICAST_PORT));
            return new InetSocketAddress(multicastAddress, multicastPort);
        }
        catch (Exception ex) {
            throw new RuntimeException("Invalid multicast address/port due to: " + ex, ex);
        }
    }

    public String getClusterProtocolMulticastServiceBroadcastDelay() {
        return this.getProperty(CLUSTER_PROTOCOL_MULTICAST_SERVICE_BROADCAST_DELAY);
    }

    public File getPersistentStateDirectory() {
        String dirName = this.getProperty(PERSISTENT_STATE_DIRECTORY, DEFAULT_PERSISTENT_STATE_DIRECTORY);
        File file = new File(dirName);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public int getClusterProtocolMulticastServiceLocatorAttempts() {
        try {
            return Integer.parseInt(this.getProperty(CLUSTER_PROTOCOL_MULTICAST_SERVICE_LOCATOR_ATTEMPTS));
        }
        catch (NumberFormatException nfe) {
            return 3;
        }
    }

    public String getClusterProtocolMulticastServiceLocatorAttemptsDelay() {
        return this.getProperty(CLUSTER_PROTOCOL_MULTICAST_SERVICE_LOCATOR_ATTEMPTS_DELAY, "1 sec");
    }

    public boolean isNode() {
        return Boolean.parseBoolean(this.getProperty(CLUSTER_IS_NODE));
    }

    public InetSocketAddress getClusterNodeProtocolAddress() {
        try {
            String socketAddress = this.getProperty(CLUSTER_NODE_ADDRESS);
            if (StringUtils.isBlank(socketAddress)) {
                socketAddress = "localhost";
            }
            int socketPort = this.getClusterNodeProtocolPort();
            return InetSocketAddress.createUnresolved(socketAddress, socketPort);
        }
        catch (Exception ex) {
            throw new RuntimeException("Invalid node protocol address/port due to: " + ex, ex);
        }
    }

    public Integer getClusterNodeProtocolPort() {
        try {
            return Integer.parseInt(this.getProperty(CLUSTER_NODE_PROTOCOL_PORT));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public int getClusterNodeProtocolThreads() {
        try {
            return Integer.parseInt(this.getProperty(CLUSTER_NODE_PROTOCOL_THREADS));
        }
        catch (NumberFormatException nfe) {
            return 2;
        }
    }

    public InetSocketAddress getClusterNodeUnicastManagerProtocolAddress() {
        try {
            String socketAddress = this.getProperty(CLUSTER_NODE_UNICAST_MANAGER_ADDRESS);
            if (StringUtils.isBlank(socketAddress)) {
                socketAddress = "localhost";
            }
            int socketPort = Integer.parseInt(this.getProperty(CLUSTER_NODE_UNICAST_MANAGER_PROTOCOL_PORT));
            return InetSocketAddress.createUnresolved(socketAddress, socketPort);
        }
        catch (Exception ex) {
            throw new RuntimeException("Invalid unicast manager address/port due to: " + ex, ex);
        }
    }

    public boolean isClusterManager() {
        return Boolean.parseBoolean(this.getProperty(CLUSTER_IS_MANAGER));
    }

    public InetSocketAddress getClusterManagerProtocolAddress() {
        try {
            String socketAddress = this.getProperty(CLUSTER_MANAGER_ADDRESS);
            if (StringUtils.isBlank(socketAddress)) {
                socketAddress = "localhost";
            }
            int socketPort = this.getClusterManagerProtocolPort();
            return InetSocketAddress.createUnresolved(socketAddress, socketPort);
        }
        catch (Exception ex) {
            throw new RuntimeException("Invalid manager protocol address/port due to: " + ex, ex);
        }
    }

    public Integer getClusterManagerProtocolPort() {
        try {
            return Integer.parseInt(this.getProperty(CLUSTER_MANAGER_PROTOCOL_PORT));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public File getClusterManagerNodeFirewallFile() {
        String firewallFile = this.getProperty(CLUSTER_MANAGER_NODE_FIREWALL_FILE);
        if (StringUtils.isBlank(firewallFile)) {
            return null;
        }
        return new File(firewallFile);
    }

    public int getClusterManagerNodeEventHistorySize() {
        try {
            return Integer.parseInt(this.getProperty(CLUSTER_MANAGER_NODE_EVENT_HISTORY_SIZE));
        }
        catch (NumberFormatException nfe) {
            return 10;
        }
    }

    public String getClusterManagerNodeApiConnectionTimeout() {
        return this.getProperty(CLUSTER_MANAGER_NODE_API_CONNECTION_TIMEOUT, "30 sec");
    }

    public String getClusterManagerNodeApiReadTimeout() {
        return this.getProperty(CLUSTER_MANAGER_NODE_API_READ_TIMEOUT, "30 sec");
    }

    public int getClusterManagerNodeApiRequestThreads() {
        try {
            return Integer.parseInt(this.getProperty(CLUSTER_MANAGER_NODE_API_REQUEST_THREADS));
        }
        catch (NumberFormatException nfe) {
            return 10;
        }
    }

    public String getClusterManagerFlowRetrievalDelay() {
        return this.getProperty(CLUSTER_MANAGER_FLOW_RETRIEVAL_DELAY, "5 sec");
    }

    public int getClusterManagerProtocolThreads() {
        try {
            return Integer.parseInt(this.getProperty(CLUSTER_MANAGER_PROTOCOL_THREADS));
        }
        catch (NumberFormatException nfe) {
            return 10;
        }
    }

    public String getClusterManagerSafeModeDuration() {
        return this.getProperty(CLUSTER_MANAGER_SAFEMODE_DURATION, DEFAULT_CLUSTER_MANAGER_SAFEMODE_DURATION);
    }

    public String getClusterProtocolManagerToNodeApiScheme() {
        String isSecureProperty = this.getProperty(CLUSTER_PROTOCOL_IS_SECURE);
        if (Boolean.valueOf(isSecureProperty).booleanValue()) {
            return "https";
        }
        return "http";
    }

    public File getKerberosConfigurationFile() {
        String krb5File = this.getProperty(KERBEROS_KRB5_FILE);
        if (krb5File != null && krb5File.trim().length() > 0) {
            return new File(krb5File.trim());
        }
        return null;
    }

    public String getKerberosServicePrincipal() {
        String servicePrincipal = this.getProperty(KERBEROS_SERVICE_PRINCIPAL);
        if (!StringUtils.isBlank(servicePrincipal)) {
            return servicePrincipal.trim();
        }
        return null;
    }

    public String getKerberosKeytabLocation() {
        String keytabLocation = this.getProperty(KERBEROS_KEYTAB_LOCATION);
        if (!StringUtils.isBlank(keytabLocation)) {
            return keytabLocation.trim();
        }
        return null;
    }

    public String getKerberosAuthenticationExpiration() {
        String authenticationExpirationString = this.getProperty(KERBEROS_AUTHENTICATION_EXPIRATION, DEFAULT_KERBEROS_AUTHENTICATION_EXPIRATION);
        if (!StringUtils.isBlank(authenticationExpirationString)) {
            return authenticationExpirationString.trim();
        }
        return null;
    }

    public boolean isKerberosServiceSupportEnabled() {
        return !StringUtils.isBlank(this.getKerberosServicePrincipal()) && !StringUtils.isBlank(this.getKerberosKeytabLocation());
    }

    public boolean isClientAuthRequiredForRestApi() {
        return StringUtils.isBlank(this.getProperty(SECURITY_USER_LOGIN_IDENTITY_PROVIDER)) && this.getAnonymousAuthorities().isEmpty() && !this.isKerberosServiceSupportEnabled();
    }

    public InetSocketAddress getNodeApiAddress() {
        Integer port;
        String host;
        String scheme;
        String rawScheme = this.getClusterProtocolManagerToNodeApiScheme();
        String string = scheme = rawScheme == null ? "http" : rawScheme;
        if ("http".equalsIgnoreCase(scheme)) {
            host = StringUtils.isBlank(this.getProperty(WEB_HTTP_HOST)) ? "localhost" : this.getProperty(WEB_HTTP_HOST);
            port = this.getPort();
            if (port == null) {
                throw new RuntimeException(String.format("The %s must be specified if running in a cluster with %s set to false.", WEB_HTTP_PORT, CLUSTER_PROTOCOL_IS_SECURE));
            }
        } else {
            host = StringUtils.isBlank(this.getProperty(WEB_HTTPS_HOST)) ? "localhost" : this.getProperty(WEB_HTTPS_HOST);
            port = this.getSslPort();
            if (port == null) {
                throw new RuntimeException(String.format("The %s must be specified if running in a cluster with %s set to true.", WEB_HTTPS_PORT, CLUSTER_PROTOCOL_IS_SECURE));
            }
        }
        return InetSocketAddress.createUnresolved(host, port);
    }

    public Path getDatabaseRepositoryPath() {
        return Paths.get(this.getProperty(REPOSITORY_DATABASE_DIRECTORY), new String[0]);
    }

    public Path getFlowFileRepositoryPath() {
        return Paths.get(this.getProperty(FLOWFILE_REPOSITORY_DIRECTORY), new String[0]);
    }

    public Map<String, Path> getContentRepositoryPaths() {
        HashMap<String, Path> contentRepositoryPaths = new HashMap<String, Path>();
        for (String propertyName : this.stringPropertyNames()) {
            if (!StringUtils.startsWith(propertyName, REPOSITORY_CONTENT_PREFIX)) continue;
            String key = StringUtils.substringAfter(propertyName, REPOSITORY_CONTENT_PREFIX);
            contentRepositoryPaths.put(key, Paths.get(this.getProperty(propertyName), new String[0]));
        }
        return contentRepositoryPaths;
    }

    public Map<String, Path> getProvenanceRepositoryPaths() {
        HashMap<String, Path> provenanceRepositoryPaths = new HashMap<String, Path>();
        for (String propertyName : this.stringPropertyNames()) {
            if (!StringUtils.startsWith(propertyName, PROVENANCE_REPO_DIRECTORY_PREFIX)) continue;
            String key = StringUtils.substringAfter(propertyName, PROVENANCE_REPO_DIRECTORY_PREFIX);
            provenanceRepositoryPaths.put(key, Paths.get(this.getProperty(propertyName), new String[0]));
        }
        return provenanceRepositoryPaths;
    }

    public int getMaxFlowFilesPerClaim() {
        try {
            return Integer.parseInt(this.getProperty(MAX_FLOWFILES_PER_CLAIM));
        }
        catch (NumberFormatException nfe) {
            return 100;
        }
    }

    public String getMaxAppendableClaimSize() {
        return this.getProperty(MAX_APPENDABLE_CLAIM_SIZE);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String value = super.getProperty(key, defaultValue);
        if (value == null) {
            return null;
        }
        if (value.trim().isEmpty()) {
            return defaultValue;
        }
        return value;
    }

    public String getBoredYieldDuration() {
        return this.getProperty(BORED_YIELD_DURATION, DEFAULT_BORED_YIELD_DURATION);
    }

    public File getStateManagementConfigFile() {
        return new File(this.getProperty(STATE_MANAGEMENT_CONFIG_FILE, DEFAULT_STATE_MANAGEMENT_CONFIG_FILE));
    }

    public String getLocalStateProviderId() {
        return this.getProperty(STATE_MANAGEMENT_LOCAL_PROVIDER_ID);
    }

    public String getClusterStateProviderId() {
        return this.getProperty(STATE_MANAGEMENT_CLUSTER_PROVIDER_ID);
    }

    public File getEmbeddedZooKeeperPropertiesFile() {
        String filename = this.getProperty(STATE_MANAGEMENT_ZOOKEEPER_PROPERTIES);
        return filename == null ? null : new File(filename);
    }

    public boolean isStartEmbeddedZooKeeper() {
        return Boolean.parseBoolean(this.getProperty(STATE_MANAGEMENT_START_EMBEDDED_ZOOKEEPER));
    }

    public String getVariableRegistryProperties() {
        return this.getProperty(VARIABLE_REGISTRY_PROPERTIES);
    }

    public Path[] getVariableRegistryPropertiesPaths() {
        ArrayList<Path> vrPropertiesPaths = new ArrayList<Path>();
        String vrPropertiesFiles = this.getVariableRegistryProperties();
        if (!StringUtils.isEmpty(vrPropertiesFiles)) {
            List<String> vrPropertiesFileList = Arrays.asList(vrPropertiesFiles.split(","));
            for (String propertiesFile : vrPropertiesFileList) {
                String trimmed = propertiesFile.trim();
                if (trimmed.isEmpty()) continue;
                vrPropertiesPaths.add(Paths.get(trimmed, new String[0]));
            }
            return vrPropertiesPaths.toArray(new Path[vrPropertiesPaths.size()]);
        }
        return null;
    }
}

