/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.remoting.ChannelEventListener;
import org.apache.rocketmq.remoting.InvokeCallback;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.common.Pair;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.common.SemaphoreReleaseOnlyOnce;
import org.apache.rocketmq.remoting.common.ServiceThread;
import org.apache.rocketmq.remoting.exception.RemotingSendRequestException;
import org.apache.rocketmq.remoting.exception.RemotingTimeoutException;
import org.apache.rocketmq.remoting.exception.RemotingTooMuchRequestException;
import org.apache.rocketmq.remoting.netty.AsyncNettyRequestProcessor;
import org.apache.rocketmq.remoting.netty.NettyEvent;
import org.apache.rocketmq.remoting.netty.NettyLogger;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.netty.RemotingResponseCallback;
import org.apache.rocketmq.remoting.netty.RequestTask;
import org.apache.rocketmq.remoting.netty.ResponseFuture;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public abstract class NettyRemotingAbstract {
    private static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqRemoting");
    protected final Semaphore semaphoreOneway;
    protected final Semaphore semaphoreAsync;
    protected final ConcurrentMap<Integer, ResponseFuture> responseTable = new ConcurrentHashMap<Integer, ResponseFuture>(256);
    protected final HashMap<Integer, Pair<NettyRequestProcessor, ExecutorService>> processorTable = new HashMap(64);
    protected final NettyEventExecutor nettyEventExecutor = new NettyEventExecutor();
    protected Pair<NettyRequestProcessor, ExecutorService> defaultRequestProcessor;
    protected volatile SslContext sslContext;
    protected List<RPCHook> rpcHooks = new ArrayList<RPCHook>();

    public NettyRemotingAbstract(int permitsOneway, int permitsAsync) {
        this.semaphoreOneway = new Semaphore(permitsOneway, true);
        this.semaphoreAsync = new Semaphore(permitsAsync, true);
    }

    public abstract ChannelEventListener getChannelEventListener();

    public void putNettyEvent(NettyEvent event) {
        this.nettyEventExecutor.putNettyEvent(event);
    }

    public void processMessageReceived(ChannelHandlerContext ctx, RemotingCommand msg) throws Exception {
        RemotingCommand cmd = msg;
        if (cmd != null) {
            switch (cmd.getType()) {
                case REQUEST_COMMAND: {
                    this.processRequestCommand(ctx, cmd);
                    break;
                }
                case RESPONSE_COMMAND: {
                    this.processResponseCommand(ctx, cmd);
                    break;
                }
            }
        }
    }

    protected void doBeforeRpcHooks(String addr, RemotingCommand request) {
        if (this.rpcHooks.size() > 0) {
            for (RPCHook rpcHook : this.rpcHooks) {
                rpcHook.doBeforeRequest(addr, request);
            }
        }
    }

    protected void doAfterRpcHooks(String addr, RemotingCommand request, RemotingCommand response) {
        if (this.rpcHooks.size() > 0) {
            for (RPCHook rpcHook : this.rpcHooks) {
                rpcHook.doAfterResponse(addr, request, response);
            }
        }
    }

    public void processRequestCommand(final ChannelHandlerContext ctx, final RemotingCommand cmd) {
        Pair<NettyRequestProcessor, ExecutorService> matched = this.processorTable.get(cmd.getCode());
        final Pair<NettyRequestProcessor, ExecutorService> pair = null == matched ? this.defaultRequestProcessor : matched;
        final int opaque = cmd.getOpaque();
        if (pair != null) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    block4: {
                        try {
                            NettyRemotingAbstract.this.doBeforeRpcHooks(RemotingHelper.parseChannelRemoteAddr(ctx.channel()), cmd);
                            RemotingResponseCallback callback = new RemotingResponseCallback(){

                                @Override
                                public void callback(RemotingCommand response) {
                                    NettyRemotingAbstract.this.doAfterRpcHooks(RemotingHelper.parseChannelRemoteAddr(ctx.channel()), cmd, response);
                                    if (!cmd.isOnewayRPC() && response != null) {
                                        response.setOpaque(opaque);
                                        response.markResponseType();
                                        try {
                                            ctx.writeAndFlush((Object)response);
                                        }
                                        catch (Throwable e) {
                                            log.error("process request over, but response failed", e);
                                            log.error(cmd.toString());
                                            log.error(response.toString());
                                        }
                                    }
                                }
                            };
                            if (pair.getObject1() instanceof AsyncNettyRequestProcessor) {
                                AsyncNettyRequestProcessor processor = (AsyncNettyRequestProcessor)pair.getObject1();
                                processor.asyncProcessRequest(ctx, cmd, callback);
                            } else {
                                NettyRequestProcessor processor = (NettyRequestProcessor)pair.getObject1();
                                RemotingCommand response = processor.processRequest(ctx, cmd);
                                NettyRemotingAbstract.this.doAfterRpcHooks(RemotingHelper.parseChannelRemoteAddr(ctx.channel()), cmd, response);
                                callback.callback(response);
                            }
                        }
                        catch (Throwable e) {
                            log.error("process request exception", e);
                            log.error(cmd.toString());
                            if (cmd.isOnewayRPC()) break block4;
                            RemotingCommand response = RemotingCommand.createResponseCommand(1, RemotingHelper.exceptionSimpleDesc(e));
                            response.setOpaque(opaque);
                            ctx.writeAndFlush((Object)response);
                        }
                    }
                }
            };
            if (pair.getObject1().rejectRequest()) {
                RemotingCommand response = RemotingCommand.createResponseCommand(2, "[REJECTREQUEST]system busy, start flow control for a while");
                response.setOpaque(opaque);
                ctx.writeAndFlush((Object)response);
                return;
            }
            try {
                RequestTask requestTask = new RequestTask(run, ctx.channel(), cmd);
                pair.getObject2().submit(requestTask);
            }
            catch (RejectedExecutionException e) {
                if (System.currentTimeMillis() % 10000L == 0L) {
                    log.warn(RemotingHelper.parseChannelRemoteAddr(ctx.channel()) + ", too many requests and system thread pool busy, RejectedExecutionException " + pair.getObject2().toString() + " request code: " + cmd.getCode());
                }
                if (!cmd.isOnewayRPC()) {
                    RemotingCommand response = RemotingCommand.createResponseCommand(2, "[OVERLOAD]system busy, start flow control for a while");
                    response.setOpaque(opaque);
                    ctx.writeAndFlush((Object)response);
                }
            }
        } else {
            String error = " request type " + cmd.getCode() + " not supported";
            RemotingCommand response = RemotingCommand.createResponseCommand(3, error);
            response.setOpaque(opaque);
            ctx.writeAndFlush((Object)response);
            log.error(RemotingHelper.parseChannelRemoteAddr(ctx.channel()) + error);
        }
    }

    public void processResponseCommand(ChannelHandlerContext ctx, RemotingCommand cmd) {
        int opaque = cmd.getOpaque();
        ResponseFuture responseFuture = (ResponseFuture)this.responseTable.get(opaque);
        if (responseFuture != null) {
            responseFuture.setResponseCommand(cmd);
            this.responseTable.remove(opaque);
            if (responseFuture.getInvokeCallback() != null) {
                this.executeInvokeCallback(responseFuture);
            } else {
                responseFuture.putResponse(cmd);
                responseFuture.release();
            }
        } else {
            log.warn("receive response, but not matched any request, " + RemotingHelper.parseChannelRemoteAddr(ctx.channel()));
            log.warn(cmd.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInvokeCallback(final ResponseFuture responseFuture) {
        boolean runInThisThread = false;
        ExecutorService executor = this.getCallbackExecutor();
        if (executor != null) {
            try {
                executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            responseFuture.executeInvokeCallback();
                        }
                        catch (Throwable e) {
                            log.warn("execute callback in executor exception, and callback throw", e);
                        }
                        finally {
                            responseFuture.release();
                        }
                    }
                });
            }
            catch (Exception e) {
                runInThisThread = true;
                log.warn("execute callback in executor exception, maybe executor busy", (Throwable)e);
            }
        } else {
            runInThisThread = true;
        }
        if (runInThisThread) {
            try {
                responseFuture.executeInvokeCallback();
            }
            catch (Throwable e) {
                log.warn("executeInvokeCallback Exception", e);
            }
            finally {
                responseFuture.release();
            }
        }
    }

    @Deprecated
    protected RPCHook getRPCHook() {
        if (this.rpcHooks.size() > 0) {
            return this.rpcHooks.get(0);
        }
        return null;
    }

    public List<RPCHook> getRPCHooks() {
        return this.rpcHooks;
    }

    public abstract ExecutorService getCallbackExecutor();

    public void scanResponseTable() {
        LinkedList<ResponseFuture> rfList = new LinkedList<ResponseFuture>();
        Iterator it = this.responseTable.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            ResponseFuture rep = (ResponseFuture)next.getValue();
            if (rep.getBeginTimestamp() + rep.getTimeoutMillis() + 1000L > System.currentTimeMillis()) continue;
            rep.release();
            it.remove();
            rfList.add(rep);
            log.warn("remove timeout request, " + rep);
        }
        for (ResponseFuture rf : rfList) {
            try {
                this.executeInvokeCallback(rf);
            }
            catch (Throwable e) {
                log.warn("scanResponseTable, operationComplete Exception", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemotingCommand invokeSyncImpl(Channel channel, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingSendRequestException, RemotingTimeoutException {
        final int opaque = request.getOpaque();
        try {
            final ResponseFuture responseFuture = new ResponseFuture(channel, opaque, timeoutMillis, null, null);
            this.responseTable.put(opaque, responseFuture);
            final SocketAddress addr = channel.remoteAddress();
            channel.writeAndFlush((Object)request).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture f) throws Exception {
                    if (f.isSuccess()) {
                        responseFuture.setSendRequestOK(true);
                        return;
                    }
                    responseFuture.setSendRequestOK(false);
                    NettyRemotingAbstract.this.responseTable.remove(opaque);
                    responseFuture.setCause(f.cause());
                    responseFuture.putResponse(null);
                    log.warn("send a request command to channel <" + addr + "> failed.");
                }
            });
            RemotingCommand responseCommand = responseFuture.waitResponse(timeoutMillis);
            if (null == responseCommand) {
                if (responseFuture.isSendRequestOK()) {
                    throw new RemotingTimeoutException(RemotingHelper.parseSocketAddressAddr(addr), timeoutMillis, responseFuture.getCause());
                }
                throw new RemotingSendRequestException(RemotingHelper.parseSocketAddressAddr(addr), responseFuture.getCause());
            }
            RemotingCommand remotingCommand = responseCommand;
            return remotingCommand;
        }
        finally {
            this.responseTable.remove(opaque);
        }
    }

    public void invokeAsyncImpl(final Channel channel, RemotingCommand request, long timeoutMillis, InvokeCallback invokeCallback) throws InterruptedException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        long beginStartTime = System.currentTimeMillis();
        final int opaque = request.getOpaque();
        boolean acquired = this.semaphoreAsync.tryAcquire(timeoutMillis, TimeUnit.MILLISECONDS);
        if (acquired) {
            SemaphoreReleaseOnlyOnce once = new SemaphoreReleaseOnlyOnce(this.semaphoreAsync);
            long costTime = System.currentTimeMillis() - beginStartTime;
            if (timeoutMillis < costTime) {
                once.release();
                throw new RemotingTimeoutException("invokeAsyncImpl call timeout");
            }
            final ResponseFuture responseFuture = new ResponseFuture(channel, opaque, timeoutMillis - costTime, invokeCallback, once);
            this.responseTable.put(opaque, responseFuture);
            try {
                channel.writeAndFlush((Object)request).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture f) throws Exception {
                        if (f.isSuccess()) {
                            responseFuture.setSendRequestOK(true);
                            return;
                        }
                        NettyRemotingAbstract.this.requestFail(opaque);
                        log.warn("send a request command to channel <{}> failed.", (Object)RemotingHelper.parseChannelRemoteAddr(channel));
                    }
                });
            }
            catch (Exception e) {
                responseFuture.release();
                log.warn("send a request command to channel <" + RemotingHelper.parseChannelRemoteAddr(channel) + "> Exception", (Throwable)e);
                throw new RemotingSendRequestException(RemotingHelper.parseChannelRemoteAddr(channel), e);
            }
        } else {
            if (timeoutMillis <= 0L) {
                throw new RemotingTooMuchRequestException("invokeAsyncImpl invoke too fast");
            }
            String info = String.format("invokeAsyncImpl tryAcquire semaphore timeout, %dms, waiting thread nums: %d semaphoreAsyncValue: %d", timeoutMillis, this.semaphoreAsync.getQueueLength(), this.semaphoreAsync.availablePermits());
            log.warn(info);
            throw new RemotingTimeoutException(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestFail(int opaque) {
        ResponseFuture responseFuture = (ResponseFuture)this.responseTable.remove(opaque);
        if (responseFuture != null) {
            responseFuture.setSendRequestOK(false);
            responseFuture.putResponse(null);
            try {
                this.executeInvokeCallback(responseFuture);
            }
            catch (Throwable e) {
                log.warn("execute callback in requestFail, and callback throw", e);
            }
            finally {
                responseFuture.release();
            }
        }
    }

    protected void failFast(Channel channel) {
        for (Map.Entry entry : this.responseTable.entrySet()) {
            Integer opaque;
            if (((ResponseFuture)entry.getValue()).getProcessChannel() != channel || (opaque = (Integer)entry.getKey()) == null) continue;
            this.requestFail(opaque);
        }
    }

    public void invokeOnewayImpl(final Channel channel, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        request.markOnewayRPC();
        boolean acquired = this.semaphoreOneway.tryAcquire(timeoutMillis, TimeUnit.MILLISECONDS);
        if (acquired) {
            final SemaphoreReleaseOnlyOnce once = new SemaphoreReleaseOnlyOnce(this.semaphoreOneway);
            try {
                channel.writeAndFlush((Object)request).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture f) throws Exception {
                        once.release();
                        if (!f.isSuccess()) {
                            log.warn("send a request command to channel <" + channel.remoteAddress() + "> failed.");
                        }
                    }
                });
            }
            catch (Exception e) {
                once.release();
                log.warn("write send a request command to channel <" + channel.remoteAddress() + "> failed.");
                throw new RemotingSendRequestException(RemotingHelper.parseChannelRemoteAddr(channel), e);
            }
        } else {
            if (timeoutMillis <= 0L) {
                throw new RemotingTooMuchRequestException("invokeOnewayImpl invoke too fast");
            }
            String info = String.format("invokeOnewayImpl tryAcquire semaphore timeout, %dms, waiting thread nums: %d semaphoreAsyncValue: %d", timeoutMillis, this.semaphoreOneway.getQueueLength(), this.semaphoreOneway.availablePermits());
            log.warn(info);
            throw new RemotingTimeoutException(info);
        }
    }

    static {
        NettyLogger.initNettyLogger();
    }

    class NettyEventExecutor
    extends ServiceThread {
        private final LinkedBlockingQueue<NettyEvent> eventQueue = new LinkedBlockingQueue();
        private final int maxSize = 10000;

        NettyEventExecutor() {
        }

        public void putNettyEvent(NettyEvent event) {
            if (this.eventQueue.size() <= 10000) {
                this.eventQueue.add(event);
            } else {
                log.warn("event queue size[{}] enough, so drop this event {}", (Object)this.eventQueue.size(), (Object)event.toString());
            }
        }

        @Override
        public void run() {
            log.info(this.getServiceName() + " service started");
            ChannelEventListener listener = NettyRemotingAbstract.this.getChannelEventListener();
            while (!this.isStopped()) {
                try {
                    NettyEvent event = this.eventQueue.poll(3000L, TimeUnit.MILLISECONDS);
                    if (event == null || listener == null) continue;
                    switch (event.getType()) {
                        case IDLE: {
                            listener.onChannelIdle(event.getRemoteAddr(), event.getChannel());
                            break;
                        }
                        case CLOSE: {
                            listener.onChannelClose(event.getRemoteAddr(), event.getChannel());
                            break;
                        }
                        case CONNECT: {
                            listener.onChannelConnect(event.getRemoteAddr(), event.getChannel());
                            break;
                        }
                        case EXCEPTION: {
                            listener.onChannelException(event.getRemoteAddr(), event.getChannel());
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    log.warn(this.getServiceName() + " service has exception. ", (Throwable)e);
                }
            }
            log.info(this.getServiceName() + " service end");
        }

        @Override
        public String getServiceName() {
            return NettyEventExecutor.class.getSimpleName();
        }
    }
}

