/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.spring.starter;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.impl.MQClientAPIImpl;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.spring.starter.RocketMQProperties;
import org.apache.rocketmq.spring.starter.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.starter.core.DefaultRocketMQListenerContainer;
import org.apache.rocketmq.spring.starter.core.RocketMQListener;
import org.apache.rocketmq.spring.starter.core.RocketMQTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.util.Assert;

@Configuration
@EnableConfigurationProperties(value={RocketMQProperties.class})
@ConditionalOnClass(value={MQClientAPIImpl.class})
@Order
public class RocketMQAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RocketMQAutoConfiguration.class);

    @Bean
    @ConditionalOnClass(value={DefaultMQProducer.class})
    @ConditionalOnMissingBean(value={DefaultMQProducer.class})
    @ConditionalOnProperty(prefix="spring.rocketmq", value={"nameServer", "producer.group"})
    public DefaultMQProducer mqProducer(RocketMQProperties rocketMQProperties) {
        RocketMQProperties.Producer producerConfig = rocketMQProperties.getProducer();
        String groupName = producerConfig.getGroup();
        Assert.hasText((String)groupName, (String)"[spring.rocketmq.producer.group] must not be null");
        DefaultMQProducer producer = null;
        if (!StringUtils.isEmpty((CharSequence)rocketMQProperties.getAccessKey()) && !StringUtils.isEmpty((CharSequence)rocketMQProperties.getSecretKey())) {
            AclClientRPCHook hook = new AclClientRPCHook(new SessionCredentials(rocketMQProperties.getAccessKey(), rocketMQProperties.getSecretKey()));
            producer = new DefaultMQProducer(producerConfig.getGroup(), (RPCHook)hook);
        } else {
            producer = new DefaultMQProducer(producerConfig.getGroup());
        }
        producer.setNamesrvAddr(rocketMQProperties.getNameServer());
        producer.setSendMsgTimeout(producerConfig.getSendMsgTimeout());
        producer.setRetryTimesWhenSendFailed(producerConfig.getRetryTimesWhenSendFailed());
        producer.setRetryTimesWhenSendAsyncFailed(producerConfig.getRetryTimesWhenSendAsyncFailed());
        producer.setMaxMessageSize(producerConfig.getMaxMessageSize());
        producer.setCompressMsgBodyOverHowmuch(producerConfig.getCompressMsgBodyOverHowmuch());
        producer.setRetryAnotherBrokerWhenNotStoreOK(producerConfig.isRetryAnotherBrokerWhenNotStoreOk());
        return producer;
    }

    @Bean
    @ConditionalOnClass(value={ObjectMapper.class})
    @ConditionalOnMissingBean(name={"rocketMQMessageObjectMapper"})
    public ObjectMapper rocketMQMessageObjectMapper() {
        return new ObjectMapper();
    }

    @Bean(destroyMethod="destroy")
    @ConditionalOnBean(value={DefaultMQProducer.class})
    @ConditionalOnMissingBean(name={"rocketMQTemplate"})
    public RocketMQTemplate rocketMQTemplate(DefaultMQProducer mqProducer, @Autowired(required=false) @Qualifier(value="rocketMQMessageObjectMapper") ObjectMapper objectMapper) {
        RocketMQTemplate rocketMQTemplate = new RocketMQTemplate();
        rocketMQTemplate.setProducer(mqProducer);
        if (Objects.nonNull(objectMapper)) {
            rocketMQTemplate.setObjectMapper(objectMapper);
        }
        return rocketMQTemplate;
    }

    @Configuration
    @ConditionalOnClass(value={DefaultMQPushConsumer.class})
    @EnableConfigurationProperties(value={RocketMQProperties.class})
    @ConditionalOnProperty(prefix="spring.rocketmq", value={"nameServer"})
    @Order
    public static class ListenerContainerConfiguration
    implements ApplicationContextAware,
    InitializingBean {
        private ConfigurableApplicationContext applicationContext;
        private AtomicLong counter = new AtomicLong(0L);
        @Resource
        private StandardEnvironment environment;
        @Resource
        private RocketMQProperties rocketMQProperties;
        private ObjectMapper objectMapper;

        public ListenerContainerConfiguration() {
        }

        @Autowired(required=false)
        public ListenerContainerConfiguration(@Qualifier(value="rocketMQMessageObjectMapper") ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
        }

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            this.applicationContext = (ConfigurableApplicationContext)applicationContext;
        }

        public void afterPropertiesSet() {
            Map beans = this.applicationContext.getBeansWithAnnotation(RocketMQMessageListener.class);
            if (Objects.nonNull(beans)) {
                beans.forEach(this::registerContainer);
            }
        }

        private void registerContainer(String beanName, Object bean) {
            Class clazz = AopUtils.getTargetClass((Object)bean);
            if (!RocketMQListener.class.isAssignableFrom(bean.getClass())) {
                throw new IllegalStateException(clazz + " is not instance of " + RocketMQListener.class.getName());
            }
            RocketMQListener rocketMQListener = (RocketMQListener)bean;
            RocketMQMessageListener annotation = clazz.getAnnotation(RocketMQMessageListener.class);
            BeanDefinitionBuilder beanBuilder = BeanDefinitionBuilder.rootBeanDefinition(DefaultRocketMQListenerContainer.class);
            beanBuilder.addPropertyValue("accessKey", (Object)this.rocketMQProperties.getAccessKey());
            beanBuilder.addPropertyValue("secretKey", (Object)this.rocketMQProperties.getSecretKey());
            beanBuilder.addPropertyValue("nameServer", (Object)this.rocketMQProperties.getNameServer());
            beanBuilder.addPropertyValue("topic", (Object)this.environment.resolvePlaceholders(annotation.topic()));
            beanBuilder.addPropertyValue("consumerGroup", (Object)this.environment.resolvePlaceholders(annotation.consumerGroup()));
            beanBuilder.addPropertyValue("consumeMode", (Object)annotation.consumeMode());
            beanBuilder.addPropertyValue("consumeThreadMax", (Object)annotation.consumeThreadMax());
            beanBuilder.addPropertyValue("messageModel", (Object)annotation.messageModel());
            beanBuilder.addPropertyValue("selectorExpress", (Object)this.environment.resolvePlaceholders(annotation.selectorExpress()));
            beanBuilder.addPropertyValue("selectorType", (Object)annotation.selectorType());
            beanBuilder.addPropertyValue("rocketMQListener", (Object)rocketMQListener);
            if (Objects.nonNull(this.objectMapper)) {
                beanBuilder.addPropertyValue("objectMapper", (Object)this.objectMapper);
            }
            beanBuilder.setDestroyMethodName("destroy");
            String containerBeanName = String.format("%s_%s", DefaultRocketMQListenerContainer.class.getName(), this.counter.incrementAndGet());
            DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)this.applicationContext.getBeanFactory();
            beanFactory.registerBeanDefinition(containerBeanName, (BeanDefinition)beanBuilder.getBeanDefinition());
            DefaultRocketMQListenerContainer container = (DefaultRocketMQListenerContainer)beanFactory.getBean(containerBeanName, DefaultRocketMQListenerContainer.class);
            if (!container.isStarted()) {
                try {
                    container.start();
                }
                catch (Exception e) {
                    log.error("started container failed. {}", (Object)container, (Object)e);
                    throw new RuntimeException(e);
                }
            }
            log.info("register rocketMQ listener to container, listenerBeanName:{}, containerBeanName:{}", (Object)beanName, (Object)containerBeanName);
        }
    }
}

