/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.tooling.depends;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.DefaultArtifactCollector;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.servicemix.tooling.depends.DependencyComparator;
import org.sonatype.plexus.build.incremental.BuildContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="generate-depends-file", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.TEST)
public class GenerateDependsFileMojo
extends AbstractMojo {
    protected static final String SEPARATOR = "/";
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(required=true, defaultValue="true")
    protected boolean recursive;
    @Parameter(defaultValue="true")
    protected boolean includeVersion;
    @Parameter(defaultValue="true")
    protected boolean includeClassifier;
    @Parameter(defaultValue="true")
    protected boolean includeScope;
    @Parameter(defaultValue="true")
    protected boolean includeType;
    @Parameter(defaultValue="${project.build.directory}/classes/META-INF/maven/dependencies.properties")
    private File outputFile;
    @Parameter(defaultValue="${localRepository}")
    protected ArtifactRepository localRepo;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}")
    protected List remoteRepos;
    @Parameter(defaultValue="${filterGroupIds}")
    protected String[] filterGroupIds;
    @Component
    protected ArtifactMetadataSource artifactMetadataSource;
    @Component
    protected ArtifactResolver resolver;
    protected ArtifactCollector collector = new DefaultArtifactCollector();
    @Component
    protected ArtifactFactory factory;
    @Component
    private BuildContext buildContext;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.buildContext.hasDelta("pom.xml")) {
            List<Dependency> dependencies = this.getDependencies();
            this.writeDependencies(dependencies);
        }
    }

    private List<Dependency> getDependencies() {
        ArrayList<Dependency> dependencies;
        if (!this.recursive) {
            dependencies = this.project.getDependencies();
            if (this.filterGroupIds.length != 0) {
                Iterator dependencyIterator = dependencies.iterator();
                while (dependencyIterator.hasNext()) {
                    Dependency dependency = (Dependency)dependencyIterator.next();
                    if (this.doFilterGroupId(dependency.getGroupId())) continue;
                    dependencyIterator.remove();
                }
            }
        } else {
            Set artifacts = this.project.getArtifacts();
            dependencies = new ArrayList<Dependency>();
            for (Artifact a : artifacts) {
                if (this.filterGroupIds.length != 0 && !this.doFilterGroupId(a.getGroupId())) continue;
                dependencies.add(this.generateDependency(a));
            }
        }
        Collections.sort(dependencies, new DependencyComparator());
        return dependencies;
    }

    private void writeDependencies(List<Dependency> dependencies) throws MojoExecutionException {
        OutputStream out = null;
        try {
            this.outputFile.getParentFile().mkdirs();
            out = this.buildContext.newFileOutputStream(this.outputFile);
            PrintStream printer = new PrintStream(out);
            this.populateProperties(printer, dependencies);
            this.getLog().info((CharSequence)("Created: " + this.outputFile));
            this.safeClose(out);
        }
        catch (Exception e) {
            try {
                throw new MojoExecutionException("Unable to create dependencies file: " + e, e);
            }
            catch (Throwable throwable) {
                this.safeClose(out);
                throw throwable;
            }
        }
    }

    protected boolean doFilterGroupId(String groupId) {
        return Arrays.asList(this.filterGroupIds).indexOf(groupId) > -1;
    }

    protected Dependency generateDependency(Artifact a) {
        Dependency dep = new Dependency();
        dep.setGroupId(a.getGroupId());
        dep.setArtifactId(a.getArtifactId());
        dep.setVersion(a.getBaseVersion());
        dep.setClassifier(a.getClassifier());
        dep.setType(a.getType());
        dep.setScope(a.getScope());
        return dep;
    }

    protected void populateProperties(PrintStream out, List<Dependency> dependencies) {
        out.println("# Project dependencies generated by the Apache ServiceMix Maven Plugin");
        out.println("# Generated at: " + new Date());
        out.println();
        out.println("groupId = " + this.project.getGroupId());
        out.println("artifactId = " + this.project.getArtifactId());
        out.println("version = " + this.project.getVersion());
        out.println(this.project.getGroupId() + SEPARATOR + this.project.getArtifactId() + SEPARATOR + "version = " + this.project.getVersion());
        out.println();
        out.println("# dependencies");
        out.println();
        for (Dependency dependency : dependencies) {
            String classifier;
            String prefix = dependency.getGroupId() + SEPARATOR + dependency.getArtifactId() + SEPARATOR;
            if (this.includeVersion) {
                out.println(prefix + "version = " + dependency.getVersion());
            }
            if ((classifier = dependency.getClassifier()) != null && this.includeClassifier) {
                out.println(prefix + "classifier = " + classifier);
            }
            if (this.includeType) {
                out.println(prefix + "type = " + dependency.getType());
            }
            if (this.includeScope) {
                out.println(prefix + "scope = " + dependency.getScope());
            }
            out.println();
            this.getLog().debug((CharSequence)("Dependency: " + dependency + " classifier: " + classifier + " type: " + dependency.getType()));
        }
    }

    private void safeClose(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException e) {
                this.getLog().info((CharSequence)("Failed to close: " + this.outputFile + ". Reason: " + e), (Throwable)e);
            }
        }
    }
}

