/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.executor.customized;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.calcite.interpreter.InterpretableConvention;
import org.apache.calcite.interpreter.InterpretableConverter;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.federation.executor.FederationContext;
import org.apache.shardingsphere.infra.federation.executor.FederationExecutor;
import org.apache.shardingsphere.infra.federation.executor.customized.CustomizedFilterableExecuteDataContext;
import org.apache.shardingsphere.infra.federation.optimizer.ShardingSphereOptimizer;
import org.apache.shardingsphere.infra.federation.optimizer.context.OptimizerContext;
import org.apache.shardingsphere.infra.federation.optimizer.context.planner.OptimizerPlannerContext;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class CustomizedFilterableExecutor
implements FederationExecutor {
    private final String databaseName;
    private final String schemaName;
    private final ShardingSphereOptimizer optimizer;

    public CustomizedFilterableExecutor(String databaseName, String schemaName, OptimizerContext context) {
        this.databaseName = databaseName;
        this.schemaName = schemaName;
        this.optimizer = new ShardingSphereOptimizer(context);
    }

    @Override
    public ResultSet executeQuery(DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, JDBCExecutorCallback<? extends ExecuteResult> callback, FederationContext federationContext) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getResultSet() {
        return null;
    }

    private Enumerable<Object[]> execute(SQLStatement sqlStatement) {
        return this.execute(this.optimizer.optimize(this.databaseName, this.schemaName, sqlStatement));
    }

    private Enumerable<Object[]> execute(RelNode bestPlan) {
        RelOptCluster cluster = ((SqlToRelConverter)((OptimizerPlannerContext)this.optimizer.getContext().getPlannerContexts().get(this.databaseName)).getConverters().get(this.schemaName)).getCluster();
        return new FederateInterpretableConverter(cluster, cluster.traitSetOf((RelTrait)InterpretableConvention.INSTANCE), bestPlan).bind(new CustomizedFilterableExecuteDataContext(this.databaseName, this.schemaName, this.optimizer.getContext()));
    }

    @Override
    public void close() {
    }

    public static final class FederateInterpretableConverter
    extends InterpretableConverter {
        public FederateInterpretableConverter(RelOptCluster cluster, RelTraitSet traits, RelNode input) {
            super(cluster, traits, input);
        }
    }
}

