/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.api.config;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.RuleConfiguration;

public final class ShadowRuleConfiguration
implements RuleConfiguration {
    private final String column;
    private final List<String> sourceDataSourceNames;
    private final List<String> shadowDataSourceNames;

    public ShadowRuleConfiguration(String column, List<String> sourceDataSourceNames, List<String> shadowDataSourceNames) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)column) ? 1 : 0) != 0, (Object)"Column is required.");
        Preconditions.checkArgument((!sourceDataSourceNames.isEmpty() ? 1 : 0) != 0, (Object)"SourceDataSourceNames is required.");
        Preconditions.checkArgument((!shadowDataSourceNames.isEmpty() ? 1 : 0) != 0, (Object)"ShadowDataSourceNames is required.");
        Preconditions.checkArgument((sourceDataSourceNames.size() == shadowDataSourceNames.size() ? 1 : 0) != 0, (Object)"SourceDataSourceNames and ShadowDataSourceNames size must same.");
        this.column = column;
        this.sourceDataSourceNames = sourceDataSourceNames;
        this.shadowDataSourceNames = shadowDataSourceNames;
    }

    @Generated
    public String getColumn() {
        return this.column;
    }

    @Generated
    public List<String> getSourceDataSourceNames() {
        return this.sourceDataSourceNames;
    }

    @Generated
    public List<String> getShadowDataSourceNames() {
        return this.shadowDataSourceNames;
    }
}

