/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka010;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import kafka.admin.AdminUtils$;
import kafka.api.LeaderAndIsr;
import kafka.api.PartitionStateInfo;
import kafka.api.Request$;
import kafka.producer.KeyedMessage;
import kafka.producer.Producer;
import kafka.producer.ProducerConfig;
import kafka.serializer.StringEncoder;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.kafka010.KafkaTestUtils$$anonfun$org$apache$spark$streaming$kafka010$KafkaTestUtils$;
import org.apache.spark.util.Utils$;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tme!B\u0001\u0003\u0001\ta!AD&bM.\fG+Z:u+RLGn\u001d\u0006\u0003\u0007\u0011\t\u0001b[1gW\u0006\u0004\u0014\u0007\r\u0006\u0003\u000b\u0019\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c2\u0001A\u0007\u0014!\tq\u0011#D\u0001\u0010\u0015\u0005\u0001\u0012!B:dC2\f\u0017B\u0001\n\u0010\u0005\u0019\te.\u001f*fMB\u0011AcF\u0007\u0002+)\u0011aCB\u0001\tS:$XM\u001d8bY&\u0011\u0001$\u0006\u0002\b\u0019><w-\u001b8h\u0011\u0015Q\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}\r\u0001A#A\u000f\u0011\u0005y\u0001Q\"\u0001\u0002\t\u000f\u0001\u0002!\u0019!C\u0005C\u00051!p\u001b%pgR,\u0012A\t\t\u0003G!j\u0011\u0001\n\u0006\u0003K\u0019\nA\u0001\\1oO*\tq%\u0001\u0003kCZ\f\u0017BA\u0015%\u0005\u0019\u0019FO]5oO\"11\u0006\u0001Q\u0001\n\t\nqA_6I_N$\b\u0005C\u0004.\u0001\u0001\u0007I\u0011\u0002\u0018\u0002\ri\\\u0007k\u001c:u+\u0005y\u0003C\u0001\b1\u0013\t\ttBA\u0002J]RDqa\r\u0001A\u0002\u0013%A'\u0001\u0006{WB{'\u000f^0%KF$\"!\u000e\u001d\u0011\u000591\u0014BA\u001c\u0010\u0005\u0011)f.\u001b;\t\u000fe\u0012\u0014\u0011!a\u0001_\u0005\u0019\u0001\u0010J\u0019\t\rm\u0002\u0001\u0015)\u00030\u0003\u001dQ8\u000eU8si\u0002Bq!\u0010\u0001C\u0002\u0013%a&A\n{W\u000e{gN\\3di&|g\u000eV5nK>,H\u000f\u0003\u0004@\u0001\u0001\u0006IaL\u0001\u0015u.\u001cuN\u001c8fGRLwN\u001c+j[\u0016|W\u000f\u001e\u0011\t\u000f\u0005\u0003!\u0019!C\u0005]\u0005\u0001\"p[*fgNLwN\u001c+j[\u0016|W\u000f\u001e\u0005\u0007\u0007\u0002\u0001\u000b\u0011B\u0018\u0002#i\\7+Z:tS>tG+[7f_V$\b\u0005C\u0005F\u0001\u0001\u0007\t\u0019!C\u0005\r\u0006I!p\\8lK\u0016\u0004XM]\u000b\u0002\u000fB\u0011\u0001*S\u0007\u0002\u0001\u0019!!\n\u0001\u0003L\u0005E)UNY3eI\u0016$'l\\8lK\u0016\u0004XM]\n\u0003\u00136A\u0001\"T%\u0003\u0006\u0004%\tAT\u0001\nu.\u001cuN\u001c8fGR,\u0012a\u0014\t\u0003!Ns!AD)\n\u0005I{\u0011A\u0002)sK\u0012,g-\u0003\u0002*)*\u0011!k\u0004\u0005\t-&\u0013\t\u0011)A\u0005\u001f\u0006Q!p[\"p]:,7\r\u001e\u0011\t\u000biIE\u0011\u0001-\u0015\u0005\u001dK\u0006\"B'X\u0001\u0004y\u0005bB.J\u0005\u0004%\t\u0001X\u0001\fg:\f\u0007o\u001d5pi\u0012K'/F\u0001^!\tq\u0016-D\u0001`\u0015\t\u0001g%\u0001\u0002j_&\u0011!m\u0018\u0002\u0005\r&dW\r\u0003\u0004e\u0013\u0002\u0006I!X\u0001\rg:\f\u0007o\u001d5pi\u0012K'\u000f\t\u0005\bM&\u0013\r\u0011\"\u0001]\u0003\u0019awn\u001a#je\"1\u0001.\u0013Q\u0001\nu\u000bq\u0001\\8h\t&\u0014\b\u0005C\u0004F\u0013\n\u0007I\u0011\u00016\u0016\u0003-\u0004\"\u0001\u001c9\u000e\u00035T!A\\8\u0002\rM,'O^3s\u0015\t)\u0005\"\u0003\u0002r[\ny!l\\8LK\u0016\u0004XM]*feZ,'\u000f\u0003\u0004t\u0013\u0002\u0006Ia[\u0001\u000bu>|7.Z3qKJ\u0004\u0003BC;J!\u0003\u0005\u0019\u0011)A\u0005m\u0006\u0019\u0001\u0010J\u001a\u0011\t99(eL\u0005\u0003q>\u0011a\u0001V;qY\u0016\u0014\u0004b\u0002>J\u0005\u0004%\t!I\u0001\u0003SBDa\u0001`%!\u0002\u0013\u0011\u0013aA5qA!9a0\u0013b\u0001\n\u0003q\u0013\u0001\u00029peRDq!!\u0001JA\u0003%q&A\u0003q_J$\b\u0005C\u0005\u0002\u0006%\u0013\r\u0011\"\u0001\u0002\b\u00059a-Y2u_JLXCAA\u0005!\ra\u00171B\u0005\u0004\u0003\u001bi'\u0001\u0006(J\u001fN+'O^3s\u0007:DhNR1di>\u0014\u0018\u0010\u0003\u0005\u0002\u0012%\u0003\u000b\u0011BA\u0005\u0003!1\u0017m\u0019;pef\u0004\u0003\u0002CA\u000b\u0013\n\u0007I\u0011\u0001\u0018\u0002\u0015\u0005\u001cG/^1m!>\u0014H\u000fC\u0004\u0002\u001a%\u0003\u000b\u0011B\u0018\u0002\u0017\u0005\u001cG/^1m!>\u0014H\u000f\t\u0005\b\u0003;IE\u0011AA\u0010\u0003!\u0019\b.\u001e;e_^tG#A\u001b\t\u0017\u0005\r\u0002\u00011AA\u0002\u0013%\u0011QE\u0001\u000eu>|7.Z3qKJ|F%Z9\u0015\u0007U\n9\u0003\u0003\u0005:\u0003C\t\t\u00111\u0001H\u0011\u0019\u0019\b\u0001)Q\u0005\u000f\"Y\u0011Q\u0006\u0001A\u0002\u0003\u0007I\u0011BA\u0018\u0003\u001dQ8.\u0016;jYN,\"!!\r\u0011\t\u0005M\u0012QH\u0007\u0003\u0003kQA!a\u000e\u0002:\u0005)Q\u000f^5mg*\u0011\u00111H\u0001\u0006W\u000647.Y\u0005\u0005\u0003\u007f\t)DA\u0004[WV#\u0018\u000e\\:\t\u0017\u0005\r\u0003\u00011AA\u0002\u0013%\u0011QI\u0001\fu.,F/\u001b7t?\u0012*\u0017\u000fF\u00026\u0003\u000fB\u0011\"OA!\u0003\u0003\u0005\r!!\r\t\u0011\u0005-\u0003\u0001)Q\u0005\u0003c\t\u0001B_6Vi&d7\u000f\t\u0005\t\u0003\u001f\u0002!\u0019!C\u0005C\u0005Q!M]8lKJDun\u001d;\t\u000f\u0005M\u0003\u0001)A\u0005E\u0005Y!M]8lKJDun\u001d;!\u0011!\t9\u0006\u0001a\u0001\n\u0013q\u0013A\u00032s_.,'\u000fU8si\"I\u00111\f\u0001A\u0002\u0013%\u0011QL\u0001\u000fEJ|7.\u001a:Q_J$x\fJ3r)\r)\u0014q\f\u0005\ts\u0005e\u0013\u0011!a\u0001_!9\u00111\r\u0001!B\u0013y\u0013a\u00032s_.,'\u000fU8si\u0002B1\"a\u001a\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002j\u0005Q!M]8lKJ\u001cuN\u001c4\u0016\u0005\u0005-\u0004\u0003BA7\u0003cj!!a\u001c\u000b\u00079\fI$\u0003\u0003\u0002t\u0005=$aC&bM.\f7i\u001c8gS\u001eD1\"a\u001e\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002z\u0005q!M]8lKJ\u001cuN\u001c4`I\u0015\fHcA\u001b\u0002|!I\u0011(!\u001e\u0002\u0002\u0003\u0007\u00111\u000e\u0005\t\u0003\u007f\u0002\u0001\u0015)\u0003\u0002l\u0005Y!M]8lKJ\u001cuN\u001c4!\u0011)q\u0007\u00011AA\u0002\u0013%\u00111Q\u000b\u0003\u0003\u000b\u0003B!!\u001c\u0002\b&!\u0011\u0011RA8\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\t\u0017\u00055\u0005\u00011AA\u0002\u0013%\u0011qR\u0001\u000bg\u0016\u0014h/\u001a:`I\u0015\fHcA\u001b\u0002\u0012\"I\u0011(a#\u0002\u0002\u0003\u0007\u0011Q\u0011\u0005\t\u0003+\u0003\u0001\u0015)\u0003\u0002\u0006\u000691/\u001a:wKJ\u0004\u0003bCAM\u0001\u0001\u0007\t\u0019!C\u0005\u00037\u000b\u0001\u0002\u001d:pIV\u001cWM]\u000b\u0003\u0003;\u0003b!a(\u0002$>{UBAAQ\u0015\u0011\tI*!\u000f\n\t\u0005\u0015\u0016\u0011\u0015\u0002\t!J|G-^2fe\"Y\u0011\u0011\u0016\u0001A\u0002\u0003\u0007I\u0011BAV\u00031\u0001(o\u001c3vG\u0016\u0014x\fJ3r)\r)\u0014Q\u0016\u0005\ns\u0005\u001d\u0016\u0011!a\u0001\u0003;C\u0001\"!-\u0001A\u0003&\u0011QT\u0001\naJ|G-^2fe\u0002B\u0011\"!.\u0001\u0001\u0004%I!a.\u0002\u000fi\\'+Z1esV\u0011\u0011\u0011\u0018\t\u0004\u001d\u0005m\u0016bAA_\u001f\t9!i\\8mK\u0006t\u0007\"CAa\u0001\u0001\u0007I\u0011BAb\u0003-Q8NU3bIf|F%Z9\u0015\u0007U\n)\rC\u0005:\u0003\u007f\u000b\t\u00111\u0001\u0002:\"A\u0011\u0011\u001a\u0001!B\u0013\tI,\u0001\u0005{WJ+\u0017\rZ=!\u0011%\ti\r\u0001a\u0001\n\u0013\t9,A\u0006ce>\\WM\u001d*fC\u0012L\b\"CAi\u0001\u0001\u0007I\u0011BAj\u0003=\u0011'o\\6feJ+\u0017\rZ=`I\u0015\fHcA\u001b\u0002V\"I\u0011(a4\u0002\u0002\u0003\u0007\u0011\u0011\u0018\u0005\t\u00033\u0004\u0001\u0015)\u0003\u0002:\u0006a!M]8lKJ\u0014V-\u00193zA!1\u0011Q\u001c\u0001\u0005\u00029\u000b\u0011B_6BI\u0012\u0014Xm]:\t\r\u0005\u0005\b\u0001\"\u0001O\u00035\u0011'o\\6fe\u0006#GM]3tg\"9\u0011Q\u001d\u0001\u0005\u0002\u0005=\u0012a\u0004>p_.,W\r]3s\u00072LWM\u001c;\t\u000f\u0005%\b\u0001\"\u0003\u0002 \u000512/\u001a;va\u0016k'-\u001a3eK\u0012Tvn\\6fKB,'\u000fC\u0004\u0002n\u0002!I!a\b\u00021M,G/\u001e9F[\n,G\rZ3e\u0017\u000647.Y*feZ,'\u000fC\u0004\u0002r\u0002!\t!a\b\u0002\u000bM,G/\u001e9\t\u000f\u0005U\b\u0001\"\u0001\u0002 \u0005AA/Z1sI><h\u000eC\u0004\u0002z\u0002!\t!a?\u0002\u0017\r\u0014X-\u0019;f)>\u0004\u0018n\u0019\u000b\u0006k\u0005u(\u0011\u0001\u0005\b\u0003\u007f\f9\u00101\u0001P\u0003\u0015!x\u000e]5d\u0011\u001d\u0011\u0019!a>A\u0002=\n!\u0002]1si&$\u0018n\u001c8t\u0011\u001d\tI\u0010\u0001C\u0001\u0005\u000f!2!\u000eB\u0005\u0011\u001d\tyP!\u0002A\u0002=CqA!\u0004\u0001\t\u0003\u0011y!\u0001\u0007tK:$W*Z:tC\u001e,7\u000fF\u00036\u0005#\u0011\u0019\u0002C\u0004\u0002\u0000\n-\u0001\u0019A(\t\u0011\tU!1\u0002a\u0001\u0005/\tQ\"\\3tg\u0006<W\rV8Ge\u0016\f\bc\u0002B\r\u0005?y%1E\u0007\u0003\u00057Q1A!\b'\u0003\u0011)H/\u001b7\n\t\t\u0005\"1\u0004\u0002\u0004\u001b\u0006\u0004\bcA\u0012\u0003&%\u0019!q\u0005\u0013\u0003\u000f%sG/Z4fe\"9!Q\u0002\u0001\u0005\u0002\t-B#B\u001b\u0003.\t=\u0002bBA\u0000\u0005S\u0001\ra\u0014\u0005\t\u0005+\u0011I\u00031\u0001\u00032A)\u0001Ka\rP_%\u0019!\u0011\u0005+\t\u000f\t5\u0001\u0001\"\u0001\u00038Q)QG!\u000f\u0003<!9\u0011q B\u001b\u0001\u0004y\u0005\u0002\u0003B\u001f\u0005k\u0001\rAa\u0010\u0002\u00115,7o]1hKN\u0004BA\u0004B!\u001f&\u0019!1I\b\u0003\u000b\u0005\u0013(/Y=\t\u000f\t\u001d\u0003\u0001\"\u0003\u0003J\u0005\u0019\"M]8lKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]V\u0011!1\n\t\u0005\u00053\u0011i%\u0003\u0003\u0003P\tm!A\u0003)s_B,'\u000f^5fg\"9!1\u000b\u0001\u0005\n\t%\u0013!\u00069s_\u0012,8-\u001a:D_:4\u0017nZ;sCRLwN\u001c\u0005\b\u0005/\u0002A\u0011\u0001B-\u0003))g/\u001a8uk\u0006dG._\u000b\u0005\u00057\u0012\u0019\u0007\u0006\u0004\u0003^\t}$1\u0012\u000b\u0005\u0005?\u0012)\b\u0005\u0003\u0003b\t\rD\u0002\u0001\u0003\t\u0005K\u0012)F1\u0001\u0003h\t\tA+\u0005\u0003\u0003j\t=\u0004c\u0001\b\u0003l%\u0019!QN\b\u0003\u000f9{G\u000f[5oOB\u0019aB!\u001d\n\u0007\tMtBA\u0002B]fD\u0011Ba\u001e\u0003V\u0011\u0005\rA!\u001f\u0002\t\u0019,hn\u0019\t\u0006\u001d\tm$qL\u0005\u0004\u0005{z!\u0001\u0003\u001fcs:\fW.\u001a \t\u0011\t\u0005%Q\u000ba\u0001\u0005\u0007\u000bq\u0001^5nK>,H\u000f\u0005\u0003\u0003\u0006\n\u001dU\"\u0001\u0003\n\u0007\t%EA\u0001\u0003US6,\u0007\u0002\u0003BG\u0005+\u0002\rAa!\u0002\u0011%tG/\u001a:wC2DqA!%\u0001\t\u0013\u0011\u0019*A\u000fxC&$XK\u001c;jY6+G/\u00193bi\u0006L5\u000f\u0015:pa\u0006<\u0017\r^3e)\u0015)$Q\u0013BL\u0011\u001d\tyPa$A\u0002=CqA!'\u0003\u0010\u0002\u0007q&A\u0005qCJ$\u0018\u000e^5p]\u0002")
public class KafkaTestUtils
implements Logging {
    private final String zkHost;
    private int zkPort;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private EmbeddedZookeeper zookeeper;
    private ZkUtils zkUtils;
    private final String brokerHost;
    private int org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerPort;
    private KafkaConfig org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerConf;
    private KafkaServer org$apache$spark$streaming$kafka010$KafkaTestUtils$$server;
    private Producer<String, String> producer;
    private boolean zkReady;
    private boolean brokerReady;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    private String zkHost() {
        return this.zkHost;
    }

    private int zkPort() {
        return this.zkPort;
    }

    private void zkPort_$eq(int x$1) {
        this.zkPort = x$1;
    }

    private int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    private int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    private EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    private void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    private ZkUtils zkUtils() {
        return this.zkUtils;
    }

    private void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    private String brokerHost() {
        return this.brokerHost;
    }

    public int org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerPort() {
        return this.org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerPort;
    }

    public void org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerPort_$eq(int x$1) {
        this.org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerPort = x$1;
    }

    public KafkaConfig org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerConf() {
        return this.org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerConf;
    }

    public void org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerConf_$eq(KafkaConfig x$1) {
        this.org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerConf = x$1;
    }

    public KafkaServer org$apache$spark$streaming$kafka010$KafkaTestUtils$$server() {
        return this.org$apache$spark$streaming$kafka010$KafkaTestUtils$$server;
    }

    public void org$apache$spark$streaming$kafka010$KafkaTestUtils$$server_$eq(KafkaServer x$1) {
        this.org$apache$spark$streaming$kafka010$KafkaTestUtils$$server = x$1;
    }

    private Producer<String, String> producer() {
        return this.producer;
    }

    private void producer_$eq(Producer<String, String> x$1) {
        this.producer = x$1;
    }

    private boolean zkReady() {
        return this.zkReady;
    }

    private void zkReady_$eq(boolean x$1) {
        this.zkReady = x$1;
    }

    private boolean brokerReady() {
        return this.brokerReady;
    }

    private void brokerReady_$eq(boolean x$1) {
        this.brokerReady = x$1;
    }

    public String zkAddress() {
        Predef$.MODULE$.assert(this.zkReady(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Zookeeper not setup yet or already torn down, cannot get zookeeper address";
            }
        });
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkHost(), BoxesRunTime.boxToInteger((int)this.zkPort())}));
    }

    public String brokerAddress() {
        Predef$.MODULE$.assert(this.brokerReady(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Kafka not setup yet or already torn down, cannot get broker address";
            }
        });
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.brokerHost(), BoxesRunTime.boxToInteger((int)this.org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerPort())}));
    }

    public ZkUtils zookeeperClient() {
        Predef$.MODULE$.assert(this.zkReady(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Zookeeper not setup yet or already torn down, cannot get zookeeper client";
            }
        });
        return (ZkUtils)Option$.MODULE$.apply((Object)this.zkUtils()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalStateException("Zookeeper client is not yet initialized");
            }
        });
    }

    private void setupEmbeddedZookeeper() {
        this.zookeeper_$eq(new EmbeddedZookeeper(this, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkHost(), BoxesRunTime.boxToInteger((int)this.zkPort())}))));
        this.zkPort_$eq(this.zookeeper().actualPort());
        this.zkUtils_$eq(ZkUtils$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkHost(), BoxesRunTime.boxToInteger((int)this.zkPort())})), this.zkSessionTimeout(), this.zkConnectionTimeout(), false));
        this.zkReady_$eq(true);
    }

    private void setupEmbeddedKafkaServer() {
        Predef$.MODULE$.assert(this.zkReady(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Zookeeper should be set up beforehand";
            }
        });
        Utils$.MODULE$.startServiceOnPort(this.org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerPort(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaTestUtils $outer;

            public final Tuple2<KafkaServer, Object> apply(int port) {
                this.$outer.org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerPort_$eq(port);
                this.$outer.org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerConf_$eq(new KafkaConfig((Map)this.$outer.org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerConfiguration(), false));
                this.$outer.org$apache$spark$streaming$kafka010$KafkaTestUtils$$server_$eq(new KafkaServer(this.$outer.org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerConf(), KafkaServer$.MODULE$.$lessinit$greater$default$2(), KafkaServer$.MODULE$.$lessinit$greater$default$3()));
                this.$outer.org$apache$spark$streaming$kafka010$KafkaTestUtils$$server().startup();
                KafkaServer qual$1 = this.$outer.org$apache$spark$streaming$kafka010$KafkaTestUtils$$server();
                SecurityProtocol x$4 = qual$1.boundPort$default$1();
                this.$outer.org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerPort_$eq(qual$1.boundPort(x$4));
                return new Tuple2((Object)this.$outer.org$apache$spark$streaming$kafka010$KafkaTestUtils$$server(), (Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerPort()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new SparkConf(), "KafkaBroker");
        this.brokerReady_$eq(true);
    }

    public void setup() {
        this.setupEmbeddedZookeeper();
        this.setupEmbeddedKafkaServer();
    }

    public void teardown() {
        this.brokerReady_$eq(false);
        this.zkReady_$eq(false);
        if (this.producer() != null) {
            this.producer().close();
            this.producer_$eq(null);
        }
        if (this.org$apache$spark$streaming$kafka010$KafkaTestUtils$$server() != null) {
            this.org$apache$spark$streaming$kafka010$KafkaTestUtils$$server().shutdown();
            this.org$apache$spark$streaming$kafka010$KafkaTestUtils$$server_$eq(null);
        }
        this.org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerConf().logDirs().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String f) {
                Utils$.MODULE$.deleteRecursively(new File(f));
            }
        });
        if (this.zkUtils() != null) {
            this.zkUtils().close();
            this.zkUtils_$eq(null);
        }
        if (this.zookeeper() != null) {
            this.zookeeper().shutdown();
            this.zookeeper_$eq(null);
        }
    }

    public void createTopic(String topic, int partitions) {
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), topic, partitions, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitions).foreach$mVc$sp((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaTestUtils $outer;
            private final String topic$1;

            public final void apply(int p) {
                this.apply$mcVI$sp(p);
            }

            public void apply$mcVI$sp(int p) {
                this.$outer.org$apache$spark$streaming$kafka010$KafkaTestUtils$$waitUntilMetadataIsPropagated(this.topic$1, p);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
            }
        });
    }

    public void createTopic(String topic) {
        this.createTopic(topic, 1);
    }

    public void sendMessages(String topic, Map<String, Integer> messageToFreq) {
        this.sendMessages(topic, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(messageToFreq).asScala()).mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Integer x$1) {
                return x$1;
            }
        }).toSeq())));
    }

    public void sendMessages(String topic, scala.collection.immutable.Map<String, Object> messageToFreq) {
        String[] messages = (String[])((TraversableOnce)messageToFreq.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String s = (String)tuple2._1();
                    int freq = tuple2._2$mcI$sp();
                    Seq seq = (Seq)Seq$.MODULE$.fill(freq, (Function0)new Serializable(this, s){
                        public static final long serialVersionUID = 0L;
                        private final String s$1;

                        public final String apply() {
                            return this.s$1;
                        }
                        {
                            this.s$1 = s$1;
                        }
                    });
                    return seq;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        this.sendMessages(topic, messages);
    }

    public void sendMessages(String topic, String[] messages) {
        this.producer_$eq((Producer<String, String>)new Producer(new ProducerConfig(this.producerConfiguration())));
        this.producer().send((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])messages).map((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$3;

            public final KeyedMessage<String, String> apply(String x$2) {
                return new KeyedMessage(this.topic$3, (Object)x$2);
            }
            {
                this.topic$3 = topic$3;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(KeyedMessage.class)))));
        this.producer().close();
        this.producer_$eq(null);
    }

    /*
     * WARNING - void declaration
     */
    public Properties org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerConfiguration() {
        void var1_1;
        Properties props = new Properties();
        props.put("broker.id", "0");
        props.put("host.name", "localhost");
        props.put("port", ((Object)BoxesRunTime.boxToInteger((int)this.org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerPort())).toString());
        props.put("log.dir", Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getAbsolutePath());
        props.put("zookeeper.connect", this.zkAddress());
        props.put("log.flush.interval.messages", "1");
        props.put("replica.socket.timeout.ms", "1500");
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Properties producerConfiguration() {
        void var1_1;
        Properties props = new Properties();
        props.put("metadata.broker.list", this.brokerAddress());
        props.put("serializer.class", StringEncoder.class.getName());
        props.put("request.required.acks", "-1");
        return var1_1;
    }

    public <T> T eventually(Time timeout, Time interval, Function0<T> func) {
        long startTime = System.currentTimeMillis();
        return (T)this.tryAgain$1(1, timeout, interval, func, startTime);
    }

    public void org$apache$spark$streaming$kafka010$KafkaTestUtils$$waitUntilMetadataIsPropagated(String topic, int partition) {
        this.eventually(new Time(10000L), new Time(100L), (Function0)new Serializable(this, topic, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaTestUtils $outer;
            public final String topic$2;
            public final int partition$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Predef$.MODULE$.assert(this.$outer.org$apache$spark$streaming$kafka010$KafkaTestUtils$$isPropagated$1(this.topic$2, this.partition$1), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$org$apache$spark$streaming$kafka010$KafkaTestUtils$$waitUntilMetadataIsPropagated$1 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition [", ", ", "] metadata not propagated after timeout"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic$2, BoxesRunTime.boxToInteger((int)this.$outer.partition$1)}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$2 = topic$2;
                this.partition$1 = partition$1;
            }
        });
    }

    private final Either makeAttempt$1(Function0 func$1) {
        Throwable throwable2;
        block2: {
            Right right;
            try {
                right = package$.MODULE$.Right().apply(func$1.apply());
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                if (!NonFatal$.MODULE$.apply(throwable3)) break block2;
                Left left = package$.MODULE$.Left().apply((Object)throwable3);
                right = left;
            }
            return right;
        }
        throw throwable2;
    }

    private final Object tryAgain$1(int attempt, Time timeout$1, Time interval$1, Function0 func$1, long startTime$1) {
        Either either;
        block2: {
            Throwable e;
            while (true) {
                if ((either = this.makeAttempt$1(func$1)) instanceof Right) {
                    Object result;
                    Right right = (Right)either;
                    Object object = result = right.b();
                    return object;
                }
                if (!(either instanceof Left)) break block2;
                Left left = (Left)either;
                e = (Throwable)left.a();
                long duration = System.currentTimeMillis() - startTime$1;
                if (duration >= timeout$1.milliseconds()) break;
                Thread.sleep(interval$1.milliseconds());
                ++attempt;
            }
            throw new TimeoutException(e.getMessage());
        }
        throw new MatchError((Object)either);
    }

    public final boolean org$apache$spark$streaming$kafka010$KafkaTestUtils$$isPropagated$1(String topic$2, int partition$1) {
        boolean bl;
        Option option = this.org$apache$spark$streaming$kafka010$KafkaTestUtils$$server().apis().metadataCache().getPartitionInfo(topic$2, partition$1);
        if (option instanceof Some) {
            Some some = (Some)option;
            PartitionStateInfo partitionState = (PartitionStateInfo)some.x();
            LeaderAndIsr leaderAndInSyncReplicas = partitionState.leaderIsrAndControllerEpoch().leaderAndIsr();
            bl = this.zkUtils().getLeaderForPartition(topic$2, partition$1).isDefined() && Request$.MODULE$.isValidBrokerId(leaderAndInSyncReplicas.leader()) && leaderAndInSyncReplicas.isr().size() >= 1;
        } else {
            bl = false;
        }
        return bl;
    }

    public KafkaTestUtils() {
        Logging.class.$init$((Logging)this);
        this.zkHost = "localhost";
        this.zkPort = 0;
        this.zkConnectionTimeout = 60000;
        this.zkSessionTimeout = 6000;
        this.brokerHost = "localhost";
        this.org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerPort = 0;
        this.zkReady = false;
        this.brokerReady = false;
    }

    public class EmbeddedZookeeper {
        private final String zkConnect;
        private final File snapshotDir;
        private final File logDir;
        private final ZooKeeperServer zookeeper;
        private final /* synthetic */ Tuple2 x$3;
        private final String ip;
        private final int port;
        private final NIOServerCnxnFactory factory;
        private final int actualPort;
        public final /* synthetic */ KafkaTestUtils $outer;

        public String zkConnect() {
            return this.zkConnect;
        }

        public File snapshotDir() {
            return this.snapshotDir;
        }

        public File logDir() {
            return this.logDir;
        }

        public ZooKeeperServer zookeeper() {
            return this.zookeeper;
        }

        public String ip() {
            return this.ip;
        }

        public int port() {
            return this.port;
        }

        public NIOServerCnxnFactory factory() {
            return this.factory;
        }

        public int actualPort() {
            return this.actualPort;
        }

        public void shutdown() {
            this.factory().shutdown();
            Utils$.MODULE$.deleteRecursively(this.snapshotDir());
            Utils$.MODULE$.deleteRecursively(this.logDir());
        }

        public /* synthetic */ KafkaTestUtils org$apache$spark$streaming$kafka010$KafkaTestUtils$EmbeddedZookeeper$$$outer() {
            return this.$outer;
        }

        public EmbeddedZookeeper(KafkaTestUtils $outer, String zkConnect) {
            this.zkConnect = zkConnect;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.snapshotDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            this.logDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            this.zookeeper = new ZooKeeperServer(this.snapshotDir(), this.logDir(), 500);
            String[] splits = zkConnect.split(":");
            Tuple2 tuple2 = new Tuple2((Object)splits[0], (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(splits[1])).toInt()));
            if (tuple2 != null) {
                Tuple2 tuple22;
                String ip = (String)tuple2._1();
                int port = tuple2._2$mcI$sp();
                this.x$3 = tuple22 = new Tuple2((Object)ip, (Object)BoxesRunTime.boxToInteger((int)port));
                this.ip = (String)this.x$3._1();
                this.port = this.x$3._2$mcI$sp();
                this.factory = new NIOServerCnxnFactory();
                this.factory().configure(new InetSocketAddress(this.ip(), this.port()), 16);
                this.factory().startup(this.zookeeper());
                this.actualPort = this.factory().getLocalPort();
                return;
            }
            throw new MatchError((Object)tuple2);
        }
    }
}

