/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.redis.bolt;

import org.apache.storm.redis.bolt.AbstractRedisBolt;
import org.apache.storm.redis.common.config.JedisClusterConfig;
import org.apache.storm.redis.common.config.JedisPoolConfig;
import org.apache.storm.redis.common.mapper.RedisDataTypeDescription;
import org.apache.storm.redis.common.mapper.RedisStoreMapper;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.tuple.ITuple;
import org.apache.storm.tuple.Tuple;
import redis.clients.jedis.JedisCommands;

public class RedisStoreBolt
extends AbstractRedisBolt {
    private final RedisStoreMapper storeMapper;
    private final RedisDataTypeDescription.RedisDataType dataType;
    private final String additionalKey;

    public RedisStoreBolt(JedisPoolConfig config, RedisStoreMapper storeMapper) {
        super(config);
        this.storeMapper = storeMapper;
        RedisDataTypeDescription dataTypeDescription = storeMapper.getDataTypeDescription();
        this.dataType = dataTypeDescription.getDataType();
        this.additionalKey = dataTypeDescription.getAdditionalKey();
    }

    public RedisStoreBolt(JedisClusterConfig config, RedisStoreMapper storeMapper) {
        super(config);
        this.storeMapper = storeMapper;
        RedisDataTypeDescription dataTypeDescription = storeMapper.getDataTypeDescription();
        this.dataType = dataTypeDescription.getDataType();
        this.additionalKey = dataTypeDescription.getAdditionalKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Tuple input) {
        String key = this.storeMapper.getKeyFromTuple((ITuple)input);
        String value = this.storeMapper.getValueFromTuple((ITuple)input);
        JedisCommands jedisCommand = null;
        try {
            jedisCommand = this.getInstance();
            switch (this.dataType) {
                case STRING: {
                    jedisCommand.set(key, value);
                    break;
                }
                case LIST: {
                    jedisCommand.rpush(key, new String[]{value});
                    break;
                }
                case HASH: {
                    jedisCommand.hset(this.additionalKey, key, value);
                    break;
                }
                case SET: {
                    jedisCommand.sadd(key, new String[]{value});
                    break;
                }
                case SORTED_SET: {
                    jedisCommand.zadd(this.additionalKey, Double.valueOf(value).doubleValue(), key);
                    break;
                }
                case HYPER_LOG_LOG: {
                    jedisCommand.pfadd(key, new String[]{value});
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Cannot process such data type: " + (Object)((Object)this.dataType));
                }
            }
            this.collector.ack(input);
        }
        catch (Exception e) {
            this.collector.reportError((Throwable)e);
            this.collector.fail(input);
        }
        finally {
            this.returnInstance(jedisCommand);
        }
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
    }
}

