/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attribute
implements Serializable {
    public static final String DEFINITION = "definition";
    public static final String TEMPLATE = "template";
    public static final String STRING = "string";
    protected String role = null;
    protected Object value = null;
    private String type = null;
    private String name = null;
    private Map<String, Attribute> attributes;

    public Attribute() {
    }

    public Attribute(Object value) {
        this.value = value;
    }

    public Attribute(Attribute attribute) {
        this.name = attribute.name;
        this.role = attribute.role;
        this.type = attribute.type;
        this.value = attribute.getValue();
        if (attribute.attributes != null) {
            this.attributes = new HashMap<String, Attribute>();
            for (Map.Entry<String, Attribute> entry : attribute.attributes.entrySet()) {
                this.attributes.put(entry.getKey(), new Attribute(entry.getValue()));
            }
        }
    }

    public Attribute(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public Attribute(Object value, String role) {
        this.value = value;
        this.role = role;
    }

    public Attribute(Object value, String role, String type) {
        this.value = value;
        this.role = role;
        this.type = type;
    }

    public Attribute(String name, Object value, String role, String type) {
        this.name = name;
        this.value = value;
        this.role = role;
        this.type = type;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String toString() {
        if (this.value != null) {
            return this.value.toString();
        }
        return null;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, Attribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Attribute> attributes) {
        this.attributes = attributes;
    }

    public void setBody(String body) {
        if (body != null && body.length() != 0) {
            this.setValue(body);
        }
    }
}

