/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.mkldnn.presets;

import java.util.List;
import org.bytedeco.javacpp.ClassProperties;
import org.bytedeco.javacpp.LoadEnabled;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.annotation.NoException;
import org.bytedeco.javacpp.annotation.Platform;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.tools.Info;
import org.bytedeco.javacpp.tools.InfoMap;
import org.bytedeco.javacpp.tools.InfoMapper;

@Properties(value={@Platform(value={"linux-x86_64", "macosx-x86_64", "windows-x86_64"}, include={"mkl.h", "mkl_version.h", "mkl_types.h", "mkl_trans.h", "mkl_cblas.h", "mkl_dnn_types.h", "mkl_dnn.h"}, link={"mklml_intel"}, preload={"gomp@.1", "iomp5"}, resource={"include", "lib"}, preloadpath={"/opt/intel/lib/intel64/", "/opt/intel/mkl/lib/intel64/"}), @Platform(value={"macosx-x86_64"}, link={"mklml"}, preload={"gcc_s@.1", "gomp@.1", "stdc++@.6", "iomp5"}, preloadpath={"/usr/local/lib/gcc/8/", "/usr/local/lib/gcc/7/", "/usr/local/lib/gcc/6/", "/usr/local/lib/gcc/5/", "/opt/intel/lib/", "/opt/intel/mkl/lib/"}), @Platform(value={"windows-x86_64"}, link={"mklml"}, preload={"libwinpthread-1", "libgcc_s_seh-1", "libgomp-1", "libstdc++-6", "msvcr120", "libiomp5md"}, preloadpath={"C:/Program Files (x86)/IntelSWTools/compilers_and_libraries/windows/redist/intel64/compiler/", "C:/Program Files (x86)/IntelSWTools/compilers_and_libraries/windows/redist/intel64/mkl/"})}, global="org.bytedeco.mkldnn.global.mklml")
@NoException
public class mklml
implements LoadEnabled,
InfoMapper {
    public void init(ClassProperties properties) {
        String platform = properties.getProperty("platform");
        List preloads = properties.get("platform.preload");
        List resources = properties.get("platform.preloadresource");
        if (!Loader.isLoadLibraries()) {
            return;
        }
        String lib = System.getProperty("org.bytedeco.mklml.load", "").toLowerCase();
        int i = 0;
        if (lib.equals("mkl") || lib.equals("mkl_rt")) {
            String[] libs = new String[]{"iomp5", "libiomp5md", "mkl_core", "mkl_avx", "mkl_avx2", "mkl_avx512", "mkl_avx512_mic", "mkl_def", "mkl_mc", "mkl_mc3", "mkl_intel_lp64", "mkl_intel_thread", "mkl_rt"};
            for (i = 0; i < libs.length; ++i) {
                preloads.add(i, libs[i] + "#" + libs[i]);
            }
            lib = "mkl_rt";
            resources.add("/org/bytedeco/mkl/");
        }
        if (lib.length() > 0) {
            if (platform.startsWith("linux")) {
                preloads.add(i, lib + "#mklml_intel");
            } else if (platform.startsWith("macosx")) {
                preloads.add(i, lib + "#mklml");
            } else if (platform.startsWith("windows")) {
                preloads.add(i, lib + "#mklml");
            }
        }
    }

    public void map(InfoMap infoMap) {
        infoMap.put(new Info(new String[]{"MKL_INT64", "MKL_UINT64", "MKL_INT", "MKL_UINT", "MKL_LONG", "MKL_UINT8", "MKL_INT8", "MKL_INT16", "MKL_INT32", "MKL_DECLSPEC", "MKL_CALL_CONV", "INTEL_API_DEF", "mkl_simatcopy", "mkl_dimatcopy", "mkl_cimatcopy", "mkl_zimatcopy", "mkl_somatcopy", "mkl_domatcopy", "mkl_comatcopy", "mkl_zomatcopy", "mkl_somatcopy2", "mkl_domatcopy2", "mkl_comatcopy2", "mkl_zomatcopy2", "mkl_somatadd", "mkl_domatadd", "mkl_comatadd", "mkl_zomatadd", "CBLAS_INDEX", "mkl_jit_create_dgemm", "mkl_jit_create_sgemm", "mkl_jit_create_cgemm", "mkl_jit_create_zgemm"}).cppTypes(new String[0]).annotations(new String[0])).put(new Info(new String[]{"MKL_DEPRECATED"}).cppText("#define MKL_DEPRECATED deprecated").cppTypes(new String[0])).put(new Info(new String[]{"MKL_DEPRECATED_C"}).cppText("#define MKL_DEPRECATED_C deprecated").cppTypes(new String[0])).put(new Info(new String[]{"deprecated"}).annotations(new String[]{"@Deprecated"})).put(new Info(new String[]{"MKL_CBWR_UNSET_ALL"}).translate(false)).put(new Info(new String[]{"MKL_Simatcopy", "MKL_Dimatcopy", "MKL_Cimatcopy", "MKL_Zimatcopy", "MKL_Somatcopy2", "MKL_Domatcopy2", "MKL_Comatcopy2", "MKL_Zomatcopy2", "MKL_Somatadd", "MKL_Domatadd", "MKL_Comatadd", "MKL_Zomatadd", "cblas_ctrsm_batch", "cblas_dtrsm_batch", "cblas_strsm_batch", "cblas_ztrsm_batch", "cblas_sgemm_pack_get_size", "cblas_dgemm_pack_get_size", "cblas_gemm_s8u8s32_pack_get_size", "cblas_gemm_s8u8s32_pack", "cblas_gemm_s8u8s32_compute", "cblas_gemm_s16s16s32_pack_get_size", "cblas_gemm_s16s16s32_pack", "cblas_gemm_s16s16s32_compute", "mkl_cblas_jit_create_dgemm", "mkl_cblas_jit_create_sgemm", "mkl_cblas_jit_create_cgemm", "mkl_cblas_jit_create_zgemm", "mkl_jit_get_dgemm_ptr", "mkl_jit_get_sgemm_ptr", "mkl_jit_get_cgemm_ptr", "mkl_jit_get_zgemm_ptr", "mkl_jit_destroy"}).skip()).put(new Info(new String[]{"dnnPrimitive_t"}).valueTypes(new String[]{"_uniPrimitive_s"}).pointerTypes(new String[]{"@ByPtrPtr _uniPrimitive_s"})).put(new Info(new String[]{"dnnLayout_t"}).valueTypes(new String[]{"_dnnLayout_s"}).pointerTypes(new String[]{"@ByPtrPtr _dnnLayout_s"}));
    }
}

