/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.supports.boot.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.commons.dbcp2.managed.BasicManagedDataSource;
import org.apache.commons.lang3.StringUtils;
import org.bytesoft.bytejta.supports.resource.ManagedConnectionFactoryHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertyNameAliases;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;

public class DataSourceCciBuilder<T extends DataSource> {
    static final Logger logger = LoggerFactory.getLogger(DataSourceCciBuilder.class);
    private XADataSource xaDataSourceInstance;
    private final Map<String, String> properties = new HashMap<String, String>();

    private DataSourceCciBuilder(XADataSource xaDataSourceInstance) {
        if (xaDataSourceInstance == null) {
            throw new IllegalArgumentException("the xaDataSourceInstance cannot be null!");
        }
        this.xaDataSourceInstance = xaDataSourceInstance;
    }

    public static DataSourceCciBuilder<?> create(XADataSource xaDataSourceInstance) {
        return new DataSourceCciBuilder(xaDataSourceInstance);
    }

    public DataSource build() {
        this.validateXADataSourceInstance();
        BasicManagedDataSource dataSource = (BasicManagedDataSource)BeanUtils.instantiateClass(BasicManagedDataSource.class);
        this.bind((DataSource)dataSource);
        dataSource.setXaDataSourceInstance(this.xaDataSourceInstance);
        return dataSource;
    }

    private void validateXADataSourceInstance() {
        ManagedConnectionFactoryHandler mcfh;
        InvocationHandler handler = Proxy.isProxyClass(this.xaDataSourceInstance.getClass()) ? Proxy.getInvocationHandler(this.xaDataSourceInstance) : null;
        ManagedConnectionFactoryHandler managedConnectionFactoryHandler = mcfh = handler == null || !ManagedConnectionFactoryHandler.class.isInstance(handler) ? null : (ManagedConnectionFactoryHandler)handler;
        if (!BeanNameAware.class.isInstance(this.xaDataSourceInstance) && (mcfh == null || StringUtils.isBlank((CharSequence)mcfh.getIdentifier()))) {
            throw new IllegalStateException("XADataSource is not properly configured!");
        }
    }

    private void bind(DataSource dataSource) {
        MapConfigurationPropertySource source = new MapConfigurationPropertySource(this.properties);
        ConfigurationPropertyNameAliases aliases = new ConfigurationPropertyNameAliases();
        Binder binder = new Binder(new ConfigurationPropertySource[]{source.withAliases(aliases)});
        binder.bind(ConfigurationPropertyName.EMPTY, Bindable.ofInstance((Object)dataSource));
    }
}

