/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.supports.boot.jdbc;

import java.util.HashMap;
import java.util.Map;
import javax.sql.XADataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertyNameAliases;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.util.ClassUtils;

public class DataSourceSpiBuilder<T extends XADataSource> {
    private static final String[] XA_DATA_SOURCE_TYPE_NAMES = new String[]{"com.mysql.jdbc.jdbc2.optional.MysqlXADataSource", "org.postgresql.xa.PGXADataSource", "oracle.jdbc.xa.client.OracleXADataSource"};
    static final Logger logger = LoggerFactory.getLogger(DataSourceSpiBuilder.class);
    private Class<? extends XADataSource> type;
    private final Map<String, String> properties = new HashMap<String, String>();
    private ClassLoader classLoader;

    private DataSourceSpiBuilder(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static DataSourceSpiBuilder<?> create() {
        return new DataSourceSpiBuilder(null);
    }

    public static DataSourceSpiBuilder<?> create(ClassLoader classLoader) {
        return new DataSourceSpiBuilder(classLoader);
    }

    public XADataSource build() {
        Class<XADataSource> type = this.getType();
        XADataSource xaDataSourceInstance = (XADataSource)BeanUtils.instantiate(type);
        this.bind(xaDataSourceInstance);
        return xaDataSourceInstance;
    }

    private void bind(XADataSource result) {
        MapConfigurationPropertySource source = new MapConfigurationPropertySource(this.properties);
        ConfigurationPropertyNameAliases aliases = new ConfigurationPropertyNameAliases();
        aliases.addAliases("url", new String[]{"jdbc-url"});
        aliases.addAliases("username", new String[]{"user"});
        Binder binder = new Binder(new ConfigurationPropertySource[]{source.withAliases(aliases)});
        binder.bind(ConfigurationPropertyName.EMPTY, Bindable.ofInstance((Object)result));
    }

    public DataSourceSpiBuilder<?> type(Class<? extends XADataSource> type) {
        this.type = type;
        return this;
    }

    public DataSourceSpiBuilder<?> url(String url) {
        this.properties.put("url", url);
        return this;
    }

    public DataSourceSpiBuilder<?> username(String username) {
        this.properties.put("username", username);
        return this;
    }

    public DataSourceSpiBuilder<?> password(String password) {
        this.properties.put("password", password);
        return this;
    }

    private Class<? extends XADataSource> getType() {
        Class<? extends XADataSource> type;
        Class<? extends XADataSource> clazz = type = this.type != null ? this.type : DataSourceSpiBuilder.findType(this.classLoader);
        if (type != null) {
            return type;
        }
        throw new IllegalStateException("No supported XADataSource type found");
    }

    public static Class<? extends XADataSource> findType(ClassLoader classLoader) {
        for (String name : XA_DATA_SOURCE_TYPE_NAMES) {
            try {
                return ClassUtils.forName((String)name, (ClassLoader)classLoader);
            }
            catch (Exception error) {
                logger.debug("Error occurred while loading class: {}!", (Object)name, (Object)error);
            }
        }
        return null;
    }
}

