/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.supports.internal;

import java.util.concurrent.Callable;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Resource;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkManager;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.leader.LeaderSelector;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListener;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.bytesoft.common.utils.CommonUtils;
import org.bytesoft.transaction.aware.TransactionEndpointAware;
import org.bytesoft.transaction.cmd.CommandDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;

public class TransactionCommandDispatcher
implements SmartInitializingSingleton,
TransactionEndpointAware,
LeaderSelectorListener,
CommandDispatcher {
    static final Logger logger = LoggerFactory.getLogger(TransactionCommandDispatcher.class);
    @Resource
    private CuratorFramework curatorFramework;
    private Lock stateLock = new ReentrantLock();
    private Condition stateCondition = this.stateLock.newCondition();
    private volatile Boolean stateDisallowed;
    private volatile boolean permsDisallowed;
    private String endpoint;
    private LeaderSelector leadSelector;
    @Resource
    private WorkManager workManager;
    private String workDirectory = "/org/bytesoft/bytejta";

    public void dispatch(Runnable runnable) throws Exception {
        if (!this.hasLeadership()) {
            throw new SecurityException("Current node is not the master!");
        }
        this.checkExecutionPermission();
        WorkImpl work = new WorkImpl(runnable);
        this.workManager.startWork((Work)work);
    }

    public Object dispatch(Callable<Object> callable) throws Exception {
        if (!this.hasLeadership()) {
            throw new SecurityException("Current node is not the master!");
        }
        this.checkExecutionPermission();
        WorkImpl work = new WorkImpl(callable);
        this.workManager.startWork((Work)work);
        return work.waitForResultIfNecessary();
    }

    private void checkExecutionPermission() {
        if (this.stateDisallowed != null && this.stateDisallowed.booleanValue()) {
            throw new SecurityException("Current state is no longer connected!");
        }
        if (this.permsDisallowed) {
            throw new SecurityException("Current node is no longer the master!");
        }
    }

    public void takeLeadership(CuratorFramework client) throws Exception {
        try {
            this.stateLock.lock();
            this.permsDisallowed = false;
            if (this.stateDisallowed != null && this.stateDisallowed.booleanValue()) {
                logger.warn("Wrong state! Re-elect the master node.");
            } else {
                this.stateCondition.awaitUninterruptibly();
            }
        }
        finally {
            this.permsDisallowed = true;
            this.stateLock.unlock();
        }
    }

    public boolean hasLeadership() {
        if (this.leadSelector == null) {
            return false;
        }
        return this.leadSelector.hasLeadership();
    }

    public void stateChanged(CuratorFramework client, ConnectionState newState) {
        try {
            this.stateLock.lock();
            this.stateDisallowed = !ConnectionState.CONNECTED.equals((Object)newState) && !ConnectionState.RECONNECTED.equals((Object)newState);
            if (this.stateDisallowed.booleanValue()) {
                this.stateCondition.signalAll();
            }
        }
        finally {
            this.stateLock.unlock();
        }
    }

    public void afterSingletonsInstantiated() {
        String basePath = String.format("%s/%s", this.workDirectory, this.getApplication());
        try {
            this.createPersistentPathIfNecessary(basePath);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        String masterPath = String.format("%s/master", basePath);
        this.leadSelector = new LeaderSelector(this.curatorFramework, masterPath, (LeaderSelectorListener)this);
        this.leadSelector.autoRequeue();
        this.leadSelector.start();
    }

    private void createPersistentPathIfNecessary(String path) throws Exception {
        try {
            ((ACLBackgroundPathAndBytesable)this.curatorFramework.create().creatingParentContainersIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(path);
        }
        catch (KeeperException.NodeExistsException nex) {
            logger.debug("Path exists(path= {})!", (Object)path);
        }
    }

    public String getWorkDirectory() {
        return this.workDirectory;
    }

    public void setWorkDirectory(String workDirectory) {
        this.workDirectory = workDirectory;
    }

    public CuratorFramework getCuratorFramework() {
        return this.curatorFramework;
    }

    public void setCuratorFramework(CuratorFramework curatorFramework) {
        this.curatorFramework = curatorFramework;
    }

    private String getApplication() {
        return CommonUtils.getApplication((String)this.endpoint);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String identifier) {
        this.endpoint = identifier;
    }

    class WorkImpl
    implements Work {
        private final Lock lock = new ReentrantLock();
        private final Condition condition = this.lock.newCondition();
        private final Callable<Object> callable;
        private final Runnable runnable;
        private Object result;
        private Boolean error;

        public WorkImpl(Callable<Object> callable) {
            this.runnable = null;
            this.callable = callable;
        }

        public WorkImpl(Runnable runnable) {
            this.callable = null;
            this.runnable = runnable;
        }

        public Object waitForResultIfNecessary() throws Exception {
            if (this.callable == null) {
                return null;
            }
            return this.waitForResult();
        }

        public Object waitForResult() throws Exception {
            try {
                this.lock.lock();
                if (this.error == null) {
                    this.condition.awaitUninterruptibly();
                }
                if (!this.error.booleanValue()) {
                    Object object = this.result;
                    return object;
                }
                if (Exception.class.isInstance(this.result)) {
                    throw (Exception)this.result;
                }
                throw new RuntimeException((Throwable)this.result);
            }
            finally {
                this.lock.unlock();
            }
        }

        public void run() {
            if (this.callable != null) {
                this.executeCallable();
            } else if (this.runnable != null) {
                this.executeRunnable();
            }
        }

        private void executeCallable() {
            try {
                this.lock.lock();
                TransactionCommandDispatcher.this.checkExecutionPermission();
                this.result = this.callable.call();
                this.error = false;
                this.condition.signalAll();
            }
            catch (Exception error) {
                this.result = error;
                this.error = true;
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        private void executeRunnable() {
            try {
                this.runnable.run();
            }
            catch (Exception ex) {
                logger.error("Error occurred while executing task(task= {}).", (Object)this.runnable);
            }
        }

        public void release() {
        }

        public Object getResult() {
            return this.result;
        }

        public void setResult(Object result) {
            this.result = result;
        }

        public Boolean getError() {
            return this.error;
        }

        public void setError(Boolean error) {
            this.error = error;
        }
    }
}

