/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.supports.resource;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.jms.XASession;
import javax.transaction.xa.XAResource;
import org.bytesoft.bytejta.supports.resource.CommonResourceDescriptor;
import org.bytesoft.transaction.supports.resource.XAResourceDescriptor;

public class ManagedXASessionHandler
implements InvocationHandler {
    private final Object delegate;
    private String identifier;

    public ManagedXASessionHandler(Object managed) {
        this.delegate = managed;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> declaringClass = method.getDeclaringClass();
        Class<?> returningClass = method.getReturnType();
        Object resultObject = null;
        try {
            resultObject = method.invoke(this.delegate, args);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        if (resultObject != null && XAResourceDescriptor.class.isInstance(resultObject)) {
            return resultObject;
        }
        CommonResourceDescriptor descriptor = new CommonResourceDescriptor();
        descriptor.setIdentifier(this.identifier);
        if (XASession.class.equals(declaringClass) && XAResource.class.equals(returningClass)) {
            descriptor.setDelegate((XAResource)resultObject);
        }
        return descriptor.getDelegate() != null ? descriptor : resultObject;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }
}

