/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.supports.resource.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.bytesoft.bytejta.TransactionBeanFactoryImpl;
import org.bytesoft.bytejta.supports.resource.jdbc.CallableStatementImpl;
import org.bytesoft.bytejta.supports.resource.jdbc.DatabaseMetaDataImpl;
import org.bytesoft.bytejta.supports.resource.jdbc.PreparedStatementImpl;
import org.bytesoft.bytejta.supports.resource.jdbc.StatementImpl;
import org.bytesoft.bytejta.supports.resource.jdbc.XAConnectionImpl;
import org.bytesoft.transaction.Transaction;
import org.bytesoft.transaction.TransactionManager;

public class ConnectionImpl
implements Connection {
    private Connection delegate;
    private XAConnectionImpl managedConnection;

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.delegate.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.delegate.isWrapperFor(iface);
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkTransactionStatusIfNecessary();
        StatementImpl statement = new StatementImpl();
        statement.setConnection(this);
        statement.setDelegate(this.delegate.createStatement());
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkTransactionStatusIfNecessary();
        PreparedStatementImpl statement = new PreparedStatementImpl();
        statement.setConnection(this);
        statement.setDelegate(this.delegate.prepareStatement(sql));
        return statement;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkTransactionStatusIfNecessary();
        CallableStatementImpl statement = new CallableStatementImpl();
        statement.setConnection(this);
        statement.setDelegate(this.delegate.prepareCall(sql));
        return statement;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.delegate.nativeSQL(sql);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        throw new SQLException("Not supported yet!");
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.delegate.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        throw new SQLException("Not supported yet!");
    }

    @Override
    public void rollback() throws SQLException {
        throw new SQLException("Not supported yet!");
    }

    @Override
    public void close() throws SQLException {
        this.delegate.close();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.delegate.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        DatabaseMetaDataImpl metadata = new DatabaseMetaDataImpl();
        DatabaseMetaData delegateMetadata = this.delegate.getMetaData();
        metadata.setDelegate(delegateMetadata);
        return metadata;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.delegate.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.delegate.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.delegate.setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.delegate.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.delegate.setTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.delegate.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.delegate.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.delegate.clearWarnings();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkTransactionStatusIfNecessary();
        StatementImpl statement = new StatementImpl();
        statement.setConnection(this);
        statement.setDelegate(this.delegate.createStatement(resultSetType, resultSetConcurrency));
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkTransactionStatusIfNecessary();
        PreparedStatementImpl statement = new PreparedStatementImpl();
        statement.setConnection(this);
        statement.setDelegate(this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency));
        return statement;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkTransactionStatusIfNecessary();
        CallableStatementImpl statement = new CallableStatementImpl();
        statement.setConnection(this);
        statement.setDelegate(this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency));
        return statement;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.delegate.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.delegate.setTypeMap(map);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.delegate.setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.delegate.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.delegate.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.delegate.setSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.delegate.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.delegate.releaseSavepoint(savepoint);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkTransactionStatusIfNecessary();
        StatementImpl statement = new StatementImpl();
        statement.setConnection(this);
        statement.setDelegate(this.delegate.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkTransactionStatusIfNecessary();
        PreparedStatementImpl statement = new PreparedStatementImpl();
        statement.setConnection(this);
        statement.setDelegate(this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        return statement;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkTransactionStatusIfNecessary();
        CallableStatementImpl statement = new CallableStatementImpl();
        statement.setConnection(this);
        statement.setDelegate(this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkTransactionStatusIfNecessary();
        PreparedStatementImpl statement = new PreparedStatementImpl();
        statement.setConnection(this);
        statement.setDelegate(this.delegate.prepareStatement(sql, autoGeneratedKeys));
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkTransactionStatusIfNecessary();
        PreparedStatementImpl statement = new PreparedStatementImpl();
        statement.setConnection(this);
        statement.setDelegate(this.delegate.prepareStatement(sql, columnIndexes));
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkTransactionStatusIfNecessary();
        PreparedStatementImpl statement = new PreparedStatementImpl();
        statement.setConnection(this);
        statement.setDelegate(this.delegate.prepareStatement(sql, columnNames));
        return statement;
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.delegate.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.delegate.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.delegate.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.delegate.createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.delegate.isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.delegate.setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.delegate.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.delegate.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.delegate.getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.delegate.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.delegate.createStruct(typeName, attributes);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.delegate.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.delegate.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.delegate.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.delegate.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.delegate.getNetworkTimeout();
    }

    public void checkTransactionStatusIfNecessary() throws SQLException {
        int transactionStatus;
        TransactionBeanFactoryImpl beanFactory = TransactionBeanFactoryImpl.getInstance();
        TransactionManager transactionManager = beanFactory.getTransactionManager();
        Transaction transaction = transactionManager.getTransactionQuietly();
        if (transaction != null && 0 != (transactionStatus = transaction.getTransactionStatus()) && 1 != transactionStatus) {
            throw new SQLException("Operation is disabled during the inactive phase of the transaction!");
        }
    }

    public XAConnectionImpl getManagedConnection() {
        return this.managedConnection;
    }

    public void setManagedConnection(XAConnectionImpl managedConnection) {
        this.managedConnection = managedConnection;
    }

    public Connection getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Connection delegate) {
        this.delegate = delegate;
    }
}

