/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.supports.resource.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.bytesoft.bytejta.supports.resource.CommonResourceDescriptor;
import org.bytesoft.bytejta.supports.resource.jdbc.ConnectionImpl;
import org.bytesoft.transaction.supports.resource.XAResourceDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XAConnectionImpl
implements XAConnection,
ConnectionEventListener,
StatementEventListener {
    static final Logger logger = LoggerFactory.getLogger(XAConnectionImpl.class);
    private final Set<ConnectionEventListener> connectionEventListeners = new HashSet<ConnectionEventListener>();
    private final Set<StatementEventListener> statementEventListeners = new HashSet<StatementEventListener>();
    private String identifier;
    private XAConnection delegate;
    private boolean closed;
    private XAResource xaResource;

    @Override
    public void statementClosed(StatementEvent event) {
        for (StatementEventListener listener : this.statementEventListeners) {
            SQLException sqlException = event.getSQLException();
            PreparedStatement statement = event.getStatement();
            StatementEvent statementEvent = new StatementEvent(this, statement, sqlException);
            try {
                listener.statementClosed(statementEvent);
            }
            catch (RuntimeException error) {
                logger.warn("Error occurred!", (Throwable)error);
            }
        }
    }

    @Override
    public void statementErrorOccurred(StatementEvent event) {
        for (StatementEventListener listener : this.statementEventListeners) {
            SQLException sqlException = event.getSQLException();
            PreparedStatement statement = event.getStatement();
            StatementEvent statementEvent = new StatementEvent(this, statement, sqlException);
            try {
                listener.statementErrorOccurred(statementEvent);
            }
            catch (RuntimeException error) {
                logger.warn("Error occurred!", (Throwable)error);
            }
        }
    }

    @Override
    public void connectionClosed(ConnectionEvent event) {
        for (ConnectionEventListener listener : this.connectionEventListeners) {
            SQLException sqlException = event.getSQLException();
            ConnectionEvent connectionEvent = new ConnectionEvent(this, sqlException);
            try {
                listener.connectionClosed(connectionEvent);
            }
            catch (RuntimeException error) {
                logger.warn("Error occurred!", (Throwable)error);
            }
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        for (ConnectionEventListener listener : this.connectionEventListeners) {
            SQLException sqlException = event.getSQLException();
            ConnectionEvent connectionEvent = new ConnectionEvent(this, sqlException);
            try {
                listener.connectionErrorOccurred(connectionEvent);
            }
            catch (RuntimeException error) {
                logger.warn("Error occurred!", (Throwable)error);
            }
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection delegateConnection = this.delegate.getConnection();
        ConnectionImpl connection = new ConnectionImpl();
        connection.setManagedConnection(this);
        connection.setDelegate(delegateConnection);
        return connection;
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.connectionEventListeners.add(listener);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.connectionEventListeners.remove(listener);
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        this.statementEventListeners.add(listener);
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        this.statementEventListeners.remove(listener);
    }

    @Override
    public XAResource getXAResource() throws SQLException {
        if (this.xaResource == null) {
            this.initXAResourceIfNecessary();
        }
        return this.xaResource;
    }

    private synchronized void initXAResourceIfNecessary() throws SQLException {
        if (this.xaResource == null) {
            XAResource delegateResource = this.delegate.getXAResource();
            if (XAResourceDescriptor.class.isInstance(delegateResource)) {
                this.xaResource = delegateResource;
            } else {
                CommonResourceDescriptor descriptor = new CommonResourceDescriptor();
                descriptor.setDelegate(delegateResource);
                descriptor.setIdentifier(this.identifier);
                this.xaResource = descriptor;
            }
        }
    }

    @Override
    public void close() throws SQLException {
        if (!this.closed) {
            this.delegate.close();
            this.closed = true;
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public XAConnection getDelegate() {
        return this.delegate;
    }

    public void setDelegate(XAConnection delegate) {
        this.delegate = delegate;
    }
}

