/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.supports.resource.properties;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.support.EncodedResource;

public class ConnectorResourcePropertySource
extends PropertySource<Object> {
    private final Map<String, String> aliases = new HashMap<String, String>();
    private boolean enabled;

    public ConnectorResourcePropertySource(String name, EncodedResource source) {
        this(name, source, new HashMap<String, String>());
    }

    public ConnectorResourcePropertySource(String name, EncodedResource source, Map<String, String> aliases) {
        super(name, (Object)source);
        this.aliases.putAll(aliases);
        EncodedResource encoded = (EncodedResource)this.getSource();
        AbstractResource resource = (AbstractResource)encoded.getResource();
        String path = resource.getFilename();
        if (StringUtils.isBlank((CharSequence)path)) {
            return;
        }
        String[] values = path.split(":");
        if (values.length != 2) {
            return;
        }
        String protocol = values[0];
        String resName = values[1];
        if (!"bytejta".equalsIgnoreCase(protocol)) {
            return;
        }
        if (!"connector.config".equalsIgnoreCase(resName)) {
            return;
        }
        this.enabled = true;
    }

    public Object getProperty(String name) {
        if (!this.enabled) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        if (!StringUtils.startsWith((CharSequence)name, (CharSequence)"spring.datasource.")) {
            return null;
        }
        int dotIndex = name.lastIndexOf(".");
        String prefix = name.substring(0, dotIndex);
        String suffix = name.substring(dotIndex + 1);
        String alias = this.aliases.get(suffix);
        if (StringUtils.isBlank((CharSequence)alias)) {
            return null;
        }
        return String.format("${%s.%s}", prefix, alias);
    }
}

