/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.supports.spring;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.Map;
import javax.jms.XAConnectionFactory;
import javax.resource.spi.ManagedConnectionFactory;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.dbcp2.managed.BasicManagedDataSource;
import org.bytesoft.bytejta.TransactionBeanFactoryImpl;
import org.bytesoft.bytejta.supports.jdbc.LocalXADataSource;
import org.bytesoft.bytejta.supports.resource.ManagedConnectionFactoryHandler;
import org.bytesoft.bytejta.supports.resource.jdbc.XADataSourceImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;

public class ManagedConnectionFactoryPostProcessor
implements BeanPostProcessor,
Ordered,
SmartInitializingSingleton,
ApplicationContextAware {
    static String BEAN_TRANSACTION_MANAGER = "transactionManager";
    private ApplicationContext applicationContext;

    public void afterSingletonsInstantiated() {
        Iterator iterator;
        Map beanMap = this.applicationContext.getBeansOfType(LocalXADataSource.class);
        Iterator iterator2 = iterator = beanMap == null ? null : beanMap.entrySet().iterator();
        while (iterator != null && iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            LocalXADataSource bean = (LocalXADataSource)entry.getValue();
            this.initializeTransactionManagerIfNecessary(bean);
        }
    }

    private void initializeTransactionManagerIfNecessary(LocalXADataSource target) {
        if (target.getTransactionManager() == null) {
            TransactionManager transactionManager = (TransactionManager)this.applicationContext.getBean(BEAN_TRANSACTION_MANAGER);
            target.setTransactionManager(transactionManager);
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return this.wrapManagedConnectionFactoryIfNecessary(bean, beanName);
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return this.wrapManagedConnectionFactoryIfNecessary(bean, beanName);
    }

    private Object wrapManagedConnectionFactoryIfNecessary(Object bean, String beanName) throws BeansException {
        Class<?> clazz = bean.getClass();
        ClassLoader cl = clazz.getClassLoader();
        Class<?>[] interfaces = clazz.getInterfaces();
        if (this.hasAlreadyBeenWrappedBySelf(bean)) {
            return bean;
        }
        if (LocalXADataSource.class.isInstance(bean)) {
            LocalXADataSource target = (LocalXADataSource)bean;
            this.initializeTransactionManagerIfNecessary(target);
            return bean;
        }
        if (BasicManagedDataSource.class.isInstance(bean)) {
            BasicManagedDataSource managedDataSource = (BasicManagedDataSource)bean;
            TransactionBeanFactoryImpl beanFactory = TransactionBeanFactoryImpl.getInstance();
            managedDataSource.setTransactionManager((TransactionManager)beanFactory.getTransactionManager());
            return bean;
        }
        if (XADataSource.class.isInstance(bean)) {
            XADataSource xaDataSource = (XADataSource)bean;
            XADataSourceImpl wrappedDataSource = new XADataSourceImpl();
            wrappedDataSource.setIdentifier(beanName);
            wrappedDataSource.setXaDataSource(xaDataSource);
            return wrappedDataSource;
        }
        if (XAConnectionFactory.class.isInstance(bean)) {
            ManagedConnectionFactoryHandler interceptor = new ManagedConnectionFactoryHandler(bean);
            interceptor.setIdentifier(beanName);
            return Proxy.newProxyInstance(cl, interfaces, (InvocationHandler)interceptor);
        }
        if (ManagedConnectionFactory.class.isInstance(bean)) {
            ManagedConnectionFactoryHandler interceptor = new ManagedConnectionFactoryHandler(bean);
            interceptor.setIdentifier(beanName);
            return Proxy.newProxyInstance(cl, interfaces, (InvocationHandler)interceptor);
        }
        return bean;
    }

    private boolean hasAlreadyBeenWrappedBySelf(Object bean) {
        if (XADataSourceImpl.class.isInstance(bean)) {
            return true;
        }
        if (!Proxy.isProxyClass(bean.getClass())) {
            return false;
        }
        InvocationHandler handler = Proxy.getInvocationHandler(bean);
        return ManagedConnectionFactoryHandler.class.isInstance(handler);
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

