/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import org.cassandraunit.BaseCassandraUnit;
import org.cassandraunit.CQLDataLoader;
import org.cassandraunit.dataset.CQLDataSet;
import org.cassandraunit.utils.EmbeddedCassandraServerHelper;

public class CassandraCQLUnit
extends BaseCassandraUnit {
    private CQLDataSet dataSet;
    public Session session;
    public Cluster cluster;

    public CassandraCQLUnit(CQLDataSet dataSet) {
        this.dataSet = dataSet;
    }

    public CassandraCQLUnit(CQLDataSet dataSet, int readTimeoutMillis) {
        this.dataSet = dataSet;
        this.readTimeoutMillis = readTimeoutMillis;
    }

    public CassandraCQLUnit(CQLDataSet dataSet, String configurationFileName) {
        this(dataSet);
        this.configurationFileName = configurationFileName;
    }

    public CassandraCQLUnit(CQLDataSet dataSet, String configurationFileName, int readTimeoutMillis) {
        this(dataSet);
        this.configurationFileName = configurationFileName;
        this.readTimeoutMillis = readTimeoutMillis;
    }

    public CassandraCQLUnit(CQLDataSet dataSet, String configurationFileName, long startUpTimeoutMillis) {
        super(startUpTimeoutMillis);
        this.dataSet = dataSet;
        this.configurationFileName = configurationFileName;
    }

    public CassandraCQLUnit(CQLDataSet dataSet, String configurationFileName, long startUpTimeoutMillis, int readTimeoutMillis) {
        super(startUpTimeoutMillis);
        this.dataSet = dataSet;
        this.configurationFileName = configurationFileName;
        this.readTimeoutMillis = readTimeoutMillis;
    }

    @Override
    protected void load() {
        String hostIp = EmbeddedCassandraServerHelper.getHost();
        int port = EmbeddedCassandraServerHelper.getNativeTransportPort();
        this.cluster = new Cluster.Builder().addContactPoints(new String[]{hostIp}).withPort(port).withSocketOptions(this.getSocketOptions()).build();
        this.session = this.cluster.connect();
        CQLDataLoader dataLoader = new CQLDataLoader(this.session);
        dataLoader.load(this.dataSet);
        this.session = dataLoader.getSession();
    }

    protected void after() {
        super.after();
        try (Cluster c = this.cluster;
             Session s = this.session;){
            this.session = null;
            this.cluster = null;
        }
    }

    public Session getSession() {
        return this.session;
    }

    public Cluster getCluster() {
        return this.cluster;
    }
}

