/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.pluginsupport.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;
import org.codehaus.mojo.pluginsupport.ant.AntMojoSupport;
import org.codehaus.mojo.pluginsupport.ant.OptionSet;
import org.codehaus.mojo.pluginsupport.util.ObjectHolder;
import org.codehaus.plexus.util.FileUtils;

public abstract class JavaLauncherMojoSupport
extends AntMojoSupport {
    private Timer timer = new Timer(true);
    private String maximumMemory = null;
    protected File baseWorkingDirectory = null;
    protected boolean logOutput = false;
    protected boolean background = false;
    protected int timeout = -1;
    private int verifyTimeout = -1;
    protected OptionSet[] optionSets = null;
    protected String options = null;
    protected Map pluginArtifactMap = null;
    protected MavenProject project = null;
    protected ArtifactRepository artifactRepository = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected void doExecute() throws Exception {
        this.log.info((CharSequence)("Starting " + this.getProcessTitle() + "..."));
        final Java java = (Java)this.createTask("java");
        File workingDirectory = this.getWorkingDirectory();
        FileUtils.forceMkdir((File)workingDirectory);
        java.setDir(workingDirectory);
        java.setFailonerror(true);
        java.setFork(true);
        if (this.maximumMemory != null) {
            java.setMaxmemory(this.maximumMemory);
        }
        if (this.timeout > 0) {
            this.log.info((CharSequence)("Timeout after: " + this.timeout + " seconds"));
            java.setTimeout(new Long(this.timeout * 1000));
        }
        if (this.logOutput) {
            File file = this.getLogFile();
            this.log.info((CharSequence)("Redirecting output to: " + file));
            FileUtils.forceMkdir((File)file.getParentFile());
            java.setLogError(true);
            java.setOutput(file);
        }
        java.setClassname(this.getClassName());
        this.setClassPath(java.createClasspath());
        this.applyOptionSets(java);
        this.customizeJava(java);
        final ObjectHolder errorHolder = new ObjectHolder();
        Thread t = new Thread(this.getProcessTitle() + " Runner"){

            public void run() {
                try {
                    java.execute();
                }
                catch (Exception e) {
                    errorHolder.set(e);
                }
            }
        };
        t.start();
        this.log.debug((CharSequence)("Waiting for " + this.getProcessTitle() + "..."));
        final ObjectHolder verifyTimedOut = new ObjectHolder();
        TimerTask timeoutTask = new TimerTask(){

            public void run() {
                verifyTimedOut.set(Boolean.TRUE);
            }
        };
        if (this.verifyTimeout > 0) {
            this.log.debug((CharSequence)("Starting verify timeout task; triggers in: " + this.verifyTimeout + "s"));
            this.timer.schedule(timeoutTask, this.verifyTimeout * 1000);
        }
        boolean started = false;
        while (!started) {
            if (verifyTimedOut.isSet()) {
                throw new MojoExecutionException("Unable to verify if the " + this.getProcessTitle() + " process was started in the given time");
            }
            if (errorHolder.isSet()) {
                throw new MojoExecutionException("Failed to launch " + this.getProcessTitle(), (Throwable)errorHolder.get());
            }
            try {
                started = this.verifyProcessStarted();
            }
            catch (Exception e) {
                // empty catch block
            }
            Thread.sleep(1000L);
        }
        this.log.info((CharSequence)(this.getProcessTitle() + " started"));
        if (!this.background) {
            this.log.info((CharSequence)("Waiting for " + this.getProcessTitle() + " to shutdown..."));
            t.join();
        }
    }

    protected Artifact getPluginArtifact(String name) throws MojoExecutionException {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        Artifact artifact = (Artifact)this.pluginArtifactMap.get(name);
        if (artifact == null) {
            throw new MojoExecutionException("Unable to locate '" + name + "' in the list of plugin artifacts");
        }
        return artifact;
    }

    protected void appendArtifactFile(Path classpath, String name) throws MojoExecutionException {
        if (!$assertionsDisabled && classpath == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        this.appendArtifact(classpath, this.getPluginArtifact(name));
    }

    protected void appendArtifact(Path classpath, Artifact artifact) throws MojoExecutionException {
        if (!$assertionsDisabled && classpath == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && artifact == null) {
            throw new AssertionError();
        }
        File file = artifact.getFile();
        if (file == null) {
            throw new MojoExecutionException("Artifact does not have an attached file: " + artifact);
        }
        classpath.createPathElement().setLocation(file);
    }

    private void applyOptionSets(Java java) throws MojoExecutionException {
        if (!$assertionsDisabled && java == null) {
            throw new AssertionError();
        }
        if (this.options != null && (this.optionSets == null || this.optionSets.length == 0)) {
            throw new MojoExecutionException("At least one optionSet must be defined to select one using options");
        }
        if (this.options == null) {
            this.options = "default";
        }
        if (this.optionSets != null && this.optionSets.length != 0) {
            OptionSet[] sets = this.selectOptionSets();
            for (int i = 0; i < sets.length; ++i) {
                Properties props;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)("Selected option set: " + sets[i]));
                } else {
                    this.log.info((CharSequence)("Selected option set: " + sets[i].getId()));
                }
                String[] options = sets[i].getOptions();
                if (options != null) {
                    for (int j = 0; j < options.length; ++j) {
                        java.createJvmarg().setValue(options[j]);
                    }
                }
                if ((props = sets[i].getProperties()) == null) continue;
                Iterator<Object> iter = props.keySet().iterator();
                while (iter.hasNext()) {
                    String name = (String)iter.next();
                    String value = props.getProperty(name);
                    this.setSystemProperty(java, name, value);
                }
            }
        }
    }

    private OptionSet[] selectOptionSets() throws MojoExecutionException {
        HashMap<String, OptionSet> map = new HashMap<String, OptionSet>();
        for (int i = 0; i < this.optionSets.length; ++i) {
            String id;
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("Checking option set: " + this.optionSets[i]));
            }
            if ((id = this.optionSets[i].getId()) == null && this.optionSets.length > 1) {
                throw new MojoExecutionException("Must specify id for optionSet when more than one optionSet is configured");
            }
            if (id == null && this.optionSets.length == 1) {
                id = "default";
                this.optionSets[i].setId(id);
            }
            if (!$assertionsDisabled && id == null) {
                throw new AssertionError();
            }
            if (map.containsKey(id = id.trim())) {
                throw new MojoExecutionException("Must specify unique id for optionSet: " + this.optionSets[i]);
            }
            map.put(id, this.optionSets[i]);
        }
        StringTokenizer stok = new StringTokenizer(this.options, ",");
        ArrayList<OptionSet> selected = new ArrayList<OptionSet>();
        while (stok.hasMoreTokens()) {
            String id = stok.nextToken();
            OptionSet set = (OptionSet)map.get(this.options);
            if (set == null) {
                if ("default".equals(this.options)) {
                    this.log.debug((CharSequence)"Default optionSet selected, but no optionSet defined with that id; ignoring");
                    continue;
                }
                throw new MojoExecutionException("Missing optionSet for id: " + id);
            }
            selected.add(set);
        }
        return selected.toArray(new OptionSet[selected.size()]);
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected ArtifactRepository getArtifactRepository() {
        return this.artifactRepository;
    }

    protected abstract String getProcessName();

    protected String getProcessTitle() {
        return this.getProcessName();
    }

    protected File getWorkingDirectory() {
        return new File(this.baseWorkingDirectory, this.getProcessName());
    }

    protected File getLogFile() {
        return new File(this.getWorkingDirectory(), this.getProcessName() + ".log");
    }

    protected abstract String getClassName();

    protected abstract void setClassPath(Path var1) throws Exception;

    protected void customizeJava(Java java) throws MojoExecutionException {
        if (!$assertionsDisabled && java == null) {
            throw new AssertionError();
        }
    }

    protected boolean verifyProcessStarted() throws Exception {
        return true;
    }

    static {
        $assertionsDisabled = !JavaLauncherMojoSupport.class.desiredAssertionStatus();
    }
}

