/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.convolutional;

import java.util.Map;
import org.deeplearning4j.nn.api.layers.LayerConstraint;
import org.deeplearning4j.nn.conf.RNNFormat;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.Convolution1DLayer;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasConvolution;
import org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasConvolutionUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasActivationUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasConstraintUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasInitilizationUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasLayerUtils;
import org.deeplearning4j.nn.weights.IWeightInit;

public class KerasAtrousConvolution1D
extends KerasConvolution {
    public KerasAtrousConvolution1D(Integer kerasVersion) throws UnsupportedKerasConfigurationException {
        super(kerasVersion);
    }

    public KerasAtrousConvolution1D(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasAtrousConvolution1D(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        this.hasBias = KerasLayerUtils.getHasBiasFromConfig(layerConfig, this.conf);
        this.numTrainableParams = this.hasBias ? 2 : 1;
        LayerConstraint biasConstraint = KerasConstraintUtils.getConstraintsFromConfig(layerConfig, this.conf.getLAYER_FIELD_B_CONSTRAINT(), this.conf, this.kerasMajorVersion);
        LayerConstraint weightConstraint = KerasConstraintUtils.getConstraintsFromConfig(layerConfig, this.conf.getLAYER_FIELD_W_CONSTRAINT(), this.conf, this.kerasMajorVersion);
        IWeightInit init = KerasInitilizationUtils.getWeightInitFromConfig(layerConfig, this.conf.getLAYER_FIELD_INIT(), enforceTrainingConfig, this.conf, this.kerasMajorVersion);
        Convolution1DLayer.Builder builder = ((Convolution1DLayer.Builder)((Convolution1DLayer.Builder)((Convolution1DLayer.Builder)((Convolution1DLayer.Builder)((Convolution1DLayer.Builder)((Convolution1DLayer.Builder)((Convolution1DLayer.Builder)((Convolution1DLayer.Builder)((Convolution1DLayer.Builder)((Convolution1DLayer.Builder)new Convolution1DLayer.Builder().name(this.layerName)).nOut(KerasLayerUtils.getNOutFromConfig(layerConfig, this.conf))).dropOut(this.dropout)).activation(KerasActivationUtils.getIActivationFromConfig(layerConfig, this.conf))).weightInit(init)).dilation(new int[]{KerasConvolutionUtils.getDilationRate(layerConfig, 1, this.conf, true)[0]})).l1(this.weightL1Regularization)).l2(this.weightL2Regularization)).convolutionMode(KerasConvolutionUtils.getConvolutionModeFromConfig(layerConfig, this.conf))).kernelSize(KerasConvolutionUtils.getKernelSizeFromConfig(layerConfig, 1, this.conf, this.kerasMajorVersion)[0]).hasBias(this.hasBias)).rnnDataFormat(this.dimOrder == KerasLayer.DimOrder.TENSORFLOW ? RNNFormat.NWC : RNNFormat.NCW).stride(KerasConvolutionUtils.getStrideFromConfig(layerConfig, 1, this.conf)[0]);
        int[] padding = KerasConvolutionUtils.getPaddingFromBorderModeConfig(layerConfig, 1, this.conf, this.kerasMajorVersion);
        if (this.hasBias) {
            builder.biasInit(0.0);
        }
        if (padding != null) {
            builder.padding(padding[0]);
        }
        if (biasConstraint != null) {
            builder.constrainBias(new LayerConstraint[]{biasConstraint});
        }
        if (weightConstraint != null) {
            builder.constrainWeights(new LayerConstraint[]{weightConstraint});
        }
        this.layer = builder.build();
        Convolution1DLayer convolution1DLayer = (Convolution1DLayer)this.layer;
        convolution1DLayer.setDefaultValueOverriden(true);
    }

    public Convolution1DLayer getAtrousConvolution1D() {
        return (Convolution1DLayer)this.layer;
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras Convolution layer accepts only one input (received " + inputType.length + ")");
        }
        return this.getAtrousConvolution1D().getOutputType(-1, inputType[0]);
    }
}

