/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.convolutional;

import java.util.Map;
import org.deeplearning4j.nn.api.layers.LayerConstraint;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.Deconvolution3D;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasConvolution;
import org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasConvolutionUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasActivationUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasConstraintUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasInitilizationUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasLayerUtils;
import org.deeplearning4j.nn.weights.IWeightInit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerasDeconvolution3D
extends KerasConvolution {
    private static final Logger log = LoggerFactory.getLogger(KerasDeconvolution3D.class);

    public KerasDeconvolution3D(Integer kerasVersion) throws UnsupportedKerasConfigurationException {
        super(kerasVersion);
    }

    public KerasDeconvolution3D(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasDeconvolution3D(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        this.hasBias = KerasLayerUtils.getHasBiasFromConfig(layerConfig, this.conf);
        this.numTrainableParams = this.hasBias ? 2 : 1;
        int[] dilationRate = KerasConvolutionUtils.getDilationRate(layerConfig, 3, this.conf, false);
        IWeightInit init = KerasInitilizationUtils.getWeightInitFromConfig(layerConfig, this.conf.getLAYER_FIELD_INIT(), enforceTrainingConfig, this.conf, this.kerasMajorVersion);
        LayerConstraint biasConstraint = KerasConstraintUtils.getConstraintsFromConfig(layerConfig, this.conf.getLAYER_FIELD_B_CONSTRAINT(), this.conf, this.kerasMajorVersion);
        LayerConstraint weightConstraint = KerasConstraintUtils.getConstraintsFromConfig(layerConfig, this.conf.getLAYER_FIELD_W_CONSTRAINT(), this.conf, this.kerasMajorVersion);
        Deconvolution3D.Builder builder = ((Deconvolution3D.Builder)((Deconvolution3D.Builder)((Deconvolution3D.Builder)((Deconvolution3D.Builder)((Deconvolution3D.Builder)((Deconvolution3D.Builder)((Deconvolution3D.Builder)((Deconvolution3D.Builder)new Deconvolution3D.Builder().name(this.layerName)).nOut(KerasLayerUtils.getNOutFromConfig(layerConfig, this.conf))).dropOut(this.dropout)).activation(KerasActivationUtils.getIActivationFromConfig(layerConfig, this.conf))).weightInit(init)).dataFormat(KerasConvolutionUtils.getCNN3DDataFormatFromConfig(layerConfig, this.conf)).l1(this.weightL1Regularization)).l2(this.weightL2Regularization)).convolutionMode(KerasConvolutionUtils.getConvolutionModeFromConfig(layerConfig, this.conf)).kernelSize(KerasConvolutionUtils.getKernelSizeFromConfig(layerConfig, 2, this.conf, this.kerasMajorVersion)).hasBias(this.hasBias)).stride(KerasConvolutionUtils.getStrideFromConfig(layerConfig, 3, this.conf));
        int[] padding = KerasConvolutionUtils.getPaddingFromBorderModeConfig(layerConfig, 3, this.conf, this.kerasMajorVersion);
        if (this.hasBias) {
            builder.biasInit(0.0);
        }
        if (padding != null) {
            builder.padding(padding);
        }
        if (dilationRate != null) {
            builder.dilation(dilationRate);
        }
        if (biasConstraint != null) {
            builder.constrainBias(new LayerConstraint[]{biasConstraint});
        }
        if (weightConstraint != null) {
            builder.constrainWeights(new LayerConstraint[]{weightConstraint});
        }
        this.layer = builder.build();
        Deconvolution3D deconvolution3D = (Deconvolution3D)this.layer;
        deconvolution3D.setDefaultValueOverriden(true);
    }

    public Deconvolution3D getDeconvolution3DLayer() {
        return (Deconvolution3D)this.layer;
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras Convolution layer accepts only one input (received " + inputType.length + ")");
        }
        return this.getDeconvolution3DLayer().getOutputType(-1, inputType[0]);
    }

    @Override
    public String toString() {
        return "KerasDeconvolution3D()";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KerasDeconvolution3D)) {
            return false;
        }
        KerasDeconvolution3D other = (KerasDeconvolution3D)o;
        return other.canEqual(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KerasDeconvolution3D;
    }

    @Override
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

