/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nlp.uima.corpora.treeparser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.util.CasPool;
import org.cleartk.opennlp.tools.ParserAnnotator;
import org.cleartk.opennlp.tools.parser.DefaultOutputTypesHelper;
import org.cleartk.syntax.constituent.type.TopTreebankNode;
import org.cleartk.syntax.constituent.type.TreebankNode;
import org.cleartk.token.type.Sentence;
import org.cleartk.token.type.Token;
import org.cleartk.util.ParamUtil;
import org.deeplearning4j.nlp.uima.annotator.PoStagger;
import org.deeplearning4j.nlp.uima.annotator.SentenceAnnotator;
import org.deeplearning4j.nlp.uima.annotator.StemmerAnnotator;
import org.deeplearning4j.nlp.uima.annotator.TokenizerAnnotator;
import org.deeplearning4j.nlp.uima.corpora.treeparser.TreeFactory;
import org.deeplearning4j.nlp.uima.tokenization.tokenizerfactory.UimaTokenizerFactory;
import org.deeplearning4j.nn.layers.feedforward.autoencoder.recursive.Tree;
import org.deeplearning4j.text.movingwindow.ContextLabelRetriever;
import org.deeplearning4j.text.sentenceiterator.SentencePreProcessor;
import org.deeplearning4j.text.tokenization.tokenizerfactory.TokenizerFactory;
import org.nd4j.common.collection.MultiDimensionalMap;
import org.nd4j.common.primitives.Pair;
import org.nd4j.common.util.SetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeParser {
    private AnalysisEngine parser;
    private AnalysisEngine tokenizer;
    private CasPool pool;
    private static final Logger log = LoggerFactory.getLogger(TreeParser.class);
    private TokenizerFactory tf;

    public TreeParser(AnalysisEngine parser, AnalysisEngine tokenizer, CasPool pool) {
        this.parser = parser;
        this.tokenizer = tokenizer;
        this.pool = pool;
        this.tf = new UimaTokenizerFactory(tokenizer, true);
    }

    public TreeParser() throws Exception {
        if (this.parser == null) {
            this.parser = TreeParser.getParser();
        }
        if (this.tokenizer == null) {
            this.tokenizer = TreeParser.getTokenizer();
        }
        if (this.pool == null) {
            this.pool = new CasPool(Runtime.getRuntime().availableProcessors(), this.parser);
        }
        this.tf = new UimaTokenizerFactory(this.tokenizer, true);
    }

    public List<Tree> getTrees(String text, SentencePreProcessor preProcessor) throws Exception {
        if (text.isEmpty()) {
            return new ArrayList<Tree>();
        }
        CAS c = this.pool.getCas();
        if (preProcessor != null) {
            text = preProcessor.preProcess(text);
        }
        c.setDocumentText(text);
        this.tokenizer.process(c);
        ArrayList<Tree> ret = new ArrayList<Tree>();
        CAS c2 = this.pool.getCas();
        ArrayList<Pair> list = new ArrayList<Pair>();
        for (Sentence sentence : JCasUtil.select((JCas)c.getJCas(), Sentence.class)) {
            ArrayList<String> tokens = new ArrayList<String>();
            for (Token t : JCasUtil.selectCovered(Token.class, (AnnotationFS)sentence)) {
                tokens.add(t.getCoveredText());
            }
            Pair p = ContextLabelRetriever.stringWithLabels((String)sentence.getCoveredText(), (TokenizerFactory)this.tf);
            c2.setDocumentText((String)p.getFirst());
            list.add(p);
            this.tokenizer.process(c2);
            this.parser.process(c2);
            TopTreebankNode node = (TopTreebankNode)JCasUtil.selectSingle((JCas)c.getJCas(), TopTreebankNode.class);
            ret.add(TreeFactory.buildTree((TreebankNode)node));
        }
        this.pool.releaseCas(c2);
        for (Tree t : ret) {
            this.addPreTerminal(t);
        }
        return ret;
    }

    private void addPreTerminal(Tree t) {
        if (t.isLeaf()) {
            Tree newLeaf = new Tree(t);
            newLeaf.setLabel(t.value());
            t.children().add(newLeaf);
            newLeaf.setParent(t);
        } else {
            for (Tree child : t.children()) {
                this.addPreTerminal(child);
            }
        }
    }

    public List<TreebankNode> getTreebankTrees(String text) throws Exception {
        if (text.isEmpty()) {
            return new ArrayList<TreebankNode>();
        }
        CAS c = this.pool.getCas();
        c.setDocumentText(text);
        this.tokenizer.process(c);
        ArrayList<TreebankNode> ret = new ArrayList<TreebankNode>();
        for (Sentence sentence : JCasUtil.select((JCas)c.getJCas(), Sentence.class)) {
            ArrayList<String> tokens = new ArrayList<String>();
            CAS c2 = this.tokenizer.newCAS();
            for (Token t : JCasUtil.selectCovered(Token.class, (AnnotationFS)sentence)) {
                tokens.add(t.getCoveredText());
            }
            c2.setDocumentText(sentence.getCoveredText());
            this.tokenizer.process(c2);
            this.parser.process(c2);
            TopTreebankNode node = (TopTreebankNode)JCasUtil.selectSingle((JCas)c2.getJCas(), TopTreebankNode.class);
            ret.add((TreebankNode)node);
        }
        this.pool.releaseCas(c);
        return ret;
    }

    public List<Tree> getTreesWithLabels(String text, String label, List<String> labels) throws Exception {
        if (text.isEmpty()) {
            return new ArrayList<Tree>();
        }
        CAS c = this.pool.getCas();
        c.setDocumentText("<" + label + "> " + text + " </" + label + ">");
        this.tokenizer.process(c);
        ArrayList<String> lowerCaseLabels = new ArrayList<String>();
        for (String s : labels) {
            lowerCaseLabels.add(s.toLowerCase());
        }
        labels = lowerCaseLabels;
        ArrayList<Tree> ret = new ArrayList<Tree>();
        CAS c2 = this.pool.getCas();
        for (Sentence sentence : JCasUtil.select((JCas)c.getJCas(), Sentence.class)) {
            if (sentence.getCoveredText().isEmpty()) continue;
            ArrayList<String> tokens = new ArrayList<String>();
            for (Token t : JCasUtil.selectCovered(Token.class, (AnnotationFS)sentence)) {
                tokens.add(t.getCoveredText());
            }
            try {
                Pair stringsWithLabels = ContextLabelRetriever.stringWithLabels((String)sentence.getCoveredText(), (TokenizerFactory)this.tf);
                c2.setDocumentText((String)stringsWithLabels.getFirst());
                this.tokenizer.process(c2);
                this.parser.process(c2);
                ArrayList nodes = new ArrayList(JCasUtil.select((JCas)c2.getJCas(), TopTreebankNode.class));
                if (nodes.size() > 1) {
                    log.warn("More than one top level node for a treebank parse. Only accepting first input node.");
                } else if (nodes.isEmpty()) {
                    c2.reset();
                    continue;
                }
                TopTreebankNode node = (TopTreebankNode)nodes.get(0);
                ret.add(TreeFactory.buildTree((TreebankNode)node, (Pair<String, MultiDimensionalMap<Integer, Integer, String>>)stringsWithLabels, labels));
                c2.reset();
            }
            catch (Exception e) {
                log.warn("Unable to parse " + sentence.getCoveredText());
                c2.reset();
            }
        }
        this.pool.releaseCas(c);
        this.pool.releaseCas(c2);
        return ret;
    }

    public List<Tree> getTreesWithLabels(String text, List<String> labels) throws Exception {
        CAS c = this.pool.getCas();
        c.setDocumentText(text);
        this.tokenizer.process(c);
        ArrayList<String> lowerCaseLabels = new ArrayList<String>();
        for (String s : labels) {
            lowerCaseLabels.add(s.toLowerCase());
        }
        labels = lowerCaseLabels;
        ArrayList<Tree> ret = new ArrayList<Tree>();
        CAS c2 = this.pool.getCas();
        for (Sentence sentence : JCasUtil.select((JCas)c.getJCas(), Sentence.class)) {
            ArrayList<String> tokens = new ArrayList<String>();
            for (Token t : JCasUtil.selectCovered(Token.class, (AnnotationFS)sentence)) {
                tokens.add(t.getCoveredText());
            }
            Pair stringsWithLabels = ContextLabelRetriever.stringWithLabels((String)sentence.getCoveredText(), (TokenizerFactory)this.tf);
            c2.setDocumentText((String)stringsWithLabels.getFirst());
            this.tokenizer.process(c2);
            this.parser.process(c2);
            ArrayList nodes = new ArrayList(JCasUtil.select((JCas)c2.getJCas(), TopTreebankNode.class));
            if (nodes.size() > 1) {
                log.warn("More than one top level node for a treebank parse. Only accepting first input node.");
            } else if (nodes.isEmpty()) {
                c2.reset();
                continue;
            }
            Collection labels2 = ((MultiDimensionalMap)stringsWithLabels.getSecond()).values();
            Set diff = SetUtils.difference((Collection)labels2, labels);
            if (!diff.isEmpty()) {
                log.warn("Found invalid sentence. Skipping");
                c2.reset();
                continue;
            }
            TopTreebankNode node = (TopTreebankNode)nodes.get(0);
            ret.add(TreeFactory.buildTree((TreebankNode)node, (Pair<String, MultiDimensionalMap<Integer, Integer, String>>)stringsWithLabels, labels));
            c2.reset();
        }
        this.pool.releaseCas(c);
        this.pool.releaseCas(c2);
        return ret;
    }

    public List<Tree> getTrees(String text) throws Exception {
        CAS c = this.pool.getCas();
        c.setDocumentText(text);
        this.tokenizer.process(c);
        ArrayList<Tree> ret = new ArrayList<Tree>();
        CAS c2 = this.pool.getCas();
        for (Sentence sentence : JCasUtil.select((JCas)c.getJCas(), Sentence.class)) {
            ArrayList<String> tokens = new ArrayList<String>();
            for (Token t : JCasUtil.selectCovered(Token.class, (AnnotationFS)sentence)) {
                tokens.add(t.getCoveredText());
            }
            c2.setDocumentText(sentence.getCoveredText());
            this.tokenizer.process(c2);
            this.parser.process(c2);
            TopTreebankNode node = (TopTreebankNode)JCasUtil.selectSingle((JCas)c2.getJCas(), TopTreebankNode.class);
            log.info("Tree bank parse " + node.getTreebankParse());
            for (TreebankNode node2 : JCasUtil.select((JCas)c2.getJCas(), TreebankNode.class)) {
                log.info("Node val " + node2.getNodeValue() + " and label " + node2.getNodeType() + " and tags was " + node2.getNodeTags());
            }
            ret.add(TreeFactory.buildTree((TreebankNode)node));
            c2.reset();
        }
        this.pool.releaseCas(c);
        this.pool.releaseCas(c2);
        return ret;
    }

    public static AnalysisEngine getTokenizer() throws Exception {
        return AnalysisEngineFactory.createEngine((AnalysisEngineDescription)AnalysisEngineFactory.createEngineDescription((AnalysisEngineDescription[])new AnalysisEngineDescription[]{SentenceAnnotator.getDescription(), TokenizerAnnotator.getDescription(), PoStagger.getDescription("en"), StemmerAnnotator.getDescription("English")}), (Object[])new Object[0]);
    }

    public static AnalysisEngine getParser() throws Exception {
        return AnalysisEngineFactory.createEngine((AnalysisEngineDescription)AnalysisEngineFactory.createEngineDescription((AnalysisEngineDescription[])new AnalysisEngineDescription[]{AnalysisEngineFactory.createEngineDescription(ParserAnnotator.class, (Object[])new Object[]{"useTagsFromCas", true, "parserModelPath", ParamUtil.getParameterValue((String)"parserModelPath", (String)"/models/en-parser-chunking.bin"), "outputTypesHelperClassName", DefaultOutputTypesHelper.class.getName()})}), (Object[])new Object[0]);
    }
}

