/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nlp.uima.sentenceiterator;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.cas.CAS;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.token.type.Sentence;
import org.deeplearning4j.nlp.uima.annotator.SentenceAnnotator;
import org.deeplearning4j.nlp.uima.annotator.TokenizerAnnotator;
import org.deeplearning4j.nlp.uima.sentenceiterator.UimaSentenceIterator;
import org.deeplearning4j.nlp.uima.uima.UimaResource;
import org.deeplearning4j.text.sentenceiterator.BasicResultSetIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UimaResultSetIterator
extends BasicResultSetIterator {
    private UimaResource resource;
    protected volatile Iterator<String> sentences;
    private static final Logger log = LoggerFactory.getLogger(UimaSentenceIterator.class);

    public UimaResultSetIterator(ResultSet rs, String columnName) throws ResourceInitializationException {
        this(rs, columnName, new UimaResource(AnalysisEngineFactory.createEngine((AnalysisEngineDescription)AnalysisEngineFactory.createEngineDescription((AnalysisEngineDescription[])new AnalysisEngineDescription[]{TokenizerAnnotator.getDescription(), SentenceAnnotator.getDescription()}), (Object[])new Object[0])));
    }

    public UimaResultSetIterator(ResultSet rs, String columnName, UimaResource resource) {
        super(rs, columnName);
        this.resource = resource;
    }

    public synchronized String nextSentence() {
        if (this.sentences == null || !this.sentences.hasNext()) {
            try {
                String text = super.nextSentence();
                if (text == null) {
                    return "";
                }
                CAS cas = this.resource.retrieve();
                cas.setDocumentText(text);
                this.resource.getAnalysisEngine().process(cas);
                ArrayList<String> list = new ArrayList<String>();
                for (Sentence sentence : JCasUtil.select((JCas)cas.getJCas(), Sentence.class)) {
                    list.add(sentence.getCoveredText());
                }
                this.sentences = list.iterator();
                String ret = this.sentences.next();
                if (this.getPreProcessor() != null) {
                    ret = this.getPreProcessor().preProcess(ret);
                }
                return ret;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        String ret = this.sentences.next();
        if (this.getPreProcessor() != null) {
            ret = this.getPreProcessor().preProcess(ret);
        }
        return ret;
    }

    public synchronized boolean hasNext() {
        try {
            if (this.sentences != null && this.sentences.hasNext()) {
                return true;
            }
            return super.hasNext();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void reset() {
        this.sentences = null;
        super.reset();
    }

    public void finish() {
        this.sentences = null;
        super.finish();
    }
}

