/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nlp.uima.tokenization.tokenizer.preprocessor;

import lombok.NonNull;
import org.deeplearning4j.text.tokenization.tokenizer.preprocessor.CommonPreprocessor;
import org.tartarus.snowball.SnowballProgram;

public class CustomStemmingPreprocessor
extends CommonPreprocessor {
    private SnowballProgram stemmer;

    public CustomStemmingPreprocessor(@NonNull SnowballProgram stemmer) {
        if (stemmer == null) {
            throw new NullPointerException("stemmer is marked non-null but is null");
        }
        this.stemmer = stemmer;
    }

    public synchronized String preProcess(String token) {
        String prep = super.preProcess(token);
        this.stemmer.setCurrent(prep);
        this.stemmer.stem();
        return this.stemmer.getCurrent();
    }
}

