/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nlp.uima.tokenization.tokenizer.preprocessor;

import lombok.NonNull;
import org.deeplearning4j.text.tokenization.tokenizer.TokenPreProcess;
import org.tartarus.snowball.ext.PorterStemmer;

public class EmbeddedStemmingPreprocessor
implements TokenPreProcess {
    private TokenPreProcess preProcessor;

    public EmbeddedStemmingPreprocessor(@NonNull TokenPreProcess preProcess) {
        if (preProcess == null) {
            throw new NullPointerException("preProcess is marked non-null but is null");
        }
        this.preProcessor = preProcess;
    }

    public String preProcess(String token) {
        String prep = this.preProcessor == null ? token : this.preProcessor.preProcess(token);
        PorterStemmer stemmer = new PorterStemmer();
        stemmer.setCurrent(prep);
        stemmer.stem();
        return stemmer.getCurrent();
    }

    public EmbeddedStemmingPreprocessor() {
    }
}

