/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.serde.format;

import java.io.IOException;
import org.deeplearning4j.nn.conf.CNN2DFormat;
import org.deeplearning4j.nn.conf.DataFormat;
import org.deeplearning4j.nn.conf.RNNFormat;
import org.deeplearning4j.nn.conf.layers.Convolution3D;
import org.nd4j.shade.jackson.core.JsonParser;
import org.nd4j.shade.jackson.core.JsonProcessingException;
import org.nd4j.shade.jackson.databind.DeserializationContext;
import org.nd4j.shade.jackson.databind.JsonDeserializer;
import org.nd4j.shade.jackson.databind.JsonNode;

public class DataFormatDeserializer
extends JsonDeserializer<DataFormat> {
    public DataFormat deserialize(JsonParser jp, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        String text;
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        switch (text = node.textValue()) {
            case "NCHW": {
                return CNN2DFormat.NCHW;
            }
            case "NHWC": {
                return CNN2DFormat.NHWC;
            }
            case "NCW": {
                return RNNFormat.NCW;
            }
            case "NWC": {
                return RNNFormat.NWC;
            }
            case "NCDHW": {
                return Convolution3D.DataFormat.NCDHW;
            }
            case "NDHWC": {
                return Convolution3D.DataFormat.NDHWC;
            }
        }
        return null;
    }
}

