/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers;

import org.deeplearning4j.config.DL4JClassLoading;
import org.deeplearning4j.nn.layers.LayerHelper;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelperUtils {
    private static final Logger log = LoggerFactory.getLogger(HelperUtils.class);

    public static <T extends LayerHelper> T createHelper(String cudnnHelperClassName, String oneDnnClassName, Class<? extends LayerHelper> layerHelperSuperClass, String layerName, Object ... arguments) {
        Boolean disabled = Boolean.parseBoolean(System.getProperty("org.eclipse.deeplearning4j.helpers.disable", "true"));
        if (disabled.booleanValue()) {
            log.trace("Disabled helper creation, returning null");
            return null;
        }
        String backend = Nd4j.getExecutioner().getEnvironmentInformation().getProperty("backend");
        LayerHelper helperRet = null;
        if ("CUDA".equalsIgnoreCase(backend) && cudnnHelperClassName != null && !cudnnHelperClassName.isEmpty()) {
            if (DL4JClassLoading.loadClassByName((String)cudnnHelperClassName) != null) {
                log.debug("Attempting to initialize cudnn helper {}", (Object)cudnnHelperClassName);
                helperRet = (LayerHelper)DL4JClassLoading.createNewInstance((String)cudnnHelperClassName, layerHelperSuperClass, (Object[])new Object[]{arguments});
                log.debug("Cudnn helper {} successfully initialized", (Object)cudnnHelperClassName);
            } else {
                log.warn("Unable to find class {}  using the classloader set for Dl4jClassLoading. Trying to use class loader that loaded the  class {} instead.", (Object)cudnnHelperClassName, (Object)layerHelperSuperClass.getName());
                ClassLoader classLoader = DL4JClassLoading.getDl4jClassloader();
                DL4JClassLoading.setDl4jClassloaderFromClass(layerHelperSuperClass);
                try {
                    helperRet = (LayerHelper)DL4JClassLoading.createNewInstance((String)cudnnHelperClassName, layerHelperSuperClass, (Object[])arguments);
                }
                catch (Exception e) {
                    log.warn("Unable to use  helper implementation {} for helper type {}, please check your classpath. Falling back to built in  normal  methods for now.", (Object)cudnnHelperClassName, (Object)layerHelperSuperClass.getName());
                }
                log.warn("Returning class loader to original one.");
                DL4JClassLoading.setDl4jClassloader((ClassLoader)classLoader);
            }
            if (helperRet != null && !helperRet.checkSupported()) {
                return null;
            }
            if (helperRet != null) {
                log.debug("{} successfully initialized", (Object)cudnnHelperClassName);
            }
        } else if ("CPU".equalsIgnoreCase(backend) && oneDnnClassName != null && !oneDnnClassName.isEmpty()) {
            helperRet = (LayerHelper)DL4JClassLoading.createNewInstance((String)oneDnnClassName, (Object[])arguments);
            log.trace("Created oneDNN helper: {}, layer {}", (Object)oneDnnClassName, (Object)layerName);
        }
        if (helperRet != null && !helperRet.checkSupported()) {
            log.debug("Removed helper {} as not supported", helperRet.getClass());
            return null;
        }
        return (T)helperRet;
    }
}

