/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.weights.embeddings;

import lombok.NonNull;
import org.deeplearning4j.nn.weights.IWeightInit;
import org.deeplearning4j.nn.weights.embeddings.EmbeddingInitializer;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"nonSerializableInit"})
public class WeightInitEmbedding
implements IWeightInit {
    private EmbeddingInitializer serializableInit;
    private EmbeddingInitializer nonSerializableInit;

    public WeightInitEmbedding(@NonNull EmbeddingInitializer embeddingInitializer) {
        this(embeddingInitializer.jsonSerializable() ? embeddingInitializer : null, embeddingInitializer.jsonSerializable() ? null : embeddingInitializer);
        if (embeddingInitializer == null) {
            throw new NullPointerException("embeddingInitializer is marked non-null but is null");
        }
    }

    protected WeightInitEmbedding(@JsonProperty(value="serializableInit") EmbeddingInitializer serializableInit, @JsonProperty(value="nonSerializableInit") EmbeddingInitializer nonSerializableInit) {
        this.serializableInit = serializableInit;
        this.nonSerializableInit = nonSerializableInit;
    }

    @Override
    public INDArray init(double fanIn, double fanOut, long[] shape, char order, INDArray paramView) {
        EmbeddingInitializer init;
        EmbeddingInitializer embeddingInitializer = init = this.serializableInit != null ? this.serializableInit : this.nonSerializableInit;
        if (init == null) {
            throw new IllegalStateException("Cannot initialize embedding layer weights: no EmbeddingInitializer is available. This can occur if you save network configuration, load it, and the try to ");
        }
        Preconditions.checkState((shape[0] == init.vocabSize() ? 1 : 0) != 0, (String)"Parameters shape[0]=%s does not match embedding initializer vocab size of %s", (long)shape[0], (long)init.vocabSize());
        Preconditions.checkState((shape[1] == (long)init.vectorSize() ? 1 : 0) != 0, (String)"Parameters shape[1]=%s does not match embedding initializer vector size of %s", (long)shape[1], (long)init.vectorSize());
        INDArray reshaped = paramView.reshape('c', shape);
        init.loadWeightsInto(reshaped);
        this.nonSerializableInit = null;
        return reshaped;
    }

    public long[] shape() {
        if (this.serializableInit != null) {
            return new long[]{this.serializableInit.vocabSize(), this.serializableInit.vectorSize()};
        }
        if (this.nonSerializableInit != null) {
            return new long[]{this.nonSerializableInit.vocabSize(), this.nonSerializableInit.vectorSize()};
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WeightInitEmbedding)) {
            return false;
        }
        WeightInitEmbedding other = (WeightInitEmbedding)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EmbeddingInitializer this$serializableInit = this.serializableInit;
        EmbeddingInitializer other$serializableInit = other.serializableInit;
        if (this$serializableInit == null ? other$serializableInit != null : !this$serializableInit.equals(other$serializableInit)) {
            return false;
        }
        EmbeddingInitializer this$nonSerializableInit = this.nonSerializableInit;
        EmbeddingInitializer other$nonSerializableInit = other.nonSerializableInit;
        return !(this$nonSerializableInit == null ? other$nonSerializableInit != null : !this$nonSerializableInit.equals(other$nonSerializableInit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WeightInitEmbedding;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EmbeddingInitializer $serializableInit = this.serializableInit;
        result = result * 59 + ($serializableInit == null ? 43 : $serializableInit.hashCode());
        EmbeddingInitializer $nonSerializableInit = this.nonSerializableInit;
        result = result * 59 + ($nonSerializableInit == null ? 43 : $nonSerializableInit.hashCode());
        return result;
    }
}

