/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.drools.common.InternalRuleBase;
import org.drools.facttemplates.Fact;
import org.drools.reteoo.ClassObjectTypeConf;
import org.drools.reteoo.FactTemplateTypeConf;
import org.drools.reteoo.ObjectTypeConf;
import org.drools.rule.EntryPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectTypeConfigurationRegistry
implements Serializable {
    private InternalRuleBase ruleBase;
    private Map<Object, ObjectTypeConf> typeConfMap;

    public ObjectTypeConfigurationRegistry(InternalRuleBase ruleBase) {
        this.ruleBase = ruleBase;
        this.typeConfMap = new HashMap<Object, ObjectTypeConf>();
    }

    public ObjectTypeConf getObjectTypeConf(EntryPoint entrypoint, Object object) {
        ObjectTypeConf objectTypeConf = null;
        Class<?> cls = null;
        if (object instanceof Fact) {
            String key = ((Fact)object).getFactTemplate().getName();
            objectTypeConf = this.typeConfMap.get(key);
        } else {
            cls = object.getClass();
            objectTypeConf = this.typeConfMap.get(cls);
        }
        if (objectTypeConf == null) {
            if (object instanceof Fact) {
                objectTypeConf = new FactTemplateTypeConf(entrypoint, ((Fact)object).getFactTemplate(), this.ruleBase);
                this.typeConfMap.put(((Fact)object).getFactTemplate().getName(), objectTypeConf);
            } else {
                objectTypeConf = new ClassObjectTypeConf(entrypoint, cls, this.ruleBase);
                this.typeConfMap.put(cls, objectTypeConf);
            }
        }
        return objectTypeConf;
    }

    public Collection<ObjectTypeConf> values() {
        return this.typeConfMap.values();
    }
}

