/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.WorkingMemory;
import org.drools.common.InternalFactHandle;
import org.drools.rule.ConditionalElement;
import org.drools.rule.Declaration;
import org.drools.rule.PatternSource;
import org.drools.rule.RuleConditionElement;
import org.drools.spi.Accumulator;
import org.drools.spi.CompiledInvoker;
import org.drools.spi.Tuple;
import org.drools.spi.Wireable;

public class Accumulate
extends ConditionalElement
implements Wireable,
PatternSource {
    private static final long serialVersionUID = 400L;
    private Accumulator accumulator;
    private RuleConditionElement source;
    private Declaration[] requiredDeclarations;
    private Declaration[] innerDeclarations;
    private List<Accumulate> cloned = Collections.emptyList();

    public Accumulate() {
    }

    public Accumulate(RuleConditionElement source) {
        this(source, new Declaration[0], new Declaration[0], null);
    }

    public Accumulate(RuleConditionElement source, Declaration[] requiredDeclarations, Declaration[] innerDeclarations) {
        this(source, requiredDeclarations, innerDeclarations, null);
    }

    public Accumulate(RuleConditionElement source, Declaration[] requiredDeclarations, Declaration[] innerDeclarations, Accumulator accumulator) {
        this.source = source;
        this.requiredDeclarations = requiredDeclarations;
        this.innerDeclarations = innerDeclarations;
        this.accumulator = accumulator;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.accumulator = (Accumulator)in.readObject();
        this.source = (RuleConditionElement)in.readObject();
        this.requiredDeclarations = (Declaration[])in.readObject();
        this.innerDeclarations = (Declaration[])in.readObject();
        this.cloned = (List)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.accumulator instanceof CompiledInvoker) {
            out.writeObject(null);
        } else {
            out.writeObject(this.accumulator);
        }
        out.writeObject(this.source);
        out.writeObject(this.requiredDeclarations);
        out.writeObject(this.innerDeclarations);
        out.writeObject(this.cloned);
    }

    public Accumulator getAccumulator() {
        return this.accumulator;
    }

    public void wire(Object object) {
        this.setAccumulator((Accumulator)object);
        for (Accumulate clone : this.cloned) {
            clone.wire(object);
        }
    }

    public void setAccumulator(Accumulator accumulator) {
        this.accumulator = accumulator;
    }

    public Serializable createContext() {
        return this.accumulator.createContext();
    }

    public void init(Object workingMemoryContext, Object context, Tuple leftTuple, WorkingMemory workingMemory) {
        try {
            this.accumulator.init(workingMemoryContext, context, leftTuple, this.requiredDeclarations, workingMemory);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException(e);
        }
    }

    public void accumulate(Object workingMemoryContext, Object context, Tuple leftTuple, InternalFactHandle handle, WorkingMemory workingMemory) {
        try {
            this.accumulator.accumulate(workingMemoryContext, context, leftTuple, handle, this.requiredDeclarations, this.innerDeclarations, workingMemory);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException(e);
        }
    }

    public void reverse(Object workingMemoryContext, Object context, Tuple leftTuple, InternalFactHandle handle, WorkingMemory workingMemory) {
        try {
            this.accumulator.reverse(workingMemoryContext, context, leftTuple, handle, this.requiredDeclarations, this.innerDeclarations, workingMemory);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException(e);
        }
    }

    public Object getResult(Object workingMemoryContext, Object context, Tuple leftTuple, WorkingMemory workingMemory) {
        try {
            return this.accumulator.getResult(workingMemoryContext, context, leftTuple, this.requiredDeclarations, workingMemory);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException(e);
        }
    }

    public boolean supportsReverse() {
        return this.accumulator.supportsReverse();
    }

    public Object clone() {
        Accumulate clone = new Accumulate(this.source, this.requiredDeclarations, this.innerDeclarations, this.accumulator);
        if (this.cloned == Collections.EMPTY_LIST) {
            this.cloned = new ArrayList<Accumulate>(1);
        }
        this.cloned.add(clone);
        return clone;
    }

    public RuleConditionElement getSource() {
        return this.source;
    }

    public Map getInnerDeclarations() {
        return this.source.getInnerDeclarations();
    }

    public Map getOuterDeclarations() {
        return Collections.EMPTY_MAP;
    }

    public Declaration resolveDeclaration(String identifier) {
        return this.source.getInnerDeclarations().get(identifier);
    }

    public Object createWorkingMemoryContext() {
        return this.accumulator.createWorkingMemoryContext();
    }

    public List getNestedElements() {
        return Collections.singletonList(this.source);
    }

    public boolean isPatternScopeDelimiter() {
        return true;
    }
}

