/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workflow.core.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.drools.workflow.core.Connection;
import org.drools.workflow.core.Node;

public class ConnectionImpl
implements Connection,
Serializable {
    private static final long serialVersionUID = 400L;
    private org.drools.definition.process.Node from;
    private org.drools.definition.process.Node to;
    private String fromType;
    private String toType;
    private Map<String, Object> metaData = new HashMap<String, Object>();

    public ConnectionImpl() {
    }

    public ConnectionImpl(org.drools.definition.process.Node from, String fromType, org.drools.definition.process.Node to, String toType) {
        if (from == null) {
            throw new IllegalArgumentException("From node is null!");
        }
        if (fromType == null) {
            throw new IllegalArgumentException("From type is null!");
        }
        if (to == null) {
            throw new IllegalArgumentException("To node is null!");
        }
        if (toType == null) {
            throw new IllegalArgumentException("To type is null!");
        }
        this.from = from;
        this.fromType = fromType;
        this.to = to;
        this.toType = toType;
        this.connect();
    }

    public void connect() {
        ((Node)this.from).addOutgoingConnection(this.fromType, this);
        ((Node)this.to).addIncomingConnection(this.toType, this);
    }

    public synchronized void terminate() {
        ((Node)this.from).removeOutgoingConnection(this.fromType, this);
        ((Node)this.to).removeIncomingConnection(this.toType, this);
        this.from = null;
        this.fromType = null;
        this.to = null;
        this.toType = null;
    }

    public org.drools.definition.process.Node getFrom() {
        return this.from;
    }

    public org.drools.definition.process.Node getTo() {
        return this.to;
    }

    public String getFromType() {
        return this.fromType;
    }

    public String getToType() {
        return this.toType;
    }

    public void setFrom(org.drools.definition.process.Node from) {
        this.from = from;
    }

    public void setTo(org.drools.definition.process.Node to) {
        this.to = to;
    }

    public void setFromType(String fromType) {
        this.fromType = fromType;
    }

    public void setToType(String toType) {
        this.toType = toType;
    }

    public void setMetaData(String name, Object value) {
        this.metaData.put(name, value);
    }

    public Object getMetaData(String name) {
        return this.metaData.get(name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Connection ");
        sb.append(this.getFrom());
        sb.append(" [type=");
        sb.append(this.getFromType());
        sb.append("]");
        sb.append(" - ");
        sb.append(this.getTo());
        sb.append(" [type=");
        sb.append(this.getToType());
        sb.append("]");
        return sb.toString();
    }
}

