/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.metadata.ChoicePropertyType;
import org.eclipse.birt.report.model.metadata.StructPropertyDefn;
import org.eclipse.birt.report.model.parser.DesignParserException;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;

class RecoverableError {
    RecoverableError() {
    }

    protected static void dealInvalidPropertyValue(ModuleParserHandler handler, PropertyValueException valueException) {
        Object retValue = valueException.getInvalidValue();
        DesignElement element = valueException.getElement();
        String propName = valueException.getPropertyName();
        element.setProperty(propName, retValue);
        if (valueException.getErrorCode().equals("Error.PropertyValueException.CHOICE_NOT_FOUND") && ChoicePropertyType.isDataTypeAny(element.getPropertyDefn(propName).getChoices(), retValue)) {
            return;
        }
        handler.getErrorHandler().semanticWarning(valueException);
    }

    protected static void dealInvalidMemberValue(ModuleParserHandler handler, PropertyValueException valueException, IStructure structre, StructPropertyDefn memberDefn) {
        assert (structre != null);
        Object retValue = valueException.getInvalidValue();
        structre.setProperty(memberDefn, retValue);
        if (valueException.getErrorCode().equals("Error.PropertyValueException.CHOICE_NOT_FOUND") && ChoicePropertyType.isDataTypeAny(memberDefn.getChoices(), retValue)) {
            return;
        }
        handler.getErrorHandler().semanticWarning(valueException);
    }

    protected static void dealUndefinedProperty(ModuleParserHandler handler, DesignParserException exception) {
        handler.getErrorHandler().semanticWarning(exception);
    }

    protected static void dealMissingInvalidExtension(ModuleParserHandler handler, SemanticError exception) {
        handler.getErrorHandler().semanticWarning(exception);
    }
}

