/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.databaseaccess;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.databaseaccess.AppendCallCustomParameter;
import org.eclipse.persistence.internal.databaseaccess.BatchWritingMechanism;
import org.eclipse.persistence.internal.databaseaccess.BindCallCustomParameter;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.JavaPlatform;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;
import org.eclipse.persistence.platform.database.converters.StructConverter;
import org.eclipse.persistence.platform.database.partitioning.DataPartitioningCallback;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sequencing.TableSequence;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class DatabasePlatform
extends DatasourcePlatform {
    protected transient Map<Class, FieldTypeDefinition> fieldTypes;
    protected boolean usesNativeSQL;
    protected boolean usesByteArrayBinding;
    protected boolean usesBatchWriting;
    protected boolean shouldBindAllParameters;
    protected boolean shouldCacheAllStatements;
    protected int statementCacheSize;
    protected boolean shouldForceFieldNamesToUpperCase;
    protected boolean shouldTrimStrings;
    protected boolean usesStreamsForBinding;
    protected int stringBindingSize;
    protected boolean usesStringBinding;
    protected int maxBatchWritingSize;
    protected int castSizeForVarcharParameter;
    protected boolean usesJDBCBatchWriting;
    protected boolean usesNativeBatchWriting;
    protected BatchWritingMechanism batchWritingMechanism;
    protected Boolean printOuterJoinInWhereClause;
    protected Boolean printInnerJoinInWhereClause;
    protected int cursorCode;
    protected int transactionIsolation;
    protected boolean supportsAutoCommit;
    protected boolean shouldOptimizeDataConversion;
    protected transient Map<String, Class> classTypes;
    protected static boolean shouldIgnoreCaseOnFieldComparisons = false;
    public static int DEFAULT_MAX_BATCH_WRITING_SIZE = 32000;
    public static int DEFAULT_PARAMETERIZED_MAX_BATCH_WRITING_SIZE = 100;
    public static int IS_VALID_TIMEOUT = 0;
    protected String pingSQL;
    protected Map<String, StructConverter> structConverters = null;
    protected Map<Class, StructConverter> typeConverters = null;
    protected boolean useRownumFiltering = true;
    protected boolean isCastRequired = false;
    protected boolean shouldBindLiterals = true;
    public static final int Types_NCLOB = 2011;
    public static final int Types_SQLXML = 2009;
    protected String tableCreationSuffix;
    protected DataPartitioningCallback partitioningCallback;
    protected boolean shouldCreateIndicesOnForeignKeys;
    protected Boolean useJDBCStoredProcedureSyntax;
    protected String driverName;

    public DatabasePlatform() {
        this.tableQualifier = "";
        this.usesNativeSQL = false;
        this.usesByteArrayBinding = true;
        this.usesStringBinding = false;
        this.stringBindingSize = 255;
        this.shouldTrimStrings = true;
        this.shouldBindAllParameters = true;
        this.shouldCacheAllStatements = false;
        this.shouldOptimizeDataConversion = true;
        this.statementCacheSize = 50;
        this.shouldForceFieldNamesToUpperCase = false;
        this.maxBatchWritingSize = 0;
        this.usesJDBCBatchWriting = true;
        this.transactionIsolation = -1;
        this.cursorCode = -10;
        this.supportsAutoCommit = true;
        this.usesNativeBatchWriting = false;
        this.castSizeForVarcharParameter = 32672;
        this.startDelimiter = "\"";
        this.endDelimiter = "\"";
        this.useJDBCStoredProcedureSyntax = null;
    }

    @Override
    public void initialize() {
        this.getPlatformOperators();
    }

    public boolean hasPartitioningCallback() {
        return this.partitioningCallback != null;
    }

    public DataPartitioningCallback getPartitioningCallback() {
        return this.partitioningCallback;
    }

    public void setPartitioningCallback(DataPartitioningCallback partitioningCallback) {
        this.partitioningCallback = partitioningCallback;
    }

    public boolean isCastRequired() {
        return this.isCastRequired;
    }

    public void setIsCastRequired(boolean isCastRequired) {
        this.isCastRequired = isCastRequired;
    }

    public Map<String, StructConverter> getStructConverters() {
        return this.structConverters;
    }

    public String getTableCreationSuffix() {
        return this.tableCreationSuffix;
    }

    public Map<Class, StructConverter> getTypeConverters() {
        if (this.typeConverters == null) {
            this.typeConverters = new HashMap<Class, StructConverter>();
        }
        return this.typeConverters;
    }

    public void addStructConverter(StructConverter converter) {
        if (this.structConverters == null) {
            this.structConverters = new HashMap<String, StructConverter>();
        }
        if (this.typeConverters == null) {
            this.typeConverters = new HashMap<Class, StructConverter>();
        }
        this.structConverters.put(converter.getStructName(), converter);
        this.typeConverters.put(converter.getJavaType(), converter);
    }

    public int addBatch(PreparedStatement statement) throws SQLException {
        statement.addBatch();
        return 0;
    }

    public boolean allowsSizeInProcedureArguments() {
        return true;
    }

    protected void appendBoolean(Boolean bool, Writer writer) throws IOException {
        if (bool.booleanValue()) {
            writer.write("1");
        } else {
            writer.write("0");
        }
    }

    protected void appendByteArray(byte[] bytes, Writer writer) throws IOException {
        writer.write("{b '");
        Helper.writeHexString(bytes, writer);
        writer.write("'}");
    }

    protected void appendDate(Date date, Writer writer) throws IOException {
        writer.write("{d '");
        writer.write(Helper.printDate(date));
        writer.write("'}");
    }

    protected void appendNumber(Number number, Writer writer) throws IOException {
        writer.write(number.toString());
    }

    public void appendLiteralToCall(Call call, Writer writer, Object literal) {
        if (this.shouldBindLiterals()) {
            this.appendLiteralToCallWithBinding(call, writer, literal);
        } else {
            int nParametersToAdd = this.appendParameterInternal(call, writer, literal);
            int i = 0;
            while (i < nParametersToAdd) {
                ((DatabaseCall)call).getParameterTypes().add(DatabaseCall.LITERAL);
                ++i;
            }
        }
    }

    protected void appendLiteralToCallWithBinding(Call call, Writer writer, Object literal) {
        ((DatabaseCall)call).appendLiteral(writer, literal);
    }

    @Override
    public void appendParameter(Call call, Writer writer, Object parameter) {
        this.appendParameterInternal(call, writer, parameter);
    }

    public int appendParameterInternal(Call call, Writer writer, Object parameter) {
        int nBoundParameters = 0;
        DatabaseCall databaseCall = (DatabaseCall)call;
        try {
            if (parameter instanceof Calendar) {
                this.appendCalendar((Calendar)parameter, writer);
                return nBoundParameters;
            }
            Object dbValue = this.convertToDatabaseType(parameter);
            if (dbValue instanceof String) {
                if (this.usesStringBinding() && ((String)dbValue).length() >= this.getStringBindingSize()) {
                    databaseCall.bindParameter(writer, dbValue);
                    nBoundParameters = 1;
                } else {
                    this.appendString((String)dbValue, writer);
                }
            } else if (dbValue instanceof Number) {
                this.appendNumber((Number)dbValue, writer);
            } else if (dbValue instanceof Time) {
                this.appendTime((Time)dbValue, writer);
            } else if (dbValue instanceof Timestamp) {
                this.appendTimestamp((Timestamp)dbValue, writer);
            } else if (dbValue instanceof Date) {
                this.appendDate((Date)dbValue, writer);
            } else if (dbValue == null) {
                writer.write("NULL");
            } else if (dbValue instanceof Boolean) {
                this.appendBoolean((Boolean)dbValue, writer);
            } else if (dbValue instanceof byte[]) {
                if (this.usesByteArrayBinding()) {
                    databaseCall.bindParameter(writer, dbValue);
                    nBoundParameters = 1;
                } else {
                    this.appendByteArray((byte[])dbValue, writer);
                }
            } else if (dbValue instanceof Collection) {
                nBoundParameters = this.printValuelist((Collection)dbValue, databaseCall, writer);
            } else if (this.typeConverters != null && this.typeConverters.containsKey(dbValue.getClass())) {
                dbValue = new BindCallCustomParameter(dbValue);
                databaseCall.bindParameter(writer, dbValue);
            } else if (parameter instanceof Struct || parameter instanceof Array || parameter instanceof Ref) {
                databaseCall.bindParameter(writer, parameter);
                nBoundParameters = 1;
            } else if (dbValue.getClass() == int[].class) {
                nBoundParameters = this.printValuelist((int[])dbValue, databaseCall, writer);
            } else if (dbValue instanceof AppendCallCustomParameter) {
                ((AppendCallCustomParameter)dbValue).append(writer);
                nBoundParameters = 1;
            } else if (dbValue instanceof BindCallCustomParameter) {
                databaseCall.bindParameter(writer, dbValue);
                nBoundParameters = 1;
            } else {
                writer.write(dbValue.toString());
            }
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        return nBoundParameters;
    }

    protected void appendString(String string, Writer writer) throws IOException {
        writer.write(39);
        int position = 0;
        while (position < string.length()) {
            if (string.charAt(position) == '\'') {
                writer.write("''");
            } else {
                writer.write(string.charAt(position));
            }
            ++position;
        }
        writer.write(39);
    }

    protected void appendTime(Time time, Writer writer) throws IOException {
        writer.write("{t '");
        writer.write(Helper.printTime(time));
        writer.write("'}");
    }

    protected void appendTimestamp(Timestamp timestamp, Writer writer) throws IOException {
        writer.write("{ts '");
        writer.write(Helper.printTimestamp(timestamp));
        writer.write("'}");
    }

    protected void appendCalendar(Calendar calendar, Writer writer) throws IOException {
        writer.write("{ts '");
        writer.write(Helper.printCalendar(calendar));
        writer.write("'}");
    }

    public void autoCommit(DatabaseAccessor accessor) throws SQLException {
        if (!this.supportsAutoCommit()) {
            accessor.getConnection().commit();
        }
    }

    public void beginTransaction(DatabaseAccessor accessor) throws SQLException {
        if (!this.supportsAutoCommit()) {
            Statement statement = accessor.getConnection().createStatement();
            try {
                statement.executeUpdate("BEGIN TRANSACTION");
            }
            finally {
                statement.close();
            }
        }
    }

    public Expression buildBatchCriteria(ExpressionBuilder builder, Expression field) {
        return field.in(builder.getParameter("query-batch-parameter"));
    }

    public Expression buildBatchCriteriaForComplexId(ExpressionBuilder builder, List<Expression> fields) {
        return builder.value(fields).in(builder.getParameter("query-batch-parameter"));
    }

    public DatabaseCall buildCallWithReturning(SQLCall sqlCall, Vector returnFields) {
        throw ValidationException.platformDoesNotSupportCallWithReturning(Helper.getShortClassName(this));
    }

    protected Map<String, Class> buildClassTypes() {
        HashMap<String, Class> classTypeMapping = new HashMap<String, Class>();
        classTypeMapping.put("NUMBER", BigInteger.class);
        classTypeMapping.put("DECIMAL", BigDecimal.class);
        classTypeMapping.put("INTEGER", Integer.class);
        classTypeMapping.put("INT", Integer.class);
        classTypeMapping.put("NUMERIC", BigInteger.class);
        classTypeMapping.put("FLOAT(16)", Float.class);
        classTypeMapping.put("FLOAT(32)", Double.class);
        classTypeMapping.put("NUMBER(1) default 0", Boolean.class);
        classTypeMapping.put("SHORT", Short.class);
        classTypeMapping.put("BYTE", Byte.class);
        classTypeMapping.put("DOUBLE", Double.class);
        classTypeMapping.put("FLOAT", Float.class);
        classTypeMapping.put("SMALLINT", Short.class);
        classTypeMapping.put("BIT", Boolean.class);
        classTypeMapping.put("SMALLINT DEFAULT 0", Boolean.class);
        classTypeMapping.put("VARCHAR", String.class);
        classTypeMapping.put("CHAR", Character.class);
        classTypeMapping.put("LONGVARBINARY", Byte[].class);
        classTypeMapping.put("TEXT", Character[].class);
        classTypeMapping.put("LONGTEXT", Character[].class);
        classTypeMapping.put("MEMO", Character[].class);
        classTypeMapping.put("VARCHAR2", String.class);
        classTypeMapping.put("LONG RAW", Byte[].class);
        classTypeMapping.put("LONG", Character[].class);
        classTypeMapping.put("DATE", Date.class);
        classTypeMapping.put("TIMESTAMP", Timestamp.class);
        classTypeMapping.put("TIME", Time.class);
        classTypeMapping.put("DATETIME", Timestamp.class);
        classTypeMapping.put("BIGINT", BigInteger.class);
        classTypeMapping.put("DOUBLE PRECIS", Double.class);
        classTypeMapping.put("IMAGE", Byte[].class);
        classTypeMapping.put("LONGVARCHAR", Character[].class);
        classTypeMapping.put("REAL", Float.class);
        classTypeMapping.put("TINYINT", Short.class);
        classTypeMapping.put("BLOB", Byte[].class);
        classTypeMapping.put("CLOB", Character[].class);
        return classTypeMapping;
    }

    protected Hashtable buildFieldTypes() {
        Hashtable<Class<Number>, FieldTypeDefinition> fieldTypeMapping = new Hashtable<Class<Number>, FieldTypeDefinition>();
        fieldTypeMapping.put(Boolean.class, new FieldTypeDefinition("NUMBER", 1));
        fieldTypeMapping.put(Integer.class, new FieldTypeDefinition("NUMBER", 10));
        fieldTypeMapping.put(Long.class, new FieldTypeDefinition("NUMBER", 19));
        fieldTypeMapping.put(Float.class, new FieldTypeDefinition("NUMBER", 12, 5).setLimits(19, 0, 19));
        fieldTypeMapping.put(Double.class, new FieldTypeDefinition("NUMBER", 10, 5).setLimits(19, 0, 19));
        fieldTypeMapping.put(Short.class, new FieldTypeDefinition("NUMBER", 5));
        fieldTypeMapping.put(Byte.class, new FieldTypeDefinition("NUMBER", 3));
        fieldTypeMapping.put(BigInteger.class, new FieldTypeDefinition("NUMBER", 19));
        fieldTypeMapping.put(BigDecimal.class, new FieldTypeDefinition("NUMBER", 19, 0).setLimits(19, 0, 19));
        fieldTypeMapping.put(String.class, new FieldTypeDefinition("VARCHAR"));
        fieldTypeMapping.put(Character.class, new FieldTypeDefinition("CHAR"));
        fieldTypeMapping.put(Byte[].class, new FieldTypeDefinition("BLOB"));
        fieldTypeMapping.put(Character[].class, new FieldTypeDefinition("CLOB"));
        fieldTypeMapping.put(byte[].class, new FieldTypeDefinition("BLOB"));
        fieldTypeMapping.put(char[].class, new FieldTypeDefinition("CLOB"));
        fieldTypeMapping.put(Blob.class, new FieldTypeDefinition("BLOB"));
        fieldTypeMapping.put(Clob.class, new FieldTypeDefinition("CLOB"));
        fieldTypeMapping.put(Date.class, new FieldTypeDefinition("DATE"));
        fieldTypeMapping.put(Timestamp.class, new FieldTypeDefinition("TIMESTAMP"));
        fieldTypeMapping.put(Time.class, new FieldTypeDefinition("TIME"));
        fieldTypeMapping.put(Calendar.class, new FieldTypeDefinition("TIMESTAMP"));
        fieldTypeMapping.put(java.util.Date.class, new FieldTypeDefinition("TIMESTAMP"));
        fieldTypeMapping.put(Number.class, new FieldTypeDefinition("NUMBER", 10));
        return fieldTypeMapping;
    }

    public String buildProcedureCallString(StoredProcedureCall call, AbstractSession session, AbstractRecord row) {
        StringWriter writer = new StringWriter();
        writer.write(call.getCallHeader(this));
        writer.write(call.getProcedureName());
        if (this.requiresProcedureCallBrackets()) {
            writer.write("(");
        } else {
            writer.write(" ");
        }
        int indexFirst = call.getFirstParameterIndexForCallString();
        int size = call.getParameters().size();
        int index = indexFirst;
        while (index < size) {
            String name = call.getProcedureArgumentNames().get(index);
            Object parameter = call.getParameters().get(index);
            Integer parameterType = call.getParameterTypes().get(index);
            if (!call.hasOptionalArguments() || !call.getOptionalArguments().contains(parameter) || row.get(parameter) != null) {
                if (name != null && this.shouldPrintStoredProcedureArgumentNameInCall()) {
                    writer.write(this.getProcedureArgumentString());
                    writer.write(name);
                    writer.write(this.getProcedureArgumentSetter());
                }
                writer.write("?");
                if (call.isOutputParameterType(parameterType) && this.requiresProcedureCallOuputToken()) {
                    writer.write(" ");
                    writer.write(this.getOutputProcedureToken());
                }
                if (index + 1 < call.getParameters().size()) {
                    writer.write(", ");
                }
            }
            ++index;
        }
        if (this.requiresProcedureCallBrackets()) {
            writer.write(")");
        }
        writer.write(this.getProcedureCallTail());
        return writer.toString();
    }

    public boolean canBuildCallWithReturning() {
        return false;
    }

    public boolean canBatchWriteWithOptimisticLocking(DatabaseCall call) {
        if (this.batchWritingMechanism != null) {
            return true;
        }
        return true;
    }

    public int computeMaxRowsForSQL(int firstResultIndex, int maxResults) {
        return maxResults;
    }

    public void commitTransaction(DatabaseAccessor accessor) throws SQLException {
        if (!this.supportsAutoCommit()) {
            accessor.getConnection().commit();
        }
    }

    public DatabaseQuery getVPDClearIdentifierQuery(String vpdIdentifier) {
        return null;
    }

    public String getVPDCreationFunctionString(String tableName, String tenantFieldName) {
        return null;
    }

    public String getVPDCreationPolicyString(String tableName, AbstractSession session) {
        return null;
    }

    public String getVPDDeletionString(String tableName, AbstractSession session) {
        return null;
    }

    public DatabaseQuery getVPDSetIdentifierQuery(String vpdIdentifier) {
        return null;
    }

    public Object convertToDatabaseType(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass() == ClassConstants.UTILDATE) {
            return Helper.timestampFromDate((java.util.Date)value);
        }
        if (value instanceof Character) {
            return ((Character)value).toString();
        }
        if (value instanceof Calendar) {
            return Helper.timestampFromDate(((Calendar)value).getTime());
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        if (value instanceof char[]) {
            return new String((char[])value);
        }
        if (value instanceof Character[]) {
            return this.convertObject(value, ClassConstants.STRING);
        }
        if (value instanceof Byte[]) {
            return this.convertObject(value, ClassConstants.APBYTE);
        }
        return value;
    }

    @Override
    public void copyInto(Platform platform) {
        super.copyInto(platform);
        if (!(platform instanceof DatabasePlatform)) {
            return;
        }
        DatabasePlatform databasePlatform = (DatabasePlatform)platform;
        databasePlatform.setShouldTrimStrings(this.shouldTrimStrings());
        databasePlatform.setUsesNativeSQL(this.usesNativeSQL());
        databasePlatform.setUsesByteArrayBinding(this.usesByteArrayBinding());
        databasePlatform.setUsesStringBinding(this.usesStringBinding());
        databasePlatform.setShouldBindAllParameters(this.shouldBindAllParameters());
        databasePlatform.setShouldCacheAllStatements(this.shouldCacheAllStatements());
        databasePlatform.setStatementCacheSize(this.getStatementCacheSize());
        databasePlatform.setTransactionIsolation(this.getTransactionIsolation());
        databasePlatform.setBatchWritingMechanism(this.getBatchWritingMechanism());
        databasePlatform.setMaxBatchWritingSize(this.getMaxBatchWritingSize());
        databasePlatform.setShouldForceFieldNamesToUpperCase(this.shouldForceFieldNamesToUpperCase());
        databasePlatform.setShouldOptimizeDataConversion(this.shouldOptimizeDataConversion());
        databasePlatform.setStringBindingSize(this.getStringBindingSize());
        databasePlatform.setUsesBatchWriting(this.usesBatchWriting());
        databasePlatform.setUsesJDBCBatchWriting(this.usesJDBCBatchWriting());
        databasePlatform.setUsesNativeBatchWriting(this.usesNativeBatchWriting());
        databasePlatform.setUsesStreamsForBinding(this.usesStreamsForBinding());
        databasePlatform.shouldCreateIndicesOnForeignKeys = this.shouldCreateIndicesOnForeignKeys;
        databasePlatform.printOuterJoinInWhereClause = this.printOuterJoinInWhereClause;
        databasePlatform.printInnerJoinInWhereClause = this.printInnerJoinInWhereClause;
        databasePlatform.setTableCreationSuffix(this.tableCreationSuffix);
    }

    public String getBatchBeginString() {
        return "";
    }

    public boolean isRowCountOutputParameterRequired() {
        return false;
    }

    public String getBatchRowCountDeclareString() {
        return "";
    }

    public String getBatchRowCountAssignString() {
        return "";
    }

    public String getBatchRowCountReturnString() {
        return "";
    }

    public String getBatchDelimiterString() {
        return "; ";
    }

    public String getBatchEndString() {
        return "";
    }

    public Connection getConnection(AbstractSession session, Connection connection) {
        return connection;
    }

    public String getConstraintDeletionString() {
        return " DROP CONSTRAINT ";
    }

    public String getCreateViewString() {
        return "CREATE VIEW ";
    }

    public String getDropCascadeString() {
        return "";
    }

    @Override
    public Object getCustomModifyValueForCall(Call call, Object value, DatabaseField field, boolean shouldBind) {
        StructConverter converter;
        if (this.typeConverters != null && (converter = this.typeConverters.get(field.getType())) != null) {
            Object bindValue = value;
            if (bindValue == null) {
                bindValue = new ObjectRelationalDatabaseField(field);
                ((ObjectRelationalDatabaseField)bindValue).setSqlType(2002);
                ((ObjectRelationalDatabaseField)bindValue).setSqlTypeName(converter.getStructName());
            }
            return new BindCallCustomParameter(bindValue);
        }
        return super.getCustomModifyValueForCall(call, value, field, shouldBind);
    }

    public String getProcedureEndString() {
        return this.getBatchEndString();
    }

    public String getProcedureBeginString() {
        return this.getBatchBeginString();
    }

    public String getProcedureAsString() {
        return " AS";
    }

    public Map<String, Class> getClassTypes() {
        if (this.classTypes == null) {
            this.classTypes = this.buildClassTypes();
        }
        return this.classTypes;
    }

    public String getAssignmentString() {
        return "= ";
    }

    public int getCastSizeForVarcharParameter() {
        return this.castSizeForVarcharParameter;
    }

    public String getCreationInOutputProcedureToken() {
        return this.getInOutputProcedureToken();
    }

    public String getCreationOutputProcedureToken() {
        return this.getOutputProcedureToken();
    }

    public int getCursorCode() {
        return this.cursorCode;
    }

    public String getDefaultSequenceTableName() {
        return "SEQUENCE";
    }

    public String getCreateDatabaseSchemaString(String schema) {
        return "CREATE SCHEMA " + schema;
    }

    public String getDropDatabaseSchemaString(String schema) {
        return "DROP SCHEMA " + schema;
    }

    public FieldTypeDefinition getFieldTypeDefinition(Class javaClass) {
        return this.getFieldTypes().get(javaClass);
    }

    public Map<Class, FieldTypeDefinition> getFieldTypes() {
        if (this.fieldTypes == null) {
            this.fieldTypes = this.buildFieldTypes();
        }
        return this.fieldTypes;
    }

    public String getFunctionCallHeader() {
        return String.valueOf(this.getProcedureCallHeader()) + "? " + this.getAssignmentString();
    }

    @Override
    public String getIdentifierQuoteCharacter() {
        return "\"";
    }

    public String getInOutputProcedureToken() {
        return "IN OUT";
    }

    public String getJDBCOuterJoinString() {
        return "{oj ";
    }

    public int getJDBCTypeForSetNull(DatabaseField field) {
        return this.getJDBCType(field);
    }

    public int getJDBCType(DatabaseField field) {
        if (field != null) {
            if (field.getSqlType() != Integer.MIN_VALUE) {
                return field.getSqlType();
            }
            return this.getJDBCType(ConversionManager.getObjectClass(field.getType()));
        }
        return this.getJDBCType((Class)null);
    }

    public int getJDBCType(Class javaType) {
        if (javaType == null) {
            return 12;
        }
        if (javaType == ClassConstants.STRING) {
            return 12;
        }
        if (javaType == ClassConstants.BIGDECIMAL) {
            return 3;
        }
        if (javaType == ClassConstants.BIGINTEGER) {
            return -5;
        }
        if (javaType == ClassConstants.BOOLEAN) {
            return -7;
        }
        if (javaType == ClassConstants.BYTE) {
            return -6;
        }
        if (javaType == ClassConstants.CHAR) {
            return 1;
        }
        if (javaType == ClassConstants.DOUBLE) {
            return 8;
        }
        if (javaType == ClassConstants.FLOAT) {
            return 6;
        }
        if (javaType == ClassConstants.INTEGER) {
            return 4;
        }
        if (javaType == ClassConstants.LONG) {
            return 4;
        }
        if (javaType == ClassConstants.NUMBER) {
            return 3;
        }
        if (javaType == ClassConstants.SHORT) {
            return 5;
        }
        if (javaType == ClassConstants.CALENDAR) {
            return 93;
        }
        if (javaType == ClassConstants.UTILDATE) {
            return 93;
        }
        if (javaType == ClassConstants.TIME) {
            return 92;
        }
        if (javaType == ClassConstants.SQLDATE) {
            return 91;
        }
        if (javaType == ClassConstants.TIMESTAMP || javaType == ClassConstants.UTILDATE) {
            return 93;
        }
        if (javaType == ClassConstants.ABYTE) {
            return -4;
        }
        if (javaType == ClassConstants.APBYTE) {
            return -4;
        }
        if (javaType == ClassConstants.BLOB) {
            return 2004;
        }
        if (javaType == ClassConstants.ACHAR) {
            return -1;
        }
        if (javaType == ClassConstants.APCHAR) {
            return -1;
        }
        if (javaType == ClassConstants.CLOB) {
            return 2005;
        }
        return 12;
    }

    public String getJdbcTypeName(int jdbcType) {
        return null;
    }

    public long minimumTimeIncrement() {
        return 1L;
    }

    public int getMaxBatchWritingSize() {
        return this.maxBatchWritingSize;
    }

    public int getMaxFieldNameSize() {
        return 50;
    }

    public int getMaxForeignKeyNameSize() {
        return this.getMaxFieldNameSize();
    }

    public int getMaxIndexNameSize() {
        return this.getMaxFieldNameSize();
    }

    public int getMaxUniqueKeyNameSize() {
        return this.getMaxFieldNameSize();
    }

    public Object getObjectFromResultSet(ResultSet resultSet, int columnNumber, int type, AbstractSession session) throws SQLException {
        Object objectFromResultSet = resultSet.getObject(columnNumber);
        if (objectFromResultSet != null) {
            if (this.structConverters != null && type == 2002) {
                String structType = ((Struct)objectFromResultSet).getSQLTypeName();
                if (this.getStructConverters().containsKey(structType)) {
                    return this.getStructConverters().get(structType).convertToObject((Struct)objectFromResultSet);
                }
            } else if (type == 2009) {
                return JavaPlatform.getStringAndFreeSQLXML(objectFromResultSet);
            }
        }
        return objectFromResultSet;
    }

    public String getInputProcedureToken() {
        return "";
    }

    public String getIndexNamePrefix(boolean isUniqueSetOnField) {
        return "IX_";
    }

    public String getOutputProcedureToken() {
        return "OUT";
    }

    public String getPingSQL() {
        return this.pingSQL;
    }

    public String getProcedureArgumentSetter() {
        return " = ";
    }

    public String getProcedureArgumentString() {
        return "";
    }

    public String getProcedureCallHeader() {
        return "EXECUTE PROCEDURE ";
    }

    public String getProcedureCallTail() {
        return "";
    }

    public String getQualifiedSequenceTableName() {
        if (this.getDefaultSequence() instanceof TableSequence) {
            return this.getQualifiedName(((TableSequence)this.getDefaultSequence()).getTableName());
        }
        throw ValidationException.wrongSequenceType(Helper.getShortClassName(this.getDefaultSequence()), "getTableName");
    }

    public String getQualifiedName(String name) {
        if (this.getTableQualifier().equals("")) {
            return name;
        }
        return String.valueOf(this.getTableQualifier()) + "." + name;
    }

    public String getNoWaitString() {
        return " NOWAIT";
    }

    public String getSelectForUpdateNoWaitString() {
        return String.valueOf(this.getSelectForUpdateString()) + this.getNoWaitString();
    }

    public String getSelectForUpdateOfString() {
        return " FOR UPDATE OF ";
    }

    public String getSelectForUpdateString() {
        return " FOR UPDATE";
    }

    public String getSelectForUpdateWaitString(Integer waitTimeout) {
        return this.getSelectForUpdateString();
    }

    public String getSequenceCounterFieldName() {
        if (this.getDefaultSequence() instanceof TableSequence) {
            return ((TableSequence)this.getDefaultSequence()).getCounterFieldName();
        }
        throw ValidationException.wrongSequenceType(Helper.getShortClassName(this.getDefaultSequence()), "getCounterFieldName");
    }

    public String getSequenceNameFieldName() {
        if (this.getDefaultSequence() instanceof TableSequence) {
            return ((TableSequence)this.getDefaultSequence()).getNameFieldName();
        }
        throw ValidationException.wrongSequenceType(Helper.getShortClassName(this.getDefaultSequence()), "getNameFieldName");
    }

    @Override
    public int getSequencePreallocationSize() {
        return this.getDefaultSequence().getPreallocationSize();
    }

    public String getSequenceTableName() {
        if (this.getDefaultSequence() instanceof TableSequence) {
            String tableName = ((TableSequence)this.getDefaultSequence()).getTableName();
            if (tableName.length() == 0) {
                tableName = this.getDefaultSequenceTableName();
            }
            return tableName;
        }
        throw ValidationException.wrongSequenceType(Helper.getShortClassName(this.getDefaultSequence()), "getTableName");
    }

    public int getStatementCacheSize() {
        return this.statementCacheSize;
    }

    public String getStoredProcedureParameterPrefix() {
        return "";
    }

    public String getStoredProcedureTerminationToken() {
        return ";";
    }

    public int getStringBindingSize() {
        return this.stringBindingSize;
    }

    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public boolean isInformixOuterJoin() {
        return false;
    }

    public boolean isJDBCExecuteCompliant() {
        return true;
    }

    public boolean isLockTimeoutException(DatabaseException e) {
        return false;
    }

    public boolean isForUpdateCompatibleWithDistinct() {
        return true;
    }

    public Hashtable maximumNumericValues() {
        Hashtable<Class, Number> values = new Hashtable<Class, Number>();
        values.put(Integer.class, Integer.MAX_VALUE);
        values.put(Long.class, Long.MAX_VALUE);
        values.put(Double.class, Double.MAX_VALUE);
        values.put(Short.class, (short)Short.MAX_VALUE);
        values.put(Byte.class, (byte)127);
        values.put(Float.class, Float.valueOf(Float.MAX_VALUE));
        values.put(BigInteger.class, new BigInteger("999999999999999999999999999999999999999"));
        values.put(BigDecimal.class, new BigDecimal("99999999999999999999.9999999999999999999"));
        return values;
    }

    public Hashtable minimumNumericValues() {
        Hashtable<Class, Number> values = new Hashtable<Class, Number>();
        values.put(Integer.class, Integer.MIN_VALUE);
        values.put(Long.class, Long.MIN_VALUE);
        values.put(Double.class, Double.MIN_VALUE);
        values.put(Short.class, (short)Short.MIN_VALUE);
        values.put(Byte.class, (byte)-128);
        values.put(Float.class, Float.valueOf(Float.MIN_VALUE));
        values.put(BigInteger.class, new BigInteger("-99999999999999999999999999999999999999"));
        values.put(BigDecimal.class, new BigDecimal("-9999999999999999999.9999999999999999999"));
        return values;
    }

    public Statement prepareBatchStatement(Statement statement, int maxBatchWritingSize) throws SQLException {
        return statement;
    }

    public void printFieldIdentityClause(Writer writer) throws ValidationException {
    }

    public void printFieldNotNullClause(Writer writer) throws ValidationException {
        try {
            writer.write(" NOT NULL");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    public void printFieldNullClause(Writer writer) throws ValidationException {
    }

    public int printValuelist(int[] theObjects, DatabaseCall call, Writer writer) throws IOException {
        int nBoundParameters = 0;
        writer.write("(");
        int i = 0;
        while (i < theObjects.length) {
            nBoundParameters += this.appendParameterInternal(call, writer, theObjects[i]);
            if (i < theObjects.length - 1) {
                writer.write(", ");
            }
            ++i;
        }
        writer.write(")");
        return nBoundParameters;
    }

    public int printValuelist(Collection theObjects, DatabaseCall call, Writer writer) throws IOException {
        int nBoundParameters = 0;
        writer.write("(");
        Iterator iterator = theObjects.iterator();
        while (iterator.hasNext()) {
            nBoundParameters += this.appendParameterInternal(call, writer, iterator.next());
            if (!iterator.hasNext()) continue;
            writer.write(", ");
        }
        writer.write(")");
        return nBoundParameters;
    }

    public void registerOutputParameter(CallableStatement statement, int index, int jdbcType) throws SQLException {
        statement.registerOutParameter(index, jdbcType);
    }

    public boolean requiresNamedPrimaryKeyConstraints() {
        return false;
    }

    public boolean requiresProcedureBrackets() {
        return false;
    }

    public boolean requiresProcedureCallBrackets() {
        return true;
    }

    public boolean requiresProcedureCallOuputToken() {
        return false;
    }

    public boolean requiresTypeNameToRegisterOutputParameter() {
        return false;
    }

    public boolean requiresUniqueConstraintCreationOnTableCreate() {
        return false;
    }

    public void retrieveFirstPrimaryKeyOrOne(ReportQuery subselect) {
        subselect.setShouldRetrieveFirstPrimaryKey(true);
    }

    public void rollbackTransaction(DatabaseAccessor accessor) throws SQLException {
        if (!this.supportsAutoCommit()) {
            accessor.getConnection().rollback();
        }
    }

    public void setCastSizeForVarcharParameter(int maxLength) {
        this.castSizeForVarcharParameter = maxLength;
    }

    protected void setClassTypes(Hashtable classTypes) {
        this.classTypes = classTypes;
    }

    public void setCursorCode(int cursorCode) {
        this.cursorCode = cursorCode;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    protected void setFieldTypes(Hashtable theFieldTypes) {
        this.fieldTypes = theFieldTypes;
    }

    public void setMaxBatchWritingSize(int maxBatchWritingSize) {
        this.maxBatchWritingSize = maxBatchWritingSize;
    }

    public void setSequenceCounterFieldName(String name) {
        if (this.getDefaultSequence() instanceof TableSequence) {
            ((TableSequence)this.getDefaultSequence()).setCounterFieldName(name);
        } else if (!name.equals(new TableSequence().getCounterFieldName())) {
            ValidationException.wrongSequenceType(Helper.getShortClassName(this.getDefaultSequence()), "setCounterFieldName");
        }
    }

    public void setSequenceNameFieldName(String name) {
        if (this.getDefaultSequence() instanceof TableSequence) {
            ((TableSequence)this.getDefaultSequence()).setNameFieldName(name);
        } else if (!name.equals(new TableSequence().getNameFieldName())) {
            throw ValidationException.wrongSequenceType(Helper.getShortClassName(this.getDefaultSequence()), "setNameFieldName");
        }
    }

    public void setSequenceTableName(String name) {
        if (this.getDefaultSequence() instanceof TableSequence) {
            ((TableSequence)this.getDefaultSequence()).setTableName(name);
        } else if (!name.equals(new TableSequence().getTableName())) {
            throw ValidationException.wrongSequenceType(Helper.getShortClassName(this.getDefaultSequence()), "setTableName");
        }
    }

    public void setShouldBindAllParameters(boolean shouldBindAllParameters) {
        this.shouldBindAllParameters = shouldBindAllParameters;
    }

    public void setShouldCacheAllStatements(boolean shouldCacheAllStatements) {
        this.shouldCacheAllStatements = shouldCacheAllStatements;
    }

    public void setShouldForceFieldNamesToUpperCase(boolean shouldForceFieldNamesToUpperCase) {
        this.shouldForceFieldNamesToUpperCase = shouldForceFieldNamesToUpperCase;
    }

    public static void setShouldIgnoreCaseOnFieldComparisons(boolean newShouldIgnoreCaseOnFieldComparisons) {
        shouldIgnoreCaseOnFieldComparisons = newShouldIgnoreCaseOnFieldComparisons;
    }

    public void setShouldOptimizeDataConversion(boolean value) {
        this.shouldOptimizeDataConversion = value;
    }

    public void setShouldTrimStrings(boolean aBoolean) {
        this.shouldTrimStrings = aBoolean;
    }

    public void setStatementCacheSize(int statementCacheSize) {
        this.statementCacheSize = statementCacheSize;
    }

    public void setStringBindingSize(int aSize) {
        this.stringBindingSize = aSize;
    }

    public void setSupportsAutoCommit(boolean supportsAutoCommit) {
        this.supportsAutoCommit = supportsAutoCommit;
    }

    public void setTableCreationSuffix(String tableCreationSuffix) {
        this.tableCreationSuffix = tableCreationSuffix;
    }

    public void setTransactionIsolation(int isolationLevel) {
        this.transactionIsolation = isolationLevel;
    }

    public void setUseJDBCStoredProcedureSyntax(Boolean useJDBCStoredProcedureSyntax) {
        this.useJDBCStoredProcedureSyntax = useJDBCStoredProcedureSyntax;
    }

    public void setUsesBatchWriting(boolean usesBatchWriting) {
        this.usesBatchWriting = usesBatchWriting;
    }

    public void setUsesByteArrayBinding(boolean usesByteArrayBinding) {
        this.usesByteArrayBinding = usesByteArrayBinding;
    }

    public void setUsesJDBCBatchWriting(boolean usesJDBCBatchWriting) {
        this.usesJDBCBatchWriting = usesJDBCBatchWriting;
    }

    public void setUsesNativeBatchWriting(boolean usesNativeBatchWriting) {
        this.usesNativeBatchWriting = usesNativeBatchWriting;
    }

    public void setUsesNativeSQL(boolean usesNativeSQL) {
        this.usesNativeSQL = usesNativeSQL;
    }

    public BatchWritingMechanism getBatchWritingMechanism() {
        return this.batchWritingMechanism;
    }

    public void setBatchWritingMechanism(BatchWritingMechanism batchWritingMechanism) {
        this.batchWritingMechanism = batchWritingMechanism;
    }

    public void setShouldUseRownumFiltering(boolean useRownumFiltering) {
        this.useRownumFiltering = useRownumFiltering;
    }

    public void setUsesStreamsForBinding(boolean usesStreamsForBinding) {
        this.usesStreamsForBinding = usesStreamsForBinding;
    }

    public void setPrintOuterJoinInWhereClause(boolean printOuterJoinInWhereClause) {
        this.printOuterJoinInWhereClause = printOuterJoinInWhereClause;
    }

    public void setPrintInnerJoinInWhereClause(boolean printInnerJoinInWhereClause) {
        this.printInnerJoinInWhereClause = printInnerJoinInWhereClause;
    }

    public void setUsesStringBinding(boolean aBool) {
        this.usesStringBinding = aBool;
    }

    public boolean shouldBindAllParameters() {
        return this.shouldBindAllParameters;
    }

    public boolean shouldCacheAllStatements() {
        return this.shouldCacheAllStatements;
    }

    public boolean shouldCreateIndicesForPrimaryKeys() {
        return false;
    }

    public boolean shouldCreateIndicesOnUniqueKeys() {
        return false;
    }

    public boolean shouldCreateIndicesOnForeignKeys() {
        return this.shouldCreateIndicesOnForeignKeys;
    }

    public void setShouldCreateIndicesOnForeignKeys(boolean shouldCreateIndicesOnForeignKeys) {
        this.shouldCreateIndicesOnForeignKeys = shouldCreateIndicesOnForeignKeys;
    }

    public boolean shouldForceFieldNamesToUpperCase() {
        return this.shouldForceFieldNamesToUpperCase;
    }

    public static boolean shouldIgnoreCaseOnFieldComparisons() {
        return shouldIgnoreCaseOnFieldComparisons;
    }

    public boolean shouldIgnoreException(SQLException exception) {
        return false;
    }

    public boolean shouldOptimizeDataConversion() {
        return this.shouldOptimizeDataConversion;
    }

    public boolean shouldPrintStoredProcedureVariablesAfterBeginString() {
        return false;
    }

    public boolean shouldPrintConstraintNameAfter() {
        return false;
    }

    public boolean shouldPrintInOutputTokenBeforeType() {
        return true;
    }

    public boolean shouldPrintOuterJoinInWhereClause() {
        if (this.printOuterJoinInWhereClause == null) {
            this.printOuterJoinInWhereClause = Boolean.FALSE;
        }
        return this.printOuterJoinInWhereClause;
    }

    public boolean shouldPrintInnerJoinInWhereClause() {
        if (this.printInnerJoinInWhereClause == null) {
            return true;
        }
        return this.printInnerJoinInWhereClause;
    }

    public boolean shouldPrintInputTokenAtStart() {
        return false;
    }

    public boolean shouldPrintOutputTokenBeforeType() {
        return true;
    }

    public boolean shouldPrintOutputTokenAtStart() {
        return false;
    }

    public boolean shouldPrintStoredProcedureArgumentNameInCall() {
        return true;
    }

    public boolean shouldTrimStrings() {
        return this.shouldTrimStrings;
    }

    @Override
    public boolean shouldUseCustomModifyForCall(DatabaseField field) {
        return field.getSqlType() == 2002 && this.typeConverters != null && this.typeConverters.containsKey(field.getType()) || super.shouldUseCustomModifyForCall(field);
    }

    public boolean shouldUseJDBCOuterJoinSyntax() {
        return true;
    }

    public boolean shouldUseRownumFiltering() {
        return this.useRownumFiltering;
    }

    public boolean supportsANSIInnerJoinSyntax() {
        return true;
    }

    public boolean supportsAutoCommit() {
        return this.supportsAutoCommit;
    }

    public boolean supportsAutoConversionToNumericForArithmeticOperations() {
        return false;
    }

    public boolean supportsForeignKeyConstraints() {
        return true;
    }

    public boolean supportsUniqueKeyConstraints() {
        return true;
    }

    public boolean supportsVPD() {
        return false;
    }

    public boolean supportsPrimaryKeyConstraint() {
        return true;
    }

    public boolean supportsStoredFunctions() {
        return false;
    }

    public boolean supportsDeleteOnCascade() {
        return this.supportsForeignKeyConstraints();
    }

    public int executeBatch(Statement statement, boolean isStatementPrepared) throws SQLException {
        int[] rowCounts = statement.executeBatch();
        int rowCount = 0;
        int[] nArray = rowCounts;
        int n = rowCounts.length;
        int n2 = 0;
        while (n2 < n) {
            int count = nArray[n2];
            if (count > 0) {
                ++rowCount;
            } else {
                return statement.getUpdateCount();
            }
            ++n2;
        }
        return rowCount;
    }

    public Object executeStoredProcedure(DatabaseCall dbCall, PreparedStatement statement, DatabaseAccessor accessor, AbstractSession session) throws SQLException {
        Vector result = null;
        ResultSet resultSet = null;
        if (!dbCall.getReturnsResultSet()) {
            if (dbCall.isCursorOutputProcedure()) {
                result = accessor.executeNoSelect(dbCall, statement, session);
                resultSet = (ResultSet)((CallableStatement)statement).getObject(dbCall.getCursorOutIndex());
            } else {
                accessor.executeDirectNoSelect(statement, dbCall, session);
                result = accessor.buildOutputRow((CallableStatement)statement, dbCall, session);
                if (dbCall.areManyRowsReturned()) {
                    Vector tempResult = new Vector();
                    tempResult.add(result);
                    result = tempResult;
                }
            }
        } else {
            resultSet = accessor.executeSelect(dbCall, statement, session);
        }
        if (resultSet != null) {
            dbCall.matchFieldOrder(resultSet, accessor, session);
            if (dbCall.isCursorReturned()) {
                dbCall.setStatement(statement);
                dbCall.setResult(resultSet);
                return dbCall;
            }
            result = accessor.processResultSet(resultSet, dbCall, statement, session);
        }
        return result;
    }

    public void setPingSQL(String pingSQL) {
        this.pingSQL = pingSQL;
    }

    public void setParameterValueInDatabaseCall(Object parameter, PreparedStatement statement, int index, AbstractSession session) throws SQLException {
        if (parameter instanceof String) {
            if (this.usesStringBinding() && ((String)parameter).length() > this.getStringBindingSize()) {
                CharArrayReader reader = new CharArrayReader(((String)parameter).toCharArray());
                statement.setCharacterStream(index, (Reader)reader, ((String)parameter).length());
            }
            statement.setString(index, (String)parameter);
        } else if (parameter instanceof Number) {
            Number number = (Number)parameter;
            if (number instanceof Integer) {
                statement.setInt(index, number.intValue());
            } else if (number instanceof Long) {
                statement.setLong(index, number.longValue());
            } else if (number instanceof BigDecimal) {
                statement.setBigDecimal(index, (BigDecimal)number);
            } else if (number instanceof Double) {
                statement.setDouble(index, number.doubleValue());
            } else if (number instanceof Float) {
                statement.setFloat(index, number.floatValue());
            } else if (number instanceof Short) {
                statement.setShort(index, number.shortValue());
            } else if (number instanceof Byte) {
                statement.setByte(index, number.byteValue());
            } else if (number instanceof BigInteger) {
                statement.setBigDecimal(index, new BigDecimal((BigInteger)number));
            } else {
                statement.setObject(index, parameter);
            }
        } else if (parameter instanceof Date) {
            statement.setDate(index, (Date)parameter);
        } else if (parameter instanceof Timestamp) {
            statement.setTimestamp(index, (Timestamp)parameter);
        } else if (parameter instanceof Time) {
            statement.setTime(index, (Time)parameter);
        } else if (parameter instanceof Boolean) {
            statement.setBoolean(index, (Boolean)parameter);
        } else if (parameter == null) {
            statement.setNull(index, this.getJDBCType((Class)null));
        } else if (parameter instanceof DatabaseField) {
            this.setNullFromDatabaseField((DatabaseField)parameter, statement, index);
        } else if (parameter instanceof byte[]) {
            if (this.usesStreamsForBinding()) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream((byte[])parameter);
                statement.setBinaryStream(index, (InputStream)inputStream, ((byte[])parameter).length);
            } else {
                statement.setBytes(index, (byte[])parameter);
            }
        } else if (parameter instanceof Calendar) {
            statement.setTimestamp(index, Helper.timestampFromDate(((Calendar)parameter).getTime()));
        } else if (parameter.getClass() == ClassConstants.UTILDATE) {
            statement.setTimestamp(index, Helper.timestampFromDate((java.util.Date)parameter));
        } else if (parameter instanceof Character) {
            statement.setString(index, ((Character)parameter).toString());
        } else if (parameter instanceof char[]) {
            statement.setString(index, new String((char[])parameter));
        } else if (parameter instanceof Character[]) {
            statement.setString(index, (String)this.convertObject(parameter, ClassConstants.STRING));
        } else if (parameter instanceof Byte[]) {
            statement.setBytes(index, (byte[])this.convertObject(parameter, ClassConstants.APBYTE));
        } else if (parameter instanceof BindCallCustomParameter) {
            ((BindCallCustomParameter)parameter).set(this, statement, index, session);
        } else if (this.typeConverters != null && this.typeConverters.containsKey(parameter.getClass())) {
            StructConverter converter = this.typeConverters.get(parameter.getClass());
            parameter = converter.convertToStruct(parameter, this.getConnection(session, statement.getConnection()));
            statement.setObject(index, parameter);
        } else {
            statement.setObject(index, parameter);
        }
    }

    protected void setNullFromDatabaseField(DatabaseField databaseField, PreparedStatement statement, int index) throws SQLException {
        if (databaseField instanceof ObjectRelationalDatabaseField) {
            ObjectRelationalDatabaseField field = (ObjectRelationalDatabaseField)databaseField;
            statement.setNull(index, field.getSqlType(), field.getSqlTypeName());
        } else {
            int jdbcType = this.getJDBCTypeForSetNull(databaseField);
            statement.setNull(index, jdbcType);
        }
    }

    public boolean usesBatchWriting() {
        return this.usesBatchWriting;
    }

    public boolean usesByteArrayBinding() {
        return this.usesByteArrayBinding;
    }

    public boolean usesSequenceTable() {
        return this.getDefaultSequence() instanceof TableSequence;
    }

    public boolean usesJDBCBatchWriting() {
        return this.usesJDBCBatchWriting;
    }

    public boolean usesNativeBatchWriting() {
        return this.usesNativeBatchWriting;
    }

    public boolean usesNativeSQL() {
        return this.usesNativeSQL;
    }

    public boolean usesStreamsForBinding() {
        return this.usesStreamsForBinding;
    }

    public boolean usesStringBinding() {
        return this.usesStringBinding;
    }

    public void writeLOB(DatabaseField field, Object value, ResultSet resultSet, AbstractSession session) throws SQLException {
    }

    public boolean supportsCountDistinctWithMultipleFields() {
        return false;
    }

    public boolean supportsIndexes() {
        return true;
    }

    public boolean requiresTableInIndexDropDDL() {
        return false;
    }

    @Override
    protected Sequence createPlatformDefaultSequence() {
        return new TableSequence();
    }

    public boolean supportsTempTables() {
        return this.supportsLocalTempTables() || this.supportsGlobalTempTables();
    }

    public boolean supportsLocalTempTables() {
        return false;
    }

    public boolean supportsGlobalTempTables() {
        return false;
    }

    protected String getCreateTempTableSqlPrefix() {
        throw ValidationException.platformDoesNotOverrideGetCreateTempTableSqlPrefix(Helper.getShortClassName(this));
    }

    public DatabaseTable getTempTableForTable(DatabaseTable table) {
        return new DatabaseTable("TL_" + table.getName(), table.getTableQualifier(), table.shouldUseDelimiters(), this.getStartDelimiter(), this.getEndDelimiter());
    }

    protected String getCreateTempTableSqlSuffix() {
        return "";
    }

    protected String getCreateTempTableSqlBodyForTable(DatabaseTable table) {
        return null;
    }

    protected boolean shouldTempTableSpecifyPrimaryKeys() {
        return true;
    }

    public void writeCreateTempTableSql(Writer writer, DatabaseTable table, AbstractSession session, Collection pkFields, Collection usedFields, Collection allFields) throws IOException {
        String body = this.getCreateTempTableSqlBodyForTable(table);
        if (body == null) {
            TableDefinition tableDef = new TableDefinition();
            Collection fields = this.supportsLocalTempTables() ? usedFields : allFields;
            for (DatabaseField field : fields) {
                FieldDefinition fieldDef;
                if (field.getColumnDefinition() != null && field.getColumnDefinition().length() == 0) {
                    Class type = ConversionManager.getObjectClass(field.getType());
                    if (type == null) {
                        type = ClassConstants.STRING;
                    }
                    fieldDef = new FieldDefinition(field.getNameDelimited(this), type);
                } else {
                    fieldDef = new FieldDefinition(field.getNameDelimited(this), field.getColumnDefinition());
                }
                if (pkFields.contains(field) && this.shouldTempTableSpecifyPrimaryKeys()) {
                    fieldDef.setIsPrimaryKey(true);
                }
                tableDef.addField(fieldDef);
            }
            tableDef.setCreationPrefix(this.getCreateTempTableSqlPrefix());
            tableDef.setName(this.getTempTableForTable(table).getQualifiedNameDelimited(this));
            tableDef.setCreationSuffix(this.getCreateTempTableSqlSuffix());
            tableDef.buildCreationWriter(session, writer);
        } else {
            writer.write(this.getCreateTempTableSqlPrefix());
            writer.write(this.getTempTableForTable(table).getQualifiedNameDelimited(this));
            writer.write(body);
            writer.write(this.getCreateTempTableSqlSuffix());
        }
    }

    public void writeInsertIntoTableSql(Writer writer, DatabaseTable table, Collection usedFields) throws IOException {
        writer.write("INSERT INTO ");
        writer.write(this.getTempTableForTable(table).getQualifiedNameDelimited(this));
        writer.write(" (");
        DatabasePlatform.writeFieldsList(writer, usedFields, this);
        writer.write(") ");
    }

    public boolean isNullAllowedInSelectClause() {
        return true;
    }

    public void writeTableCreationSuffix(Writer writer, String tableCreationSuffix) throws IOException {
        String defaultTableCreationSuffix;
        if (tableCreationSuffix != null && tableCreationSuffix.length() > 0) {
            writer.write(" " + tableCreationSuffix);
        }
        if ((defaultTableCreationSuffix = this.getTableCreationSuffix()) != null && defaultTableCreationSuffix.length() > 0) {
            writer.write(" " + defaultTableCreationSuffix);
        }
    }

    public void writeUpdateOriginalFromTempTableSql(Writer writer, DatabaseTable table, Collection pkFields, Collection assignedFields) throws IOException {
        writer.write("UPDATE ");
        String tableName = table.getQualifiedNameDelimited(this);
        writer.write(tableName);
        writer.write(" SET (");
        DatabasePlatform.writeFieldsList(writer, assignedFields, this);
        writer.write(") = (SELECT ");
        DatabasePlatform.writeFieldsList(writer, assignedFields, this);
        writer.write(" FROM ");
        String tempTableName = this.getTempTableForTable(table).getQualifiedNameDelimited(this);
        writer.write(tempTableName);
        DatabasePlatform.writeAutoJoinWhereClause(writer, null, tableName, pkFields, this);
        writer.write(") WHERE EXISTS(SELECT ");
        writer.write(((DatabaseField)pkFields.iterator().next()).getNameDelimited(this));
        writer.write(" FROM ");
        writer.write(tempTableName);
        DatabasePlatform.writeAutoJoinWhereClause(writer, null, tableName, pkFields, this);
        writer.write(")");
    }

    public void writeDeleteFromTargetTableUsingTempTableSql(Writer writer, DatabaseTable table, DatabaseTable targetTable, Collection pkFields, Collection targetPkFields, DatasourcePlatform platform) throws IOException {
        writer.write("DELETE FROM ");
        String targetTableName = targetTable.getQualifiedNameDelimited(this);
        writer.write(targetTableName);
        writer.write(" WHERE EXISTS(SELECT ");
        writer.write(((DatabaseField)pkFields.iterator().next()).getNameDelimited(platform));
        writer.write(" FROM ");
        String tempTableName = this.getTempTableForTable(table).getQualifiedNameDelimited(this);
        writer.write(tempTableName);
        DatabasePlatform.writeJoinWhereClause(writer, null, targetTableName, pkFields, targetPkFields, this);
        writer.write(")");
    }

    public boolean wasFailureCommunicationBased(SQLException exception, Connection connection, AbstractSession sessionForProfile) {
        if (connection == null) {
            return false;
        }
        if (this.pingSQL == null) {
            try {
                return connection.isValid(IS_VALID_TIMEOUT);
            }
            catch (Throwable throwable) {
                return false;
            }
        }
        Statement statement = null;
        try {
            try {
                sessionForProfile.startOperationProfile("Timer:ConnectionPing");
                if (sessionForProfile.shouldLog(3, "sql")) {
                    sessionForProfile.log(3, "sql", this.getPingSQL(), null, null, false);
                }
                statement = connection.prepareStatement(this.getPingSQL());
                ResultSet result = statement.executeQuery();
                result.close();
                statement.close();
            }
            catch (SQLException sQLException) {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException2) {}
                sessionForProfile.endOperationProfile("Timer:ConnectionPing");
                return true;
            }
        }
        finally {
            sessionForProfile.endOperationProfile("Timer:ConnectionPing");
        }
        return false;
    }

    public void writeCleanUpTempTableSql(Writer writer, DatabaseTable table) throws IOException {
        if (this.supportsLocalTempTables()) {
            writer.write("DROP TABLE ");
        } else {
            writer.write("DELETE FROM ");
        }
        writer.write(this.getTempTableForTable(table).getQualifiedNameDelimited(this));
    }

    public boolean shouldAlwaysUseTempStorageForModifyAll() {
        return false;
    }

    public boolean dontBindUpdateAllQueryUsingTempTables() {
        return false;
    }

    protected static void writeFieldsList(Writer writer, Collection fields, DatasourcePlatform platform) throws IOException {
        boolean isFirst = true;
        Iterator itFields = fields.iterator();
        while (itFields.hasNext()) {
            if (isFirst) {
                isFirst = false;
            } else {
                writer.write(", ");
            }
            DatabaseField field = (DatabaseField)itFields.next();
            writer.write(field.getNameDelimited(platform));
        }
    }

    protected static void writeAutoAssignmentSetClause(Writer writer, String tableName1, String tableName2, Collection fields, DatasourcePlatform platform) throws IOException {
        writer.write(" SET ");
        DatabasePlatform.writeFieldsAutoClause(writer, tableName1, tableName2, fields, ", ", platform);
    }

    protected static void writeAutoJoinWhereClause(Writer writer, String tableName1, String tableName2, Collection pkFields, DatasourcePlatform platform) throws IOException {
        writer.write(" WHERE ");
        DatabasePlatform.writeFieldsAutoClause(writer, tableName1, tableName2, pkFields, " AND ", platform);
    }

    protected static void writeFieldsAutoClause(Writer writer, String tableName1, String tableName2, Collection fields, String separator, DatasourcePlatform platform) throws IOException {
        DatabasePlatform.writeFields(writer, tableName1, tableName2, fields, fields, separator, platform);
    }

    protected static void writeJoinWhereClause(Writer writer, String tableName1, String tableName2, Collection pkFields1, Collection pkFields2, DatasourcePlatform platform) throws IOException {
        writer.write(" WHERE ");
        DatabasePlatform.writeFields(writer, tableName1, tableName2, pkFields1, pkFields2, " AND ", platform);
    }

    protected static void writeFields(Writer writer, String tableName1, String tableName2, Collection fields1, Collection fields2, String separator, DatasourcePlatform platform) throws IOException {
        boolean isFirst = true;
        Iterator itFields1 = fields1.iterator();
        Iterator itFields2 = fields2.iterator();
        while (itFields1.hasNext()) {
            if (isFirst) {
                isFirst = false;
            } else {
                writer.write(separator);
            }
            if (tableName1 != null) {
                writer.write(tableName1);
                writer.write(".");
            }
            String fieldName1 = ((DatabaseField)itFields1.next()).getNameDelimited(platform);
            writer.write(fieldName1);
            writer.write(" = ");
            if (tableName2 != null) {
                writer.write(tableName2);
                writer.write(".");
            }
            String fieldName2 = ((DatabaseField)itFields2.next()).getNameDelimited(platform);
            writer.write(fieldName2);
        }
    }

    public boolean shouldPrintFieldIdentityClause(AbstractSession session, String qualifiedFieldName) {
        if (!this.supportsIdentity()) {
            return false;
        }
        if (session.getSequencing() == null || session.getSequencing().whenShouldAcquireValueForAll() == -1) {
            return false;
        }
        boolean shouldAcquireSequenceValueAfterInsert = false;
        DatabaseField field = new DatabaseField(qualifiedFieldName, this.getStartDelimiter(), this.getEndDelimiter());
        for (ClassDescriptor descriptor : session.getDescriptors().values()) {
            if (!descriptor.usesSequenceNumbers() || !descriptor.getSequenceNumberField().equals(field)) continue;
            String seqName = descriptor.getSequenceNumberName();
            Sequence sequence = this.getSequence(seqName);
            shouldAcquireSequenceValueAfterInsert = sequence.shouldAcquireValueAfterInsert();
            break;
        }
        return shouldAcquireSequenceValueAfterInsert;
    }

    public void printFieldTypeSize(Writer writer, FieldDefinition field, FieldTypeDefinition fieldType, boolean shouldPrintFieldIdentityClause) throws IOException {
        this.printFieldTypeSize(writer, field, fieldType);
    }

    protected void printFieldTypeSize(Writer writer, FieldDefinition field, FieldTypeDefinition fieldType) throws IOException {
        writer.write(fieldType.getName());
        if (fieldType.isSizeAllowed() && (field.getSize() != 0 || fieldType.isSizeRequired())) {
            writer.write("(");
            if (field.getSize() == 0) {
                writer.write(Integer.valueOf(fieldType.getDefaultSize()).toString());
            } else {
                writer.write(Integer.valueOf(field.getSize()).toString());
            }
            if (field.getSubSize() != 0) {
                writer.write(",");
                writer.write(Integer.valueOf(field.getSubSize()).toString());
            } else if (fieldType.getDefaultSubSize() != 0) {
                writer.write(",");
                writer.write(Integer.valueOf(fieldType.getDefaultSubSize()).toString());
            }
            writer.write(")");
        }
    }

    public boolean supportsUniqueColumns() {
        return true;
    }

    public void printFieldUnique(Writer writer, boolean shouldPrintFieldIdentityClause) throws IOException {
        this.printFieldUnique(writer);
    }

    protected void printFieldUnique(Writer writer) throws IOException {
        if (this.supportsUniqueKeyConstraints()) {
            writer.write(" UNIQUE");
        }
    }

    public void writeParameterMarker(Writer writer, ParameterExpression expression, AbstractRecord record, DatabaseCall call) throws IOException {
        writer.write("?");
    }

    public Array createArray(String elementDataTypeName, Object[] elements, AbstractSession session, Connection connection) throws SQLException {
        Connection unwrappedConnection = this.getConnection(session, connection);
        return this.createArray(elementDataTypeName, elements, unwrappedConnection);
    }

    public Struct createStruct(String structTypeName, Object[] attributes, AbstractSession session, Connection connection) throws SQLException {
        Connection unwrappedConnection = this.getConnection(session, connection);
        return this.createStruct(structTypeName, attributes, unwrappedConnection);
    }

    public Array createArray(String elementDataTypeName, Object[] elements, Connection connection) throws SQLException {
        return connection.createArrayOf(elementDataTypeName, elements);
    }

    public Struct createStruct(String structTypeName, Object[] attributes, Connection connection) throws SQLException {
        return connection.createStruct(structTypeName, attributes);
    }

    public boolean isXDBDocument(Object obj) {
        return false;
    }

    public boolean shouldBindLiterals() {
        return this.shouldBindLiterals;
    }

    public void setShouldBindLiterals(boolean shouldBindLiterals) {
        this.shouldBindLiterals = shouldBindLiterals;
    }

    public boolean isDynamicSQLRequiredForFunctions() {
        return false;
    }

    public Object getRefValue(Ref ref, Connection connection) throws SQLException {
        return ref.getObject();
    }

    public Object getRefValue(Ref ref, AbstractSession executionSession, Connection connection) throws SQLException {
        Connection unwrappedConnection = this.getConnection(executionSession, connection);
        return this.getRefValue(ref, unwrappedConnection);
    }

    public void printStoredFunctionReturnKeyWord(Writer writer) throws IOException {
        writer.write("\n\t RETURN ");
    }

    public void printSQLSelectStatement(DatabaseCall call, ExpressionSQLPrinter printer, SQLSelectStatement statement) {
        call.setFields(statement.printSQL(printer));
    }

    public boolean shouldPrintLockingClauseAfterWhereClause() {
        return true;
    }

    public boolean supportsIndividualTableLocking() {
        return true;
    }

    public boolean supportsLockingQueriesWithMultipleTables() {
        return true;
    }

    public boolean shouldPrintAliasForUpdate() {
        return false;
    }

    public String buildCreateIndex(String fullTableName, String indexName, String ... columnNames) {
        return this.buildCreateIndex(fullTableName, indexName, "", false, columnNames);
    }

    public String buildCreateIndex(String fullTableName, String indexName, String qualifier, boolean isUnique, String ... columnNames) {
        StringBuilder queryString = new StringBuilder();
        if (isUnique) {
            queryString.append("CREATE UNIQUE INDEX ");
        } else {
            queryString.append("CREATE INDEX ");
        }
        if (!qualifier.equals("")) {
            queryString.append(qualifier).append(".");
        }
        queryString.append(indexName).append(" ON ").append(fullTableName).append(" (");
        queryString.append(columnNames[0]);
        int i = 1;
        while (i < columnNames.length) {
            queryString.append(", ").append(columnNames[i]);
            ++i;
        }
        queryString.append(")");
        return queryString.toString();
    }

    public String buildDropIndex(String fullTableName, String indexName) {
        return this.buildDropIndex(fullTableName, indexName, "");
    }

    public String buildDropIndex(String fullTableName, String indexName, String qualifier) {
        StringBuilder queryString = new StringBuilder();
        queryString.append("DROP INDEX ");
        if (!qualifier.equals("")) {
            queryString.append(qualifier).append(".");
        }
        queryString.append(indexName);
        if (this.requiresTableInIndexDropDDL()) {
            queryString.append(" ON ").append(fullTableName);
        }
        return queryString.toString();
    }

    public Writer buildSequenceObjectCreationWriter(Writer writer, String fullSeqName, int increment, int start) throws IOException {
        writer.write("CREATE SEQUENCE ");
        writer.write(fullSeqName);
        if (increment != 1) {
            writer.write(" INCREMENT BY " + increment);
        }
        writer.write(" START WITH " + start);
        return writer;
    }

    public Writer buildSequenceObjectDeletionWriter(Writer writer, String fullSeqName) throws IOException {
        writer.write("DROP SEQUENCE ");
        writer.write(fullSeqName);
        return writer;
    }

    public Writer buildSequenceObjectAlterIncrementWriter(Writer writer, String fullSeqName, int increment) throws IOException {
        writer.write("ALTER SEQUENCE ");
        writer.write(fullSeqName);
        writer.write(" INCREMENT BY " + increment);
        return writer;
    }

    public boolean isAlterSequenceObjectSupported() {
        return false;
    }

    public boolean supportsNestingOuterJoins() {
        return true;
    }

    public boolean supportsOuterJoinsWithBrackets() {
        return true;
    }

    public void freeTemporaryObject(Object value) throws SQLException {
    }

    public void initializeConnectionData(Connection connection) throws SQLException {
    }

    public void writeAddColumnClause(Writer writer, AbstractSession session, TableDefinition table, FieldDefinition field) throws IOException {
        writer.write("ADD ");
        field.appendDBString(writer, session, table);
    }
}

