/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.v3_0_RC.gbfs;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.entur.gbfs.v3_0_RC.gbfs.GBFSData;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"last_updated", "ttl", "version", "data", "required"})
public class GBFSGbfs
implements Serializable {
    @JsonProperty(value="last_updated")
    @JsonPropertyDescription(value="Last time the data in the feed was updated in POSIX time.")
    private Integer lastUpdated;
    @JsonProperty(value="ttl")
    @JsonPropertyDescription(value="Number of seconds before the data in the feed will be updated again (0 if the data should always be refreshed).")
    private Integer ttl;
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="GBFS version number to which the feed conforms, according to the versioning framework (added in v1.1).")
    private Version version;
    @JsonProperty(value="data")
    private GBFSData data;
    @JsonProperty(value="required")
    private Object required;
    private static final long serialVersionUID = 6233306497832400183L;

    @JsonProperty(value="last_updated")
    public Integer getLastUpdated() {
        return this.lastUpdated;
    }

    @JsonProperty(value="last_updated")
    public void setLastUpdated(Integer lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public GBFSGbfs withLastUpdated(Integer lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty(value="ttl")
    public Integer getTtl() {
        return this.ttl;
    }

    @JsonProperty(value="ttl")
    public void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

    public GBFSGbfs withTtl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    @JsonProperty(value="version")
    public Version getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(Version version) {
        this.version = version;
    }

    public GBFSGbfs withVersion(Version version) {
        this.version = version;
        return this;
    }

    @JsonProperty(value="data")
    public GBFSData getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    public void setData(GBFSData data) {
        this.data = data;
    }

    public GBFSGbfs withData(GBFSData data) {
        this.data = data;
        return this;
    }

    @JsonProperty(value="required")
    public Object getRequired() {
        return this.required;
    }

    @JsonProperty(value="required")
    public void setRequired(Object required) {
        this.required = required;
    }

    public GBFSGbfs withRequired(Object required) {
        this.required = required;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GBFSGbfs.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(this.lastUpdated == null ? "<null>" : this.lastUpdated);
        sb.append(',');
        sb.append("ttl");
        sb.append('=');
        sb.append(this.ttl == null ? "<null>" : this.ttl);
        sb.append(',');
        sb.append("version");
        sb.append('=');
        sb.append(this.version == null ? "<null>" : this.version);
        sb.append(',');
        sb.append("data");
        sb.append('=');
        sb.append(this.data == null ? "<null>" : this.data);
        sb.append(',');
        sb.append("required");
        sb.append('=');
        sb.append(this.required == null ? "<null>" : this.required);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.lastUpdated == null ? 0 : this.lastUpdated.hashCode());
        result = result * 31 + (this.data == null ? 0 : this.data.hashCode());
        result = result * 31 + (this.ttl == null ? 0 : this.ttl.hashCode());
        result = result * 31 + (this.version == null ? 0 : this.version.hashCode());
        result = result * 31 + (this.required == null ? 0 : this.required.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GBFSGbfs)) {
            return false;
        }
        GBFSGbfs rhs = (GBFSGbfs)other;
        return (this.lastUpdated == rhs.lastUpdated || this.lastUpdated != null && this.lastUpdated.equals(rhs.lastUpdated)) && (this.data == rhs.data || this.data != null && this.data.equals(rhs.data)) && (this.ttl == rhs.ttl || this.ttl != null && this.ttl.equals(rhs.ttl)) && (this.version == rhs.version || this.version != null && this.version.equals((Object)rhs.version)) && (this.required == rhs.required || this.required != null && this.required.equals(rhs.required));
    }

    public static enum Version {
        _3_0_RC("3.0-RC"),
        _3_0("3.0");

        private final String value;
        private static final Map<String, Version> CONSTANTS;

        private Version(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Version fromValue(String value) {
            Version constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Version>();
            for (Version c : Version.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

