/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.v3_0_RC.system_pricing_plans;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.entur.gbfs.v3_0_RC.system_pricing_plans.GBFSDescription;
import org.entur.gbfs.v3_0_RC.system_pricing_plans.GBFSName;
import org.entur.gbfs.v3_0_RC.system_pricing_plans.GBFSPerKmPricing;
import org.entur.gbfs.v3_0_RC.system_pricing_plans.GBFSPerMinPricing;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"plan_id", "url", "name", "currency", "price", "reservation_price_per_min", "reservation_price_flat_rate", "is_taxable", "description", "per_km_pricing", "per_min_pricing", "surge_pricing"})
public class GBFSPlan
implements Serializable {
    @JsonProperty(value="plan_id")
    @JsonPropertyDescription(value="Identifier of a pricing plan in the system.")
    private String planId;
    @JsonProperty(value="url")
    @JsonPropertyDescription(value="URL where the customer can learn more about this pricing plan.")
    private String url;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name of this pricing plan.")
    private List<GBFSName> name;
    @JsonProperty(value="currency")
    @JsonPropertyDescription(value="Currency used to pay the fare in ISO 4217 code.")
    private String currency;
    @JsonProperty(value="price")
    @JsonPropertyDescription(value="Fare price.")
    private Double price;
    @JsonProperty(value="reservation_price_per_min")
    @JsonPropertyDescription(value="The cost, described as per minute rate, to reserve the vehicle prior to beginning a rental.")
    private Double reservationPricePerMin;
    @JsonProperty(value="reservation_price_flat_rate")
    @JsonPropertyDescription(value="The cost, described as a flat rate, to reserve the vehicle prior to beginning a rental.")
    private Double reservationPriceFlatRate;
    @JsonProperty(value="is_taxable")
    @JsonPropertyDescription(value="Will additional tax be added to the base price?")
    private Boolean isTaxable;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Customer-readable description of the pricing plan.")
    private List<GBFSDescription> description;
    @JsonProperty(value="per_km_pricing")
    @JsonPropertyDescription(value="Array of segments when the price is a function of distance travelled, displayed in kilometers (added in v2.1-RC2).")
    private List<GBFSPerKmPricing> perKmPricing;
    @JsonProperty(value="per_min_pricing")
    @JsonPropertyDescription(value="Array of segments when the price is a function of time travelled, displayed in minutes (added in v2.1-RC2).")
    private List<GBFSPerMinPricing> perMinPricing;
    @JsonProperty(value="surge_pricing")
    @JsonPropertyDescription(value="Is there currently an increase in price in response to increased demand in this pricing plan? (added in v2.1-RC2)")
    private Boolean surgePricing;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    private static final long serialVersionUID = -4643303798659250241L;

    @JsonProperty(value="plan_id")
    public String getPlanId() {
        return this.planId;
    }

    @JsonProperty(value="plan_id")
    public void setPlanId(String planId) {
        this.planId = planId;
    }

    public GBFSPlan withPlanId(String planId) {
        this.planId = planId;
        return this;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    public void setUrl(String url) {
        this.url = url;
    }

    public GBFSPlan withUrl(String url) {
        this.url = url;
        return this;
    }

    @JsonProperty(value="name")
    public List<GBFSName> getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(List<GBFSName> name) {
        this.name = name;
    }

    public GBFSPlan withName(List<GBFSName> name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="currency")
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="currency")
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public GBFSPlan withCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    @JsonProperty(value="price")
    public Double getPrice() {
        return this.price;
    }

    @JsonProperty(value="price")
    public void setPrice(Double price) {
        this.price = price;
    }

    public GBFSPlan withPrice(Double price) {
        this.price = price;
        return this;
    }

    @JsonProperty(value="reservation_price_per_min")
    public Double getReservationPricePerMin() {
        return this.reservationPricePerMin;
    }

    @JsonProperty(value="reservation_price_per_min")
    public void setReservationPricePerMin(Double reservationPricePerMin) {
        this.reservationPricePerMin = reservationPricePerMin;
    }

    public GBFSPlan withReservationPricePerMin(Double reservationPricePerMin) {
        this.reservationPricePerMin = reservationPricePerMin;
        return this;
    }

    @JsonProperty(value="reservation_price_flat_rate")
    public Double getReservationPriceFlatRate() {
        return this.reservationPriceFlatRate;
    }

    @JsonProperty(value="reservation_price_flat_rate")
    public void setReservationPriceFlatRate(Double reservationPriceFlatRate) {
        this.reservationPriceFlatRate = reservationPriceFlatRate;
    }

    public GBFSPlan withReservationPriceFlatRate(Double reservationPriceFlatRate) {
        this.reservationPriceFlatRate = reservationPriceFlatRate;
        return this;
    }

    @JsonProperty(value="is_taxable")
    public Boolean getIsTaxable() {
        return this.isTaxable;
    }

    @JsonProperty(value="is_taxable")
    public void setIsTaxable(Boolean isTaxable) {
        this.isTaxable = isTaxable;
    }

    public GBFSPlan withIsTaxable(Boolean isTaxable) {
        this.isTaxable = isTaxable;
        return this;
    }

    @JsonProperty(value="description")
    public List<GBFSDescription> getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(List<GBFSDescription> description) {
        this.description = description;
    }

    public GBFSPlan withDescription(List<GBFSDescription> description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="per_km_pricing")
    public List<GBFSPerKmPricing> getPerKmPricing() {
        return this.perKmPricing;
    }

    @JsonProperty(value="per_km_pricing")
    public void setPerKmPricing(List<GBFSPerKmPricing> perKmPricing) {
        this.perKmPricing = perKmPricing;
    }

    public GBFSPlan withPerKmPricing(List<GBFSPerKmPricing> perKmPricing) {
        this.perKmPricing = perKmPricing;
        return this;
    }

    @JsonProperty(value="per_min_pricing")
    public List<GBFSPerMinPricing> getPerMinPricing() {
        return this.perMinPricing;
    }

    @JsonProperty(value="per_min_pricing")
    public void setPerMinPricing(List<GBFSPerMinPricing> perMinPricing) {
        this.perMinPricing = perMinPricing;
    }

    public GBFSPlan withPerMinPricing(List<GBFSPerMinPricing> perMinPricing) {
        this.perMinPricing = perMinPricing;
        return this;
    }

    @JsonProperty(value="surge_pricing")
    public Boolean getSurgePricing() {
        return this.surgePricing;
    }

    @JsonProperty(value="surge_pricing")
    public void setSurgePricing(Boolean surgePricing) {
        this.surgePricing = surgePricing;
    }

    public GBFSPlan withSurgePricing(Boolean surgePricing) {
        this.surgePricing = surgePricing;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public GBFSPlan withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GBFSPlan.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("planId");
        sb.append('=');
        sb.append(this.planId == null ? "<null>" : this.planId);
        sb.append(',');
        sb.append("url");
        sb.append('=');
        sb.append(this.url == null ? "<null>" : this.url);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("currency");
        sb.append('=');
        sb.append(this.currency == null ? "<null>" : this.currency);
        sb.append(',');
        sb.append("price");
        sb.append('=');
        sb.append(this.price == null ? "<null>" : this.price);
        sb.append(',');
        sb.append("reservationPricePerMin");
        sb.append('=');
        sb.append(this.reservationPricePerMin == null ? "<null>" : this.reservationPricePerMin);
        sb.append(',');
        sb.append("reservationPriceFlatRate");
        sb.append('=');
        sb.append(this.reservationPriceFlatRate == null ? "<null>" : this.reservationPriceFlatRate);
        sb.append(',');
        sb.append("isTaxable");
        sb.append('=');
        sb.append(this.isTaxable == null ? "<null>" : this.isTaxable);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("perKmPricing");
        sb.append('=');
        sb.append(this.perKmPricing == null ? "<null>" : this.perKmPricing);
        sb.append(',');
        sb.append("perMinPricing");
        sb.append('=');
        sb.append(this.perMinPricing == null ? "<null>" : this.perMinPricing);
        sb.append(',');
        sb.append("surgePricing");
        sb.append('=');
        sb.append(this.surgePricing == null ? "<null>" : this.surgePricing);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.reservationPricePerMin == null ? 0 : this.reservationPricePerMin.hashCode());
        result = result * 31 + (this.perKmPricing == null ? 0 : this.perKmPricing.hashCode());
        result = result * 31 + (this.reservationPriceFlatRate == null ? 0 : this.reservationPriceFlatRate.hashCode());
        result = result * 31 + (this.isTaxable == null ? 0 : this.isTaxable.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.perMinPricing == null ? 0 : this.perMinPricing.hashCode());
        result = result * 31 + (this.url == null ? 0 : this.url.hashCode());
        result = result * 31 + (this.surgePricing == null ? 0 : this.surgePricing.hashCode());
        result = result * 31 + (this.price == null ? 0 : this.price.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.planId == null ? 0 : this.planId.hashCode());
        result = result * 31 + (this.currency == null ? 0 : this.currency.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GBFSPlan)) {
            return false;
        }
        GBFSPlan rhs = (GBFSPlan)other;
        return (this.reservationPricePerMin == rhs.reservationPricePerMin || this.reservationPricePerMin != null && this.reservationPricePerMin.equals(rhs.reservationPricePerMin)) && (this.perKmPricing == rhs.perKmPricing || this.perKmPricing != null && this.perKmPricing.equals(rhs.perKmPricing)) && (this.reservationPriceFlatRate == rhs.reservationPriceFlatRate || this.reservationPriceFlatRate != null && this.reservationPriceFlatRate.equals(rhs.reservationPriceFlatRate)) && (this.isTaxable == rhs.isTaxable || this.isTaxable != null && this.isTaxable.equals(rhs.isTaxable)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.perMinPricing == rhs.perMinPricing || this.perMinPricing != null && this.perMinPricing.equals(rhs.perMinPricing)) && (this.url == rhs.url || this.url != null && this.url.equals(rhs.url)) && (this.surgePricing == rhs.surgePricing || this.surgePricing != null && this.surgePricing.equals(rhs.surgePricing)) && (this.price == rhs.price || this.price != null && this.price.equals(rhs.price)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.planId == rhs.planId || this.planId != null && this.planId.equals(rhs.planId)) && (this.currency == rhs.currency || this.currency != null && this.currency.equals(rhs.currency)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties));
    }
}

