/*
 * Decompiled with CFR 0.152.
 */
package org.entur.siri.adapter;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZonedDateTimeAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZonedDateTimeAdapter.class);

    public static ZonedDateTime parse(String dateTime) {
        ZonedDateTime parsed;
        Objects.requireNonNull(dateTime, "dateTime");
        if (ZonedDateTimeAdapter.containsOnlyDigits(dateTime)) {
            LOGGER.trace("ZoneDateTime provided as a timestamp: {}", (Object)dateTime);
            parsed = ZonedDateTimeAdapter.parse(Long.parseLong(dateTime));
        } else {
            try {
                parsed = ZonedDateTime.parse(dateTime);
            }
            catch (DateTimeParseException e) {
                LocalDateTime parse1 = LocalDateTime.parse(dateTime, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
                parsed = ZonedDateTime.ofLocal(parse1, ZoneId.systemDefault(), ZoneOffset.ofHours(0));
            }
        }
        return parsed.withZoneSameInstant(ZoneId.systemDefault());
    }

    private static boolean containsOnlyDigits(String str) {
        int length = str.length();
        if (length == 0) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (str.charAt(i) >= '0' && str.charAt(i) <= '9') continue;
            return false;
        }
        return true;
    }

    private static ZonedDateTime parse(long dateTime) {
        return ZonedDateTime.ofInstant(Instant.ofEpochSecond(dateTime), ZoneId.systemDefault());
    }
}

