/*
 * Decompiled with CFR 0.152.
 */
package org.entur.protobuf.mapper.siri;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.entur.protobuf.mapper.siri.EnumerationMapper;
import org.w3.www.xml._1998.namespace.LangType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import uk.org.ifopt.siri20.IanaCountryTldEnumeration;
import uk.org.ifopt.siri20.StopPlaceRef;
import uk.org.ifopt.www.ifopt.CountryRefStructure;
import uk.org.ifopt.www.ifopt.StopPlaceRefStructure;
import uk.org.siri.siri20.BlockRefStructure;
import uk.org.siri.siri20.DatedVehicleJourneyRef;
import uk.org.siri.siri20.DefaultedTextStructure;
import uk.org.siri.siri20.DestinationRef;
import uk.org.siri.siri20.DirectionRefStructure;
import uk.org.siri.siri20.GroupOfLinesRefStructure;
import uk.org.siri.siri20.JourneyPatternRef;
import uk.org.siri.siri20.JourneyPlaceRefStructure;
import uk.org.siri.siri20.LineRef;
import uk.org.siri.siri20.NaturalLanguagePlaceNameStructure;
import uk.org.siri.siri20.NaturalLanguageStringStructure;
import uk.org.siri.siri20.OperatorRefStructure;
import uk.org.siri.siri20.RequestorRef;
import uk.org.siri.siri20.ServiceFeatureRef;
import uk.org.siri.siri20.SimpleContactStructure;
import uk.org.siri.siri20.SituationRef;
import uk.org.siri.siri20.SituationSimpleRef;
import uk.org.siri.siri20.StopPointRef;
import uk.org.siri.siri20.VehicleJourneyRef;
import uk.org.siri.siri20.VehicleRef;
import uk.org.siri.www.siri.BlockRefStructure;
import uk.org.siri.www.siri.DataFrameRefStructure;
import uk.org.siri.www.siri.DatedVehicleJourneyRefStructure;
import uk.org.siri.www.siri.DefaultedTextStructure;
import uk.org.siri.www.siri.DestinationRefStructure;
import uk.org.siri.www.siri.DirectionRefStructure;
import uk.org.siri.www.siri.FramedVehicleJourneyRefStructure;
import uk.org.siri.www.siri.JourneyPatternRefStructure;
import uk.org.siri.www.siri.JourneyPlaceRefStructure;
import uk.org.siri.www.siri.LineRefStructure;
import uk.org.siri.www.siri.LocationStructure;
import uk.org.siri.www.siri.NaturalLanguagePlaceNameStructure;
import uk.org.siri.www.siri.NaturalLanguageStringStructure;
import uk.org.siri.www.siri.OperatorRefStructure;
import uk.org.siri.www.siri.ParticipantRefStructure;
import uk.org.siri.www.siri.RouteRefStructure;
import uk.org.siri.www.siri.ServiceFeatureRefStructure;
import uk.org.siri.www.siri.SituationRefStructure;
import uk.org.siri.www.siri.SituationSimpleRefStructure;
import uk.org.siri.www.siri.StopPointRefStructure;
import uk.org.siri.www.siri.VehicleJourneyRefStructure;
import uk.org.siri.www.siri.VehicleRefStructure;

public class CommonMapper
extends EnumerationMapper {
    protected static Duration.Builder map(java.time.Duration value) {
        return Duration.newBuilder().setSeconds(value.getSeconds());
    }

    protected static java.time.Duration map(Duration value) {
        return java.time.Duration.ofSeconds(value.getSeconds());
    }

    protected static Timestamp.Builder map(ZonedDateTime value) {
        Timestamp.Builder builder = Timestamp.newBuilder();
        long epochSecond = value.toEpochSecond();
        if (epochSecond > 0L) {
            builder.setSeconds(epochSecond);
            builder.setNanos(value.getNano());
        }
        return builder;
    }

    protected static ZonedDateTime map(Timestamp value) {
        ZonedDateTime time = ZonedDateTime.ofInstant(Instant.ofEpochSecond(value.getSeconds()), ZoneId.of("UTC"));
        time = time.plusNanos(value.getNanos());
        return time;
    }

    protected static RequestorRef map(ParticipantRefStructure producerRef) {
        RequestorRef mapped = new RequestorRef();
        mapped.setValue(producerRef.getValue());
        return mapped;
    }

    protected static ParticipantRefStructure.Builder map(RequestorRef producerRef) {
        ParticipantRefStructure.Builder builder = ParticipantRefStructure.newBuilder();
        builder.setValue(producerRef.getValue());
        return builder;
    }

    protected static LineRefStructure.Builder map(LineRef lineRef) {
        return LineRefStructure.newBuilder().setValue(lineRef.getValue());
    }

    protected static LineRef map(LineRefStructure lineRef) {
        LineRef mapped = new LineRef();
        mapped.setValue(lineRef.getValue());
        return mapped;
    }

    protected static NaturalLanguageStringStructure map(uk.org.siri.www.siri.NaturalLanguageStringStructure naturalLanguageStringStructure) {
        NaturalLanguageStringStructure mapped = new NaturalLanguageStringStructure();
        mapped.setLang(CommonMapper.map(naturalLanguageStringStructure.getLang()));
        mapped.setValue(naturalLanguageStringStructure.getValue());
        return mapped;
    }

    protected static NaturalLanguagePlaceNameStructure map(uk.org.siri.www.siri.NaturalLanguagePlaceNameStructure naturalLanguagePlaceNameStructure) {
        NaturalLanguagePlaceNameStructure mapped = new NaturalLanguagePlaceNameStructure();
        if (naturalLanguagePlaceNameStructure != null) {
            mapped.setValue(naturalLanguagePlaceNameStructure.getValue());
            if (naturalLanguagePlaceNameStructure.getLang() != null) {
                mapped.setLang(CommonMapper.map(naturalLanguagePlaceNameStructure.getLang()));
            }
        }
        return mapped;
    }

    private static String map(LangType lang) {
        if (lang != null && lang != LangType.LANG_TYPE_UNSPECIFIED) {
            return lang.name().replace("LANG_TYPE_", "");
        }
        return null;
    }

    protected static DefaultedTextStructure.Builder map(DefaultedTextStructure defaultedTextStructure) {
        DefaultedTextStructure.Builder builder = uk.org.siri.www.siri.DefaultedTextStructure.newBuilder();
        if (defaultedTextStructure != null) {
            builder.setValue(defaultedTextStructure.getValue());
            if (defaultedTextStructure.getLang() != null) {
                builder.setLang(CommonMapper.map(defaultedTextStructure.getLang()));
            }
        }
        return builder;
    }

    protected static DefaultedTextStructure map(uk.org.siri.www.siri.DefaultedTextStructure defaultedTextStructure) {
        DefaultedTextStructure mapped = new DefaultedTextStructure();
        if (defaultedTextStructure != null) {
            mapped.setValue(defaultedTextStructure.getValue());
            if (defaultedTextStructure.getLang() != null) {
                mapped.setLang(CommonMapper.map(defaultedTextStructure.getLang()));
            }
        }
        return mapped;
    }

    protected static NaturalLanguageStringStructure.Builder map(NaturalLanguageStringStructure naturalLanguageStringStructure) {
        NaturalLanguageStringStructure.Builder builder = uk.org.siri.www.siri.NaturalLanguageStringStructure.newBuilder();
        if (naturalLanguageStringStructure != null) {
            builder.setValue(naturalLanguageStringStructure.getValue());
            if (naturalLanguageStringStructure.getLang() != null) {
                builder.setLang(CommonMapper.map(naturalLanguageStringStructure.getLang()));
            }
        }
        return builder;
    }

    protected static NaturalLanguagePlaceNameStructure.Builder map(NaturalLanguagePlaceNameStructure originName) {
        if (originName != null && originName.getValue() != null) {
            NaturalLanguagePlaceNameStructure.Builder builder = uk.org.siri.www.siri.NaturalLanguagePlaceNameStructure.newBuilder();
            builder.setValue(originName.getValue());
            if (originName.getLang() != null) {
                builder.setLang(CommonMapper.map(originName.getLang()));
            }
            return builder;
        }
        return null;
    }

    private static LangType map(String lang) {
        if (lang.length() == 3) {
            lang = lang.substring(0, 2);
        }
        return LangType.valueOf((String)("LANG_TYPE_" + lang.toUpperCase()));
    }

    protected static StopPointRefStructure.Builder map(StopPointRef stopPointRef) {
        return StopPointRefStructure.newBuilder().setValue(stopPointRef.getValue());
    }

    protected static StopPlaceRefStructure.Builder map(StopPlaceRef stopPlaceRef) {
        return StopPlaceRefStructure.newBuilder().setValue(stopPlaceRef.getValue());
    }

    protected static StopPointRef map(StopPointRefStructure stopPointRef) {
        StopPointRef mapped = new StopPointRef();
        mapped.setValue(stopPointRef.getValue());
        return mapped;
    }

    protected static OperatorRefStructure.Builder map(OperatorRefStructure operatorRef) {
        return uk.org.siri.www.siri.OperatorRefStructure.newBuilder().setValue(operatorRef.getValue());
    }

    protected static DirectionRefStructure.Builder map(DirectionRefStructure directionRef) {
        DirectionRefStructure.Builder builder = uk.org.siri.www.siri.DirectionRefStructure.newBuilder();
        builder.setValue(directionRef.getValue());
        return builder;
    }

    protected static DestinationRefStructure.Builder map(DestinationRef destinationRef) {
        DestinationRefStructure.Builder builder = DestinationRefStructure.newBuilder();
        builder.setValue(destinationRef.getValue());
        return builder;
    }

    protected static JourneyPlaceRefStructure.Builder map(JourneyPlaceRefStructure originRef) {
        JourneyPlaceRefStructure.Builder builder = uk.org.siri.www.siri.JourneyPlaceRefStructure.newBuilder();
        builder.setValue(originRef.getValue());
        return builder;
    }

    protected static VehicleRefStructure.Builder map(VehicleRef vehicleRef) {
        return VehicleRefStructure.newBuilder().setValue(vehicleRef.getValue());
    }

    protected static BlockRefStructure.Builder map(BlockRefStructure blockRef) {
        return uk.org.siri.www.siri.BlockRefStructure.newBuilder().setValue(blockRef.getValue());
    }

    protected static FramedVehicleJourneyRefStructure.Builder map(uk.org.siri.siri20.FramedVehicleJourneyRefStructure framedVehicleJourneyRef) {
        return FramedVehicleJourneyRefStructure.newBuilder().setDataFrameRef(CommonMapper.map(framedVehicleJourneyRef.getDataFrameRef())).setDatedVehicleJourneyRef(framedVehicleJourneyRef.getDatedVehicleJourneyRef());
    }

    protected static uk.org.siri.siri20.FramedVehicleJourneyRefStructure map(FramedVehicleJourneyRefStructure framedVehicleJourneyRef) {
        uk.org.siri.siri20.FramedVehicleJourneyRefStructure mapped = new uk.org.siri.siri20.FramedVehicleJourneyRefStructure();
        if (framedVehicleJourneyRef.hasDataFrameRef()) {
            mapped.setDataFrameRef(CommonMapper.map(framedVehicleJourneyRef.getDataFrameRef()));
        }
        mapped.setDatedVehicleJourneyRef(framedVehicleJourneyRef.getDatedVehicleJourneyRef());
        return mapped;
    }

    private static uk.org.siri.siri20.DataFrameRefStructure map(DataFrameRefStructure dataFrameRef) {
        uk.org.siri.siri20.DataFrameRefStructure mapped = new uk.org.siri.siri20.DataFrameRefStructure();
        mapped.setValue(dataFrameRef.getValue());
        return mapped;
    }

    private static DataFrameRefStructure.Builder map(uk.org.siri.siri20.DataFrameRefStructure dataFrameRef) {
        return DataFrameRefStructure.newBuilder().setValue(dataFrameRef.getValue());
    }

    protected static VehicleRef map(VehicleRefStructure vehicleRef) {
        VehicleRef mapped = new VehicleRef();
        mapped.setValue(vehicleRef.getValue());
        return mapped;
    }

    protected static BlockRefStructure map(uk.org.siri.www.siri.BlockRefStructure blockRef) {
        BlockRefStructure mapped = new BlockRefStructure();
        mapped.setValue(blockRef.getValue());
        return mapped;
    }

    protected static OperatorRefStructure map(uk.org.siri.www.siri.OperatorRefStructure operatorRef) {
        OperatorRefStructure mapped = new OperatorRefStructure();
        mapped.setValue(operatorRef.getValue());
        return mapped;
    }

    protected static DirectionRefStructure map(uk.org.siri.www.siri.DirectionRefStructure directionRef) {
        DirectionRefStructure mapped = new DirectionRefStructure();
        mapped.setValue(directionRef.getValue());
        return mapped;
    }

    protected static VehicleJourneyRef map(VehicleJourneyRefStructure vehicleJourneyRef) {
        VehicleJourneyRef mapped = new VehicleJourneyRef();
        mapped.setValue(vehicleJourneyRef.getValue());
        return mapped;
    }

    protected static SituationRef map(SituationRefStructure situationRefStructure) {
        SituationRef mapped = new SituationRef();
        mapped.setSituationSimpleRef(CommonMapper.map(situationRefStructure.getSituationSimpleRef()));
        return mapped;
    }

    protected static SituationSimpleRef map(SituationSimpleRefStructure situationSimpleRef) {
        SituationSimpleRef mapped = new SituationSimpleRef();
        mapped.setValue(situationSimpleRef.getValue());
        return mapped;
    }

    protected static SimpleContactStructure map(uk.org.siri.www.siri.SimpleContactStructure publicContact) {
        SimpleContactStructure mapped = new SimpleContactStructure();
        mapped.setPhoneNumber(publicContact.getPhoneNumber());
        mapped.setUrl(publicContact.getUrl());
        return mapped;
    }

    protected static GroupOfLinesRefStructure map(uk.org.siri.www.siri.GroupOfLinesRefStructure groupOfLinesRef) {
        GroupOfLinesRefStructure mapped = new GroupOfLinesRefStructure();
        mapped.setValue(groupOfLinesRef.getValue());
        return mapped;
    }

    protected static uk.org.siri.siri20.RouteRefStructure map(RouteRefStructure routeRef) {
        uk.org.siri.siri20.RouteRefStructure mapped = new uk.org.siri.siri20.RouteRefStructure();
        mapped.setValue(routeRef.getValue());
        return mapped;
    }

    protected static JourneyPatternRef map(JourneyPatternRefStructure journeyPatternRef) {
        JourneyPatternRef mapped = new JourneyPatternRef();
        mapped.setValue(journeyPatternRef.getValue());
        return mapped;
    }

    protected static DestinationRef map(DestinationRefStructure destinationRef) {
        DestinationRef mapped = new DestinationRef();
        mapped.setValue(destinationRef.getValue());
        return mapped;
    }

    protected static JourneyPlaceRefStructure map(uk.org.siri.www.siri.JourneyPlaceRefStructure originRef) {
        JourneyPlaceRefStructure mapped = new JourneyPlaceRefStructure();
        mapped.setValue(originRef.getValue());
        return mapped;
    }

    protected static ServiceFeatureRef map(ServiceFeatureRefStructure serviceFeatureRefStructure) {
        ServiceFeatureRef mapped = new ServiceFeatureRef();
        mapped.setValue(serviceFeatureRefStructure.getValue());
        return mapped;
    }

    protected static DatedVehicleJourneyRef map(DatedVehicleJourneyRefStructure datedVehicleJourneyRef) {
        DatedVehicleJourneyRef mapped = new DatedVehicleJourneyRef();
        if (datedVehicleJourneyRef.getValue() != null && !datedVehicleJourneyRef.getValue().isEmpty()) {
            mapped.setValue(datedVehicleJourneyRef.getValue());
        }
        return mapped;
    }

    protected static CountryRefStructure.Builder map(uk.org.ifopt.siri20.CountryRefStructure countryRefStructure) {
        CountryRefStructure.Builder builder = CountryRefStructure.newBuilder();
        if (countryRefStructure.getValue() != null) {
            builder.setValue(countryRefStructure.getValue().value());
        }
        return builder;
    }

    protected static uk.org.ifopt.siri20.CountryRefStructure map(CountryRefStructure countryRefStructure) {
        uk.org.ifopt.siri20.CountryRefStructure mapped = new uk.org.ifopt.siri20.CountryRefStructure();
        if (countryRefStructure.getValue() != null) {
            mapped.setValue(IanaCountryTldEnumeration.fromValue((String)countryRefStructure.getValue()));
        }
        return mapped;
    }

    protected static LocationStructure.Builder map(uk.org.siri.siri20.LocationStructure locationStructure) {
        LocationStructure.Builder builder = LocationStructure.newBuilder();
        if (locationStructure.getLatitude() != null) {
            builder.setLatitude(locationStructure.getLatitude().doubleValue());
        }
        if (locationStructure.getLongitude() != null) {
            builder.setLongitude(locationStructure.getLongitude().doubleValue());
        }
        if (locationStructure.getSrsName() != null && !locationStructure.getSrsName().isEmpty()) {
            builder.setSrsName(locationStructure.getSrsName());
        }
        return builder;
    }

    protected static uk.org.siri.siri20.LocationStructure map(LocationStructure locationStructure) {
        uk.org.siri.siri20.LocationStructure mapped = new uk.org.siri.siri20.LocationStructure();
        if (locationStructure.getLatitude() != 0.0 || locationStructure.getLongitude() != 0.0) {
            mapped.setLatitude(BigDecimal.valueOf(locationStructure.getLatitude()));
            mapped.setLongitude(BigDecimal.valueOf(locationStructure.getLongitude()));
        }
        if (locationStructure.getSrsName() != null && !locationStructure.getSrsName().isEmpty()) {
            mapped.setSrsName(locationStructure.getSrsName());
        }
        return mapped;
    }

    protected static Any.Builder map(Element any) {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            doc.adoptNode(any);
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = transfac.newTransformer();
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(doc);
            trans.transform(source, result);
            String xmlString = sw.toString();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder123 = factory.newDocumentBuilder();
            builder123.parse(new InputSource(new StringReader(xmlString)));
            Any.Builder builder = Any.newBuilder();
            return builder;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected static Element map(Any any) {
        try {
            ByteString value = any.getValue();
            byte[] bytes = value.toByteArray();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(bytes));
            return doc.getDocumentElement();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

